/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dialogue.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.util.IqaCSVUtils;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaExcelUtil;
import com.jxdinfo.hussar.dialogue.dao.QuestionBaseMapper;
import com.jxdinfo.hussar.dialogue.model.QuestionBaseModel;
import com.jxdinfo.hussar.dialogue.service.IQuestionBaseService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QuestionBaseServiceImpl
extends ServiceImpl<QuestionBaseMapper, QuestionBaseModel>
implements IQuestionBaseService {
    @Autowired
    private QuestionBaseMapper questionBaseMapper;
    @Resource
    private ISysDicSingleService sysDicSingleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> addOrUpdateQuestionBase(QuestionBaseModel questionBaseModel) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long questionId = questionBaseModel.getId();
        Timestamp date = new Timestamp(System.currentTimeMillis());
        SecurityUser user = BaseSecurityUtil.getUser();
        if (questionId == null) {
            questionBaseModel.setCreateTime(date);
            questionBaseModel.setLastTime(date);
            if (user != null) {
                questionBaseModel.setCreatetor(user.getId());
                questionBaseModel.setLastEditor(user.getId());
                questionBaseModel.setCreatorName(user.getUserName());
                questionBaseModel.setLastEditorName(user.getUserName());
            }
            questionBaseModel.setState("0");
            questionBaseModel.setDelFlag("0");
            this.save((Object)questionBaseModel);
            map.put("questionId", questionBaseModel.getId());
        } else {
            questionBaseModel.setLastTime(date);
            if (user != null) {
                questionBaseModel.setLastEditor(user.getId());
                questionBaseModel.setLastEditorName(user.getUserName());
            }
            this.updateById((Object)questionBaseModel);
            map.put("questionId", questionBaseModel.getId());
        }
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<Map<String, Object>> delQuestionBase(String questionBaseId) {
        String[] ids;
        for (String id : ids = questionBaseId.split(",")) {
            QuestionBaseModel questionBaseModel = (QuestionBaseModel)((Object)this.getById((Serializable)((Object)id)));
            questionBaseModel.setDelFlag("1");
            this.updateById((Object)questionBaseModel);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public ApiResponse<Page<QuestionBaseModel>> getAllData(Map<String, String> params) {
        Integer page = Integer.parseInt(params.get("page"));
        Integer size = Integer.parseInt(params.get("size"));
        Long businessId = Long.parseLong(params.get("businessId"));
        String qaName = params.get("qaName");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(QuestionBaseModel::getBusinessId, (Object)businessId)).eq(QuestionBaseModel::getDelFlag, (Object)0)).eq(QuestionBaseModel::getCreatetor, (Object)BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isNotEmpty((Object)qaName)) {
            queryWrapper.like(QuestionBaseModel::getQuestion, (Object)qaName);
        }
        queryWrapper.orderByDesc(QuestionBaseModel::getCreateTime);
        Page dataPage = new Page((long)page.intValue(), (long)size.intValue());
        return ApiResponse.success((Object)this.questionBaseMapper.selectPage((IPage)dataPage, (Wrapper)queryWrapper));
    }

    @Override
    public void download(HttpServletResponse response) {
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("qaMoudle/qaModel.xlsx")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IqaExcelUtil.exportExcelSeven2((HttpServletResponse)response, (Workbook)wb);
    }

    @Override
    public void upload(MultipartFile file, Long knowledgeBaseId) {
        List data = IqaExcelUtil.readExcelData((MultipartFile)file);
        Timestamp date = new Timestamp(System.currentTimeMillis());
        SecurityUser user = BaseSecurityUtil.getUser();
        for (Map row : data) {
            String question = (String)row.get("question");
            String answer = (String)row.get("answer");
            QuestionBaseModel questionBaseModel = new QuestionBaseModel();
            questionBaseModel.setBusinessId(knowledgeBaseId);
            questionBaseModel.setQuestion(question);
            questionBaseModel.setAnswer(answer);
            if (user != null) {
                questionBaseModel.setCreatetor(user.getId());
                questionBaseModel.setCreatorName(user.getUserName());
            }
            questionBaseModel.setCreateTime(date);
            questionBaseModel.setState("0");
            questionBaseModel.setDelFlag("0");
            this.save((Object)questionBaseModel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ApiResponse<Map<String, Object>> synchronizeData(Map<String, String> params) {
        Long businessId = Long.parseLong(params.get("businessId"));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(QuestionBaseModel::getBusinessId, (Object)businessId)).eq(QuestionBaseModel::getDelFlag, (Object)0);
        queryWrapper.orderByDesc(QuestionBaseModel::getCreateTime);
        List questionBaseModels = this.questionBaseMapper.selectList((Wrapper)queryWrapper);
        if (questionBaseModels.size() > 0) {
            try {
                void var14_19;
                Path path = Paths.get(System.getProperty("user.dir"), "temp", "questionBase");
                File csvFile = Paths.get(String.valueOf(path), "question.csv").toFile();
                if (!csvFile.getParentFile().exists()) {
                    boolean mkdir = csvFile.getParentFile().mkdirs();
                    HussarException.throwBy((!mkdir ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
                }
                String[] header = new String[]{"\u95ee\u9898", "\u7b54\u6848"};
                ArrayList<1> values = new ArrayList<1>();
                CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(header);
                for (final QuestionBaseModel model : questionBaseModels) {
                    ArrayList<String> colVals = new ArrayList<String>(){
                        {
                            this.add(model.getQuestion());
                            this.add(model.getAnswer());
                        }
                    };
                    values.add(colVals);
                }
                OutputStream outputStream = Files.newOutputStream(csvFile.toPath(), new OpenOption[0]);
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)osw, csvFormat);
                for (ArrayList arrayList : values) {
                    csvPrinter.printRecord((Iterable)arrayList);
                }
                csvPrinter.flush();
                outputStream.close();
                String url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u95ee\u7b54\u5e93\u540c\u6b65\u63a5\u53e3");
                String string = "";
                String msg = "";
                if (StringUtil.isNotEmpty((Object)url)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("knowledge_base_name", params.get("businessId"));
                    String result = IqaHttpClientUtil.httpAIFilePost((String)url, (File)csvFile, param, new HashMap());
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String string2 = jsonObject.getString("code");
                    msg = jsonObject.getString("msg");
                }
                if ("200".equals(var14_19)) {
                    IqaCSVUtils.deleteFile((Path)path);
                    for (QuestionBaseModel model : questionBaseModels) {
                        model.setState("1");
                    }
                    this.saveOrUpdateBatch(questionBaseModels);
                }
                return ApiResponse.success((String)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ApiResponse.fail((String)"\u540c\u6b65\u5931\u8d25");
            }
        }
        return ApiResponse.fail((String)"\u5217\u8868\u65e0\u6570\u636e");
    }
}

