/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dialogue.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ListLongTypeHandler
extends BaseTypeHandler<List<Long>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<Long> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter.stream().map(String::valueOf).collect(Collectors.joining(",")));
    }

    public List<Long> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return this.parseStringToList(value);
    }

    public List<Long> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseStringToList(rs.getString(columnIndex));
    }

    public List<Long> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseStringToList(cs.getString(columnIndex));
    }

    private List<Long> parseStringToList(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
    }
}

