/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dialogue.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.dialogue.model.Dialogue;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dialogue"})
public class DialogueController {
    @Resource
    private IDialogueService dialogueService;

    @PostMapping(value={"/addOrUpdateDialogue"})
    public ApiResponse<Map<String, Object>> addOrUpdateDialogue(@RequestBody Dialogue dialogue) {
        try {
            return this.dialogueService.addOrUpdateDialogue(dialogue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delDialogue"})
    public ApiResponse<Map<String, Object>> addDialogue(@RequestParam(value="dialogueId") Long dialogueId) {
        try {
            return this.dialogueService.delDialogue(dialogueId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getDialogueList"})
    public ApiResponse<List<Dialogue>> getDialogueList(@RequestBody Map<String, String> params) {
        try {
            return this.dialogueService.getDialogueList(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/addDialogueQa"})
    public ApiResponse<Map<String, Object>> addDialogueQa(@RequestBody DialogueQa dialogueQa) {
        try {
            return this.dialogueService.addDialogueQa(dialogueQa);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getDialogueInfo"})
    public ApiResponse<Map<String, Object>> getDialogueInfo(@RequestParam(value="dialogueId") Long dialogueId) {
        try {
            return this.dialogueService.getDialogueInfo(dialogueId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/feedback"})
    public ApiResponse<Map<String, Object>> feedback(@RequestBody Map param) {
        try {
            return this.dialogueService.feedback(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getallData"})
    public ApiResponse<Page<DialogueQa>> getallData(@RequestBody Map<String, String> params) {
        try {
            return this.dialogueService.getallData(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delDialogueQa"})
    public ApiResponse<Map<String, Object>> delDialogueQa(@RequestParam(value="qaId") String qaId) {
        try {
            return this.dialogueService.delDialogueQa(qaId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

