/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util.pdfUtil;

import com.jxdinfo.hussar.common.util.IqaFileConvertUtil;
import com.jxdinfo.hussar.common.util.IqaFileUtil;
import com.jxdinfo.hussar.common.util.IqaLibreOfficePDFConvert;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaCadUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaCebUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaExcelUtil;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaExceptionUtils;
import com.jxdinfo.hussar.common.util.pdfUtil.IqaffmpegUtil;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.VideoInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IqaChangeToPdfThread
extends Thread {
    public static final Logger LOGGER = LogManager.getLogger(IqaChangeToPdfThread.class);
    private String sourcePath;
    private String targetPath;
    private String suffix;

    public IqaChangeToPdfThread(String targetPath, String sourcePath, String suffix) {
        this.targetPath = targetPath;
        this.sourcePath = sourcePath;
        this.suffix = suffix;
    }

    @Override
    public void run() {
        LOGGER.info("******************\u6d4b\u8bd5:\u8fdb\u5165ChangeToPdfThread\u7ebf\u7a0b******************");
        File sourceFile = null;
        try {
            sourceFile = new File(this.sourcePath);
            String sourceName = sourceFile.getName();
            File pdfFile = null;
            if (sourceFile.exists()) {
                if ("csv".equals(this.suffix)) {
                    String xlsxFilePath = IqaFileUtil.getFileNameNoEx(this.sourcePath) + "." + "xlsx";
                    IqaFileConvertUtil.convertCSVToXLSX(this.sourcePath, xlsxFilePath);
                }
                if ("xls".equals(this.suffix)) {
                    pdfFile = new File(IqaFileUtil.getFileNameNoEx(this.sourcePath) + "." + "xlsx");
                    IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                }
                if (!("xls".equals(this.suffix) || "csv".equals(this.suffix) || "xlsx".equals(this.suffix))) {
                    pdfFile = new File(this.targetPath);
                    MagicMatch match = Magic.getMagicMatch((File)sourceFile, (boolean)false);
                    String contentType = match.getMimeType();
                    System.out.println("contentType:" + contentType);
                    if (sourceName.endsWith(".ceb")) {
                        IqaCebUtil.ceb2Pdf(sourceFile, pdfFile);
                    } else if (contentType.contains("cad")) {
                        IqaCadUtil.cad2Pdf(sourceFile, pdfFile);
                    } else if (contentType.contains("word") || contentType.contains("rtf") || contentType.contains("works")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if (contentType.contains("text/html") && (sourceName.endsWith(".doc") || sourceName.endsWith(".docx"))) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                        IqaExcelUtil.changeExcel(sourceName);
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourceName.endsWith(".txt")) {
                        String type = IqaChangeToPdfThread.getFilecharset(sourceFile);
                        if (type.equals("GBK") || type.equals("ANSI")) {
                            String str = FileUtils.readFileToString((File)sourceFile, (String)"GBK");
                            FileUtils.writeStringToFile((File)sourceFile, (String)str, (String)"UTF-8");
                        }
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if (contentType.contains("octet-stream") && sourceName.endsWith(".tif")) {
                        IqaLibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    } else if (contentType.contains("mp4") || contentType.contains("avi") || contentType.contains("wmv") || contentType.contains("mpg") || contentType.contains("mpeg") || contentType.contains("mov") || contentType.contains("swf") || contentType.contains("flv") || contentType.contains("ram") || contentType.contains("rm")) {
                        LOGGER.info("==========\u51c6\u5907\u89c6\u9891\u8f6c\u6362===========");
                        Encoder encoder = new Encoder();
                        MultimediaInfo info = encoder.getInfo(sourceFile);
                        VideoInfo video = info.getVideo();
                        String decoder = video.getDecoder();
                        if (!decoder.equals("h264") || contentType.contains("mov")) {
                            LOGGER.info("==========\u89c6\u9891\u5f00\u59cb\u8f6c\u6362===========");
                            this.targetPath = sourceName.substring(0, sourceName.lastIndexOf(".")) + "_new.mp4";
                            IqaffmpegUtil.convetor(sourceName, this.targetPath);
                            if (!IqaChangeToPdfThread.checkIsEmpty(this.targetPath) && !(pdfFile = new File(this.targetPath)).getParentFile().exists()) {
                                LOGGER.info("==========\u89c6\u9891===\u8def\u5f84\u4e0d\u5b58\u5728===========");
                                pdfFile.getParentFile().mkdirs();
                            }
                        }
                    } else {
                        LOGGER.info("==========\u6682\u4e0d\u652f\u6301\u8f6c\u6362===========");
                    }
                }
            } else {
                LOGGER.info("==========\u6587\u4ef6\u4e0d\u5b58\u5728===========");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u5316PDF\u5931\u8d25\uff1a" + IqaExceptionUtils.getErrorInfo(e));
        }
    }

    private static String getFilecharset(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }
}

