/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.service.impl;

import com.jxdinfo.hussar.chatbi.dto.TextVector;
import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import com.jxdinfo.hussar.chatbi.service.VectorStoreService;
import com.jxdinfo.hussar.chatbi.service.impl.ChatBIResourceService;
import com.jxdinfo.hussar.chatbi.util.FieldTypeUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UpdateValueAsyncService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateValueAsyncService.class);
    private final Map<String, Map<String, CompletableFuture<Void>>> updateTasks = new ConcurrentHashMap<String, Map<String, CompletableFuture<Void>>>();
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    @Resource
    private VectorStoreService vectorStoreService;
    @Resource
    private ChatBIResourceService chatBIResourceService;

    @Async
    public void addTaskBatch(List<FieldInfoSearchObj> fields, Long dataDomainId) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (FieldInfoSearchObj field : fields) {
            this.addTask(field, dataDomainId);
        }
    }

    @Async
    public synchronized void addTask(FieldInfoSearchObj field, Long dataDomainId) {
        if (field == null) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff0c\u65e0\u6cd5\u66f4\u65b0\u5b57\u6bb5/\u7ef4\u5ea6\u503c");
        }
        if (field.getDimension_id() == null) {
            field.setDimension_id("");
        }
        if (field.getField_id() == null) {
            field.setField_id("");
        }
        if (field.getDataset_id() == null) {
            field.setDataset_id("");
        }
        if (field.getDimension_id().isEmpty() && (field.getField_id().isEmpty() || field.getDataset_id().isEmpty())) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff0c\u65e0\u6cd5\u66f4\u65b0\u5b57\u6bb5/\u7ef4\u5ea6\u503c");
        }
        boolean isDimension = !field.getDimension_id().isEmpty();
        String taskId = isDimension ? "dimension-" + field.getDimension_id() : "field-" + field.getField_id();
        CompletableFuture exitedFuture = (CompletableFuture)this.updateTasks.computeIfAbsent(dataDomainId.toString(), k -> new ConcurrentHashMap()).get(taskId);
        if (exitedFuture != null) {
            return;
        }
        CompletionStage future = CompletableFuture.runAsync(() -> this.updateFieldOrDimensionValue(field, dataDomainId, isDimension), this.executor).whenComplete((res, ex) -> {
            this.updateTasks.get(dataDomainId.toString()).remove(taskId);
            if (this.updateTasks.get(dataDomainId.toString()).isEmpty()) {
                this.updateTasks.remove(dataDomainId.toString());
                logger.info("\u6570\u636e\u57df[{}] \u6240\u6709\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u79fb\u9664\u6570\u636e\u57df[{}] \u4efb\u52a1\u7ba1\u7406\u5668\u3002", (Object)dataDomainId, (Object)dataDomainId);
            }
            if (ex != null) {
                if (ex instanceof CancellationException) {
                    logger.info("\u6570\u636e\u57df[{}]\u4efb\u52a1[{}] \u5df2\u53d6\u6d88\u5b8c\u6210\u3002", (Object)dataDomainId, (Object)taskId);
                } else {
                    logger.info("\u6570\u636e\u57df[{}]\u4efb\u52a1[{}] \u5f02\u5e38\u5b8c\u6210\uff1a{}", new Object[]{dataDomainId, taskId, ex.getMessage()});
                }
            } else {
                logger.info("\u6570\u636e\u57df[{}]\u4efb\u52a1[{}] \u6b63\u5e38\u5b8c\u6210\u3002", (Object)dataDomainId, (Object)taskId);
            }
        });
        this.updateTasks.computeIfAbsent(dataDomainId.toString(), k -> new ConcurrentHashMap()).put(taskId, future);
        logger.info("\u6570\u636e\u57df[{}] \u4efb\u52a1[{}] \u5df2\u6dfb\u52a0\u3002", (Object)dataDomainId, (Object)taskId);
    }

    public void cancelUpdateFieldTaskBatch(List<String> fieldIds, Long dataDomainId) {
        if (fieldIds == null || fieldIds.isEmpty()) {
            return;
        }
        for (String fieldId : fieldIds) {
            this.cancelUpdateFieldTask(fieldId, dataDomainId);
        }
    }

    public void cancelUpdateFieldTask(String fieldId, Long dataDomainId) {
        this.cancelTask("field-" + fieldId, dataDomainId.toString());
    }

    public void cancelUpdateDimensionTask(String dimensionId, Long dataDomainId) {
        this.cancelTask("dimension-" + dimensionId, dataDomainId.toString());
    }

    private synchronized void cancelTask(String taskId, String dataDomainId) {
        if (!this.updateTasks.containsKey(dataDomainId)) {
            return;
        }
        CompletableFuture<Void> future = this.updateTasks.get(dataDomainId).get(taskId);
        if (future == null) {
            return;
        }
        try {
            future.cancel(true);
            future.join();
        }
        catch (CancellationException e) {
            logger.info("\u4efb\u52a1\u88ab\u53d6\u6d88: {}", (Object)e.getMessage());
        }
        catch (CompletionException e) {
            logger.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38: {}", (Object)e.getCause(), (Object)e);
        }
        catch (Exception e) {
            logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38: ", (Throwable)e);
        }
    }

    private void updateFieldOrDimensionValue(FieldInfoSearchObj field, Long dataDomainId, boolean isDimension) {
        List<String> values;
        List<String> oldValues;
        if (field == null) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (isDimension) {
            oldValues = this.vectorStoreService.queryDimensionValues(field.getDimension_id(), dataDomainId.toString());
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            values = this.chatBIResourceService.queryDimensionValue(field.getDimension_id(), dataDomainId);
        } else {
            oldValues = this.vectorStoreService.queryFieldValues(field.getField_id(), dataDomainId.toString());
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            values = this.chatBIResourceService.queryFieldValue(field.getField_id(), field.getDataset_id(), dataDomainId);
            if (!FieldTypeUtil.isString(field.getField_type()) && values.size() > 20) {
                values = values.subList(0, 20);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (oldValues == null) {
            oldValues = new ArrayList<String>();
        }
        ArrayList<String> toDelete = new ArrayList<String>(oldValues);
        toDelete.removeAll(values);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (!toDelete.isEmpty()) {
            if (isDimension) {
                this.vectorStoreService.deleteDimensionValues(field.getDimension_id(), toDelete, dataDomainId.toString());
            } else {
                this.vectorStoreService.deleteFieldValues(field.getField_id(), toDelete, dataDomainId.toString());
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ArrayList<String> toAdd = new ArrayList<String>(values);
        toAdd.removeAll(oldValues);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (!toAdd.isEmpty()) {
            int batchSize = 1000;
            int total = toAdd.size();
            int added = 0;
            for (int i = 0; i < toAdd.size(); i += batchSize) {
                int end = Math.min(i + batchSize, toAdd.size());
                List<String> batch = toAdd.subList(i, end);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                List<TextVector> vectors = this.chatBIResourceService.getVector(batch);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (isDimension) {
                    this.vectorStoreService.insertDimensionValueList(field.getDimension_id(), vectors, dataDomainId.toString());
                } else {
                    this.vectorStoreService.insertFieldValueList(field.getField_id(), vectors, dataDomainId.toString());
                }
                logger.info("\u65b0\u589e\u8fdb\u5ea6\uff1a\u5df2\u65b0\u589e {} / {}", (Object)(added += batch.size()), (Object)total);
            }
            logger.info("\u65b0\u589e\u4efb\u52a1\u5b8c\u6210\uff0c\u5171\u65b0\u589e {} \u6761", (Object)total);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
        this.updateTasks.clear();
        logger.info("\u4efb\u52a1\u7ba1\u7406\u5668\u5df2\u5173\u95ed");
    }
}

