/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;

public class JsonUtil {
    private static final Gson COMPACT_GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean isValidJson(String jsonStr) {
        if (jsonStr == null) {
            return false;
        }
        try {
            JsonParser.parseString((String)jsonStr);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    public static String toCompactJson(String jsonStr) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
            return COMPACT_GSON.toJson(jsonElement);
        }
        catch (JsonSyntaxException e) {
            return jsonStr;
        }
    }

    public static String toPrettyJson(String jsonStr) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
            return PRETTY_GSON.toJson(jsonElement);
        }
        catch (JsonSyntaxException e) {
            return jsonStr;
        }
    }
}

