/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jxdinfo.hussar.chatbi.config.ChatbiProperties;
import com.jxdinfo.hussar.chatbi.dao.DataDomainAuthInfoMapper;
import com.jxdinfo.hussar.chatbi.dto.TextVector;
import com.jxdinfo.hussar.chatbi.model.DataDomainAuthInfo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.core.exception.HussarException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class ChatBIResourceService {
    private static final Logger logger = LoggerFactory.getLogger(ChatBIResourceService.class);
    private final ChatbiProperties chatbiProperties;
    @Resource
    private DataDomainAuthInfoMapper dataDomainAuthInfoMapper;
    private ConcurrentHashMap<String, DataDomainAuthInfo> dataDomainInfoMap = new ConcurrentHashMap();

    public ChatBIResourceService(ChatbiProperties chatbiProperties) {
        this.chatbiProperties = chatbiProperties;
    }

    @PostConstruct
    public void init() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{DataDomainAuthInfo::getDataDomainId, DataDomainAuthInfo::getDataDomainCode, DataDomainAuthInfo::getClientId, DataDomainAuthInfo::getClientSecret, DataDomainAuthInfo::getAuthUrl, DataDomainAuthInfo::getQueryDimensionValueUrl, DataDomainAuthInfo::getIsAuth, HussarBaseEntity::getCreator});
        List list = this.dataDomainAuthInfoMapper.selectList((Wrapper)wrapper);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.dataDomainInfoMap = list.stream().collect(Collectors.toMap(DataDomainAuthInfo::getDataDomainCode, s -> s, (v1, v2) -> v1, ConcurrentHashMap::new));
    }

    public Flux<String> qaStream(Map<String, Object> params, Long dataDomainId, String demoFlag) {
        String url = "1".equals(demoFlag) ? this.chatbiProperties.getDemo().getQaStreamUrl() : this.chatbiProperties.getQaStreamUrl();
        WebClient webClient = WebClient.builder().baseUrl(url).build();
        return ((WebClient.RequestBodySpec)webClient.post().uri(uriBuilder -> uriBuilder.queryParam("dataDomainId", new Object[]{dataDomainId}).build(new Object[0]))).contentType(MediaType.APPLICATION_JSON).bodyValue(params).retrieve().bodyToFlux(String.class);
    }

    public Long getAdminId() {
        return this.chatbiProperties.getAdminId();
    }

    public Flux<String> dataAnalysis(Map<String, Object> params, String demoFlag) {
        String url = "1".equals(demoFlag) ? this.chatbiProperties.getDemo().getDataAnalysisUrl() : this.chatbiProperties.getDataAnalysisUrl();
        WebClient webClient = WebClient.builder().baseUrl(url).build();
        return webClient.post().contentType(MediaType.APPLICATION_JSON).bodyValue(params).retrieve().bodyToFlux(String.class);
    }

    public Map<String, Object> summarize(Map<String, Object> params, String demoFlag) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(params, (MultiValueMap)headers);
        String url = "1".equals(demoFlag) ? this.chatbiProperties.getDemo().getSummarizeUrl() : this.chatbiProperties.getSummarizeUrl();
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public Map<String, Object> qa(Map<String, Object> params, Long dataDomainId, String demoFlag) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(params, (MultiValueMap)headers);
        String url = "1".equals(demoFlag) ? this.chatbiProperties.getDemo().getQaUrl() : this.chatbiProperties.getQaUrl();
        ResponseEntity responseEntity = restTemplate.exchange(url + "?dataDomainId=" + dataDomainId, HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public String getClientToken(DataDomainAuthInfo dataDomainAuthInfo) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.add("client-id", dataDomainAuthInfo.getClientId());
        headers.add("client-secret", dataDomainAuthInfo.getClientSecret());
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        String url = dataDomainAuthInfo.getAuthUrl() + "?grant_type=client_credentials";
        try {
            String responseString = (String)restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
            if (responseString == null || responseString.isEmpty()) {
                throw new HussarException("\u83b7\u53d6client-token\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01");
            }
            JsonObject responseBody = JsonParser.parseString((String)responseString).getAsJsonObject();
            if (!responseBody.has("code") || responseBody.get("code").getAsInt() != 10000) {
                logger.error("\u8bf7\u6c42client-token\u51fa\u9519: " + responseString);
                throw new HussarException("\u83b7\u53d6client-token\u5931\u8d25\uff0cmessage: " + responseBody.get("msg").getAsString());
            }
            return responseBody.get("data").getAsJsonObject().get("client-token").getAsString();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6client-token\u5f02\u5e38", (Throwable)e);
            throw new HussarException("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u83b7\u53d6client-token\u5931\u8d25", (Throwable)e);
        }
    }

    public List<TextVector> getVector(List<String> texts) {
        Gson gson = new Gson();
        JsonObject request = new JsonObject();
        JsonArray contents = gson.toJsonTree(texts).getAsJsonArray();
        request.add("contents", (JsonElement)contents);
        String requestJson = gson.toJson((JsonElement)request);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        String responseBody = (String)restTemplate.postForObject(this.chatbiProperties.getEmbedding(), (Object)entity, String.class, new Object[0]);
        if (responseBody == null || responseBody.isEmpty()) {
            throw new HussarException("`" + texts.toString() + "`\u8ba1\u7b97\u5411\u91cf\u5931\u8d25");
        }
        List<List<Float>> denseVectors = this.parseVectors(responseBody);
        ArrayList<TextVector> vectors = new ArrayList<TextVector>();
        for (int i = 0; i < texts.size(); ++i) {
            TextVector textVector = new TextVector();
            textVector.setText(texts.get(i));
            textVector.setDenseVector(denseVectors.get(i));
            vectors.add(textVector);
        }
        return vectors;
    }

    public List<List<Float>> parseVectors(String input) {
        String[] vectorStrings;
        ArrayList<List<Float>> vectors = new ArrayList<List<Float>>();
        if (input == null || input.isEmpty()) {
            return vectors;
        }
        input = input.substring(1, input.length() - 1);
        for (String vecStr : vectorStrings = input.split("list_split")) {
            if (vecStr == null || vecStr.trim().isEmpty()) continue;
            String[] numberStrings = vecStr.split("\\|");
            ArrayList<Float> vector = new ArrayList<Float>();
            for (String numStr : numberStrings) {
                if ((numStr = numStr.trim()).isEmpty()) continue;
                try {
                    vector.add(Float.valueOf(Float.parseFloat(numStr)));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("\u5411\u91cf\u89e3\u6790\u5931\u8d25: \u975e\u6cd5\u6570\u5b57 '" + numStr + "'");
                }
            }
            vectors.add(vector);
        }
        return vectors;
    }

    public List<String> queryDimensionValue(String dimensionId, Long dataDomainId) {
        if (dimensionId == null || dimensionId.isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff0c\u7ef4\u5ea6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.queryFieldOrDimensionValue(dimensionId, "", "", dataDomainId);
    }

    public List<String> queryFieldValue(String fieldId, String datasetId, Long dataDomainId) {
        if (fieldId == null || fieldId.isEmpty() || datasetId == null || datasetId.isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff0c\u5b57\u6bb5id\u6216\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.queryFieldOrDimensionValue("", fieldId, datasetId, dataDomainId);
    }

    private List<String> queryFieldOrDimensionValue(String dimensionId, String fieldId, String datasetId, Long dataDomainId) {
        JsonObject responseBody;
        DataDomainAuthInfo dataDomainAuthInfo = (DataDomainAuthInfo)((Object)this.dataDomainAuthInfoMapper.selectById(dataDomainId));
        if (dataDomainAuthInfo == null) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u7ef4\u5ea6\u503c");
        }
        String requestUrl = dataDomainAuthInfo.getQueryDimensionValueUrl();
        HttpHeaders headers = new HttpHeaders();
        if ("1".equals(dataDomainAuthInfo.getIsAuth())) {
            headers.add("client-id", dataDomainAuthInfo.getClientId());
            headers.add("Authorization", this.getClientToken(dataDomainAuthInfo));
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("dimensionId", dimensionId);
        body.put("fieldId", fieldId);
        body.put("datasetId", datasetId);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        headers.setContentType(MediaType.APPLICATION_JSON);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(requestUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        String responseString = (String)responseEntity.getBody();
        if (responseString == null || responseString.isEmpty()) {
            throw new HussarException("\u8c03\u7528\u6307\u6807\u5e73\u53f0\u7684\u83b7\u53d6\u7ef4\u5ea6\u503c\u63a5\u53e3\u5f02\u5e38\uff1a\u65e0\u54cd\u5e94\u5185\u5bb9");
        }
        try {
            responseBody = JsonParser.parseString((String)responseString).getAsJsonObject();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6307\u6807\u5e73\u53f0\u7684\u83b7\u53d6\u7ef4\u5ea6\u503c\u63a5\u53e3\u5f02\u5e38\uff1a" + responseString, (Throwable)e);
            throw new HussarException("\u8c03\u7528\u6307\u6807\u5e73\u53f0\u7684\u83b7\u53d6\u7ef4\u5ea6\u503c\u63a5\u53e3\u5f02\u5e38\uff0cJSON\u89e3\u6790\u5931\u8d25\uff0c\u54cd\u5e94\uff1a" + responseString);
        }
        if (10000 != responseBody.get("code").getAsInt()) {
            logger.error(responseBody.toString());
            throw new HussarException("\u8c03\u7528\u6307\u6807\u5e73\u53f0\u7684\u83b7\u53d6\u7ef4\u5ea6\u503c\u63a5\u53e3\u5f02\u5e38\uff1a" + responseBody);
        }
        JsonArray values = responseBody.get("data").getAsJsonObject().get("data").getAsJsonArray();
        HashSet<String> valuesSet = new HashSet<String>();
        for (JsonElement element : values) {
            String value = element.getAsJsonObject().get("value").getAsString();
            if (value == null || value.isEmpty() || value.getBytes(StandardCharsets.UTF_8).length > 150) continue;
            valuesSet.add(value);
        }
        return new ArrayList<String>(valuesSet);
    }

    public boolean checkDataDomainCode(String dataDomainCode) {
        if (dataDomainCode == null || dataDomainCode.isEmpty()) {
            return false;
        }
        return this.dataDomainInfoMap.containsKey(dataDomainCode);
    }

    public void insertSystemAuthInfo(DataDomainAuthInfo dataDomainAuthInfo) {
        this.dataDomainInfoMap.put(dataDomainAuthInfo.getDataDomainCode(), this.getSystemInfoCatchData(dataDomainAuthInfo));
    }

    private DataDomainAuthInfo getSystemInfoCatchData(DataDomainAuthInfo dataDomainAuthInfo) {
        dataDomainAuthInfo.setDataDomainName(null);
        dataDomainAuthInfo.setDescription(null);
        dataDomainAuthInfo.setCreateTime(null);
        dataDomainAuthInfo.setLastEditor(null);
        dataDomainAuthInfo.setLastTime(null);
        return dataDomainAuthInfo;
    }

    public List<Long> getDataDomainIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        this.dataDomainInfoMap.forEach((k, v) -> list.add(v.getDataDomainId()));
        return list;
    }

    public Long getUserId(String dataDomainCode) {
        return this.dataDomainInfoMap.get(dataDomainCode).getCreator();
    }

    public Long getDataDomainId(String dataDomainCode) {
        return this.dataDomainInfoMap.get(dataDomainCode).getDataDomainId();
    }
}

