/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.service.impl;

import com.google.gson.Gson;
import com.jxdinfo.hussar.chatbi.dao.ChatBIMapper;
import com.jxdinfo.hussar.chatbi.dto.AddMetric;
import com.jxdinfo.hussar.chatbi.dto.AddTerm;
import com.jxdinfo.hussar.chatbi.dto.DatasetAndFieldInfos;
import com.jxdinfo.hussar.chatbi.dto.DatasetRelation;
import com.jxdinfo.hussar.chatbi.dto.QaPair;
import com.jxdinfo.hussar.chatbi.dto.SearchDatasetAndFieldsResult;
import com.jxdinfo.hussar.chatbi.dto.SearchDimensionResult;
import com.jxdinfo.hussar.chatbi.dto.SearchMetricAndDimensionResult;
import com.jxdinfo.hussar.chatbi.dto.TextVector;
import com.jxdinfo.hussar.chatbi.dto.result.DatasetInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionValueSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.MetricInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.TermInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.search.SearchBase;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetAndFields;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetFieldValue;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetFieldValueBatch;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDimension;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricAndDimension;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricDimensionValue;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricDimensionValueBatch;
import com.jxdinfo.hussar.chatbi.model.DataDomainAuthInfo;
import com.jxdinfo.hussar.chatbi.model.DatasetEntity;
import com.jxdinfo.hussar.chatbi.model.DimensionEntity;
import com.jxdinfo.hussar.chatbi.model.FieldEntity;
import com.jxdinfo.hussar.chatbi.model.MetricEntity;
import com.jxdinfo.hussar.chatbi.model.QaEntity;
import com.jxdinfo.hussar.chatbi.service.ChatBIApiService;
import com.jxdinfo.hussar.chatbi.service.ChatBIManagerService;
import com.jxdinfo.hussar.chatbi.service.VectorStoreService;
import com.jxdinfo.hussar.chatbi.service.impl.ChatBIResourceService;
import com.jxdinfo.hussar.chatbi.service.impl.UpdateValueAsyncService;
import com.jxdinfo.hussar.chatbi.util.FieldInfoCatch;
import com.jxdinfo.hussar.chatbi.util.FieldTypeUtil;
import com.jxdinfo.hussar.chatbi.util.JsonUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.vector.milvus.dto.QueryCollectionData;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;

@Service
public class ChatBIApiServiceImpl
implements ChatBIApiService {
    private final FieldInfoCatch fieldInfoCatch = new FieldInfoCatch();
    private static final ExecutorService executor = Executors.newFixedThreadPool(64);
    private static final Gson gson = new Gson();
    @Resource
    private ChatBIResourceService chatBIResourceService;
    @Resource
    private VectorStoreService vectorStoreService;
    @Resource
    private ChatBIMapper chatBiMapper;
    @Resource
    private IDialogueService dialogueService;
    @Lazy
    @Resource
    private ChatBIManagerService chatBIManagerService;
    @Resource
    private UpdateValueAsyncService updateValueAsyncService;

    @Override
    public Flux<String> qaStream(Map<String, Object> params, String dataDomainCode, String demoFlag) {
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.chatBIResourceService.qaStream(params, dataDomainId, demoFlag);
    }

    @Override
    public Map<String, Object> qa(Map<String, Object> params, String dataDomainCode, String demoFlag) {
        Map<Object, Object> responseBody;
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        Exception occurredException = null;
        try {
            responseBody = this.chatBIResourceService.qa(params, dataDomainId, demoFlag);
        }
        catch (Exception e) {
            responseBody = new HashMap();
            responseBody.put("error", "\u670d\u52a1\u5f02\u5e38");
            occurredException = e;
        }
        Map<Object, Object> finalResponseBody = responseBody;
        Exception finalOccurredException = occurredException;
        new Thread(() -> {
            DialogueQa qa = new DialogueQa();
            String question = (String)params.get("user_question");
            qa.setQuestions(question);
            qa.setQaType("3");
            HashMap<String, Object> record = new HashMap<String, Object>();
            if (finalOccurredException == null) {
                record.put("answer", finalResponseBody);
                qa.setResponseState("0");
            } else {
                qa.setResponseState("1");
                record.put("answer", finalResponseBody);
                String error = finalOccurredException.toString();
                if (error.length() > 1000) {
                    error = error.substring(0, 1000);
                }
                record.put("exception", error);
            }
            record.put("dataDomainId", dataDomainId);
            record.put("dataDomainCode", dataDomainCode);
            String recordJson = gson.toJson(record);
            qa.setAnswers(recordJson);
            Timestamp date = new Timestamp(System.currentTimeMillis());
            qa.setCreateTime((Date)date);
            Long userId = this.chatBIResourceService.getUserId(dataDomainCode);
            qa.setCreateUserId(userId.toString());
            qa.setCreateUserName(this.chatBiMapper.selectUserNameByUserId(userId));
            qa.setDialogueState("0");
            this.dialogueService.addQa(qa);
        }).start();
        if (occurredException != null) {
            throw new RuntimeException(occurredException);
        }
        return responseBody;
    }

    @Override
    public Map<String, Map<String, List<String>>> searchDimensionValueBatch(SearchMetricDimensionValueBatch params, Long dataDomainId) {
        if (params == null) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<CompletableFuture> futureList = new ArrayList<CompletableFuture>();
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(params.getText())).get(0);
        for (SearchMetricDimensionValueBatch.MetricAndDimension metricAndDimension : params.getMetric_dimension()) {
            CompletableFuture future = CompletableFuture.supplyAsync(() -> {
                List<String> result = this.searchFieldDimensionValuesByVector(true, metricAndDimension.getMetric_name(), metricAndDimension.getField_comment(), params.getSearch_type(), params.getTop_k(), params.getBm25_top_k(), params.getDense_params(), params.getBm25_params(), textVector, dataDomainId.toString());
                return new AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, List<String>>>(metricAndDimension.getMetric_name(), new AbstractMap.SimpleEntry<String, List<String>>(metricAndDimension.getField_comment(), result));
            }, executor);
            futureList.add(future);
        }
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>();
        for (CompletableFuture future : futureList) {
            Map.Entry entry = (Map.Entry)future.join();
            String metricName = (String)entry.getKey();
            String fieldComment = (String)((Map.Entry)entry.getValue()).getKey();
            List dimValues = (List)((Map.Entry)entry.getValue()).getValue();
            resultMap.computeIfAbsent(metricName, k -> new HashMap()).put(fieldComment, dimValues);
        }
        return resultMap;
    }

    @Override
    public Boolean deleteDatasetRelation(String datasetId, String relationId, String dataDomainCode) {
        if (datasetId == null || datasetId.isEmpty()) {
            throw new HussarException("\u4e3b\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (relationId == null || relationId.isEmpty()) {
            throw new HussarException("\u5173\u8054\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        return this.chatBiMapper.deleteDatasetRelationByMainDatasetIdAndRelatedDatasetId(datasetId, relationId, this.chatBIResourceService.getDataDomainId(dataDomainCode)) > 0;
    }

    @Override
    public Boolean addDatasetRelation(DatasetRelation datasetRelation, String dataDomainCode) {
        if (datasetRelation == null || datasetRelation.getDataset_id() == null || datasetRelation.getDataset_id().isEmpty()) {
            throw new HussarException("\u4e3b\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (datasetRelation.getRelation_id() == null || datasetRelation.getRelation_id().isEmpty()) {
            throw new HussarException("\u5173\u8054\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        for (String relationId : datasetRelation.getRelation_id()) {
            this.chatBiMapper.insertDatasetRelation(datasetRelation.getDataset_id(), relationId, dataDomainId);
        }
        return true;
    }

    @Override
    public List<String> searchTerm(SearchBase searchBase, Long dataDomainId) {
        if (searchBase == null || searchBase.getText() == null || searchBase.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchBase.getText())).get(0);
        List<TermInfoSearchObj> termInfoSearchObjs = this.vectorStoreService.searchTerm(searchBase.getSearch_type(), searchBase.getTop_k(), searchBase.getBm25_top_k(), searchBase.getDense_params(), searchBase.getBm25_params(), textVector, dataDomainId.toString());
        ArrayList<String> terms = new ArrayList<String>();
        for (TermInfoSearchObj termInfoSearchObj : termInfoSearchObjs) {
            terms.add(termInfoSearchObj.getTerm() + ":" + termInfoSearchObj.getExplanation());
        }
        return terms;
    }

    @Override
    public List<TermInfoSearchObj> termList(String dataDomainCode) {
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.vectorStoreService.termList(dataDomainId.toString());
    }

    @Override
    public Boolean deleteTerm(String termId, String dataDomainCode) {
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.chatBIManagerService.deleteTermBatch(Collections.singletonList(termId), dataDomainId);
    }

    @Override
    public Boolean updateTerm(TermInfoSearchObj term, String dataDomainCode) {
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.chatBIManagerService.updateTerm(term, dataDomainId);
    }

    @Override
    public boolean addTermBatch(List<AddTerm> terms, String dataDomainCode) {
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.chatBIManagerService.addTermBatch(terms, dataDomainId);
    }

    @Override
    public Boolean deleteDimension(String dimensionId, String dataDomainCode) {
        if (dimensionId == null || dimensionId.isEmpty()) {
            throw new HussarException("\u7ef4\u5ea6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        this.vectorStoreService.deleteDimensionAndValue(dimensionId, dataDomainId.toString());
        this.updateValueAsyncService.cancelUpdateDimensionTask(dimensionId, dataDomainId);
        return true;
    }

    @Override
    public Boolean upsertDimension(DimensionInfoSearchObj updateDimension, String dataDomainCode) {
        if (updateDimension == null || updateDimension.getDimension_id() == null || updateDimension.getDimension_id().isEmpty() || updateDimension.getDimension_name() == null || updateDimension.getDimension_name().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1aid\u548c\u7ef4\u5ea6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (updateDimension.getDimension_type() == null || updateDimension.getDimension_type().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FieldTypeUtil.checkFieldType(updateDimension.getDimension_type())) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        DimensionEntity oldData = this.vectorStoreService.queryDimension(updateDimension.getDimension_id(), dataDomainId.toString());
        if (oldData == null) {
            return this.addDimension(updateDimension, dataDomainCode);
        }
        DimensionEntity dimension = new DimensionEntity();
        dimension.setDimension_id(updateDimension.getDimension_id());
        dimension.setDimension_name(updateDimension.getDimension_name());
        dimension.setDimension_type(updateDimension.getDimension_type());
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(updateDimension.getDimension_name())).get(0);
        dimension.setDimension_name_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.updateDimension(dimension, dataDomainId.toString());
        return true;
    }

    @Override
    public Boolean addDimension(DimensionInfoSearchObj addDimension, String dataDomainCode) {
        if (addDimension == null || addDimension.getDimension_id() == null || addDimension.getDimension_id().isEmpty() || addDimension.getDimension_name() == null || addDimension.getDimension_name().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(addDimension.getDimension_name())).get(0);
        DimensionEntity dimensionEntity = new DimensionEntity();
        dimensionEntity.setDimension_id(addDimension.getDimension_id());
        dimensionEntity.setDimension_name(addDimension.getDimension_name());
        dimensionEntity.setDimension_type(addDimension.getDimension_type());
        dimensionEntity.setDimension_name_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.insertDimension(dimensionEntity, dataDomainId.toString());
        FieldInfoSearchObj fieldInfoSearchObj = new FieldInfoSearchObj();
        fieldInfoSearchObj.setDimension_id(addDimension.getDimension_id());
        fieldInfoSearchObj.setField_type(addDimension.getDimension_type());
        this.updateValueAsyncService.addTask(fieldInfoSearchObj, dataDomainId);
        return true;
    }

    @Override
    public List<String> searchMetricDimensionValue(SearchMetricDimensionValue searchParameter, Long dataDomainId) {
        if (searchParameter == null || searchParameter.getText() == null || searchParameter.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1atext\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (searchParameter.getMetric_name() == null || searchParameter.getMetric_name().isEmpty() || searchParameter.getField_comment() == null || searchParameter.getField_comment().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1ametric_name\u548cfield_comment\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchParameter.getText())).get(0);
        return this.searchFieldDimensionValuesByVector(true, searchParameter.getMetric_name(), searchParameter.getField_comment(), searchParameter.getSearch_type(), searchParameter.getTop_k(), searchParameter.getBm25_top_k(), searchParameter.getDense_params(), searchParameter.getBm25_params(), textVector, dataDomainId.toString());
    }

    private List<String> searchFieldDimensionValuesByVector(boolean isMetricDimension, String outerKey, String innerKey, String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        FieldInfoSearchObj fieldInfoSearchObj = isMetricDimension ? this.fieldInfoCatch.getMetricDimension(dataDomainId, outerKey, innerKey) : this.fieldInfoCatch.getDatasetField(dataDomainId, outerKey, innerKey);
        if (fieldInfoSearchObj == null) {
            return new ArrayList<String>();
        }
        if (fieldInfoSearchObj.getDimension_id() == null || fieldInfoSearchObj.getDimension_id().isEmpty()) {
            return this.vectorStoreService.searchFieldValues(searchType, topK, bm25TopK, searchParams, bm25Params, textVector, dataDomainId, fieldInfoSearchObj.getField_id());
        }
        return this.vectorStoreService.searchDimensionValues(searchType, topK, bm25TopK, searchParams, bm25Params, textVector, dataDomainId, fieldInfoSearchObj.getDimension_id());
    }

    @Override
    public List<SearchMetricAndDimensionResult> searchMetricAndDimension(SearchMetricAndDimension searchParameter, Long dataDomainId) {
        if (searchParameter == null || searchParameter.getText() == null || searchParameter.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1atext\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchParameter.getText())).get(0);
        List<MetricInfoSearchObj> resultList = this.vectorStoreService.searchMetric(searchParameter.getSearch_type(), searchParameter.getTop_k(), searchParameter.getBm25_top_k(), searchParameter.getDense_params(), searchParameter.getBm25_params(), textVector, dataDomainId.toString());
        if (searchParameter.getD_top_k() <= 0 && searchParameter.getD_bm25_top_k() <= 0) {
            ArrayList<SearchMetricAndDimensionResult> searchMetricAndDimensionResults = new ArrayList<SearchMetricAndDimensionResult>();
            for (MetricInfoSearchObj metricInfoSearchObj : resultList) {
                SearchMetricAndDimensionResult searchMetricAndDimensionResult = new SearchMetricAndDimensionResult();
                searchMetricAndDimensionResult.setMetric_name(metricInfoSearchObj.getMetric_name());
                searchMetricAndDimensionResult.setMetric_info(metricInfoSearchObj.getMetric_info());
                searchMetricAndDimensionResults.add(searchMetricAndDimensionResult);
            }
            return searchMetricAndDimensionResults;
        }
        return this.searchDimensionAsync(resultList, searchParameter, textVector, dataDomainId);
    }

    @Override
    public SearchDimensionResult searchDimension(SearchDimension searchDimension, Long dataDomainId) {
        MetricInfoSearchObj metric = this.vectorStoreService.queryMetricByName(searchDimension.getMetric_name(), dataDomainId.toString());
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchDimension.getText())).get(0);
        ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData = new ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>();
        SearchMetricAndDimensionResult result = this.getSearchMetricAndDimensionResult(searchDimension.getSearch_type(), searchDimension.getTop_k(), searchDimension.getBm25_top_k(), searchDimension.getDense_params(), searchDimension.getBm25_params(), textVector, dataDomainId, metric, cacheData);
        this.fieldInfoCatch.saveMetricDimensionResult(dataDomainId.toString(), cacheData);
        SearchDimensionResult searchDimensionResult = new SearchDimensionResult();
        searchDimensionResult.setDate_dimensions(result.getDate_dimensions());
        searchDimensionResult.setString_dimensions(result.getString_dimensions());
        searchDimensionResult.setNumber_dimensions(result.getNumber_dimensions());
        return searchDimensionResult;
    }

    public List<SearchMetricAndDimensionResult> searchDimensionAsync(List<MetricInfoSearchObj> metricInfoSearchObjs, SearchMetricAndDimension searchParameter, TextVector textVector, Long dataDomainId) {
        ArrayList<CompletableFuture<SearchMetricAndDimensionResult>> futureList = new ArrayList<CompletableFuture<SearchMetricAndDimensionResult>>();
        ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData = new ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>();
        String searchType = searchParameter.getD_search_type();
        int topK = searchParameter.getD_top_k();
        int bm25TopK = searchParameter.getD_bm25_top_k();
        Map<String, Object> denseParams = searchParameter.getD_dense_params();
        Map<String, Object> bm25Params = searchParameter.getD_bm25_params();
        for (MetricInfoSearchObj metric : metricInfoSearchObjs) {
            CompletableFuture<SearchMetricAndDimensionResult> future = CompletableFuture.supplyAsync(() -> this.getSearchMetricAndDimensionResult(searchType, topK, bm25TopK, denseParams, bm25Params, textVector, dataDomainId, metric, cacheData), executor);
            futureList.add(future);
        }
        List<SearchMetricAndDimensionResult> resultList = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
        this.fieldInfoCatch.saveMetricDimensionResult(dataDomainId.toString(), cacheData);
        return resultList;
    }

    private SearchMetricAndDimensionResult getSearchMetricAndDimensionResult(String searchType, int topK, int bm25TopK, Map<String, Object> denseParams, Map<String, Object> bm25Params, TextVector textVector, Long dataDomainId, MetricInfoSearchObj metric, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData) {
        String datasetId = metric.getDataset_id();
        boolean isCompositeMetric = datasetId.isEmpty();
        SearchMetricAndDimensionResult result = new SearchMetricAndDimensionResult();
        String metricName = metric.getMetric_name();
        result.setMetric_name(metricName);
        cacheData.putIfAbsent(metricName, new ConcurrentHashMap());
        result.setMetric_info(metric.getMetric_info());
        if (isCompositeMetric) {
            this.searchDimensionsForCompositeMetric(searchType, topK, bm25TopK, denseParams, bm25Params, textVector, dataDomainId, metric, cacheData, result);
        } else {
            this.searchDimensionsForNormalMetric(searchType, topK, bm25TopK, denseParams, bm25Params, textVector, dataDomainId, metric, cacheData, result);
        }
        return result;
    }

    private void searchDimensionsForCompositeMetric(String searchType, int topK, int bm25TopK, Map<String, Object> denseParams, Map<String, Object> bm25Params, TextVector textVector, Long dataDomainId, MetricInfoSearchObj metric, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData, SearchMetricAndDimensionResult result) {
        String metricName = metric.getMetric_name();
        String metricId = metric.getMetric_id();
        List<String> relatedDimensionIds = this.chatBiMapper.selectDimensionIdsByCompositeMetricId(metricId, dataDomainId);
        CompletableFuture<List> futureDimensionListForValue = CompletableFuture.supplyAsync(() -> this.searchCompositeDimensionsByValue(textVector, dataDomainId, relatedDimensionIds), executor);
        CompletableFuture<List> futureDimensions = CompletableFuture.supplyAsync(() -> this.vectorStoreService.searchCompositeMetricDimension(searchType, topK, bm25TopK, denseParams, bm25Params, textVector, dataDomainId.toString(), relatedDimensionIds), executor);
        CompletableFuture.allOf(futureDimensionListForValue, futureDimensions).join();
        List dimensionListForValue = futureDimensionListForValue.join();
        List dimensions = futureDimensions.join();
        dimensions.addAll(dimensionListForValue);
        HashSet<String> stringDimensions = new HashSet<String>();
        HashSet<String> numberDimensions = new HashSet<String>();
        HashSet<String> dateDimensions = new HashSet<String>();
        FieldTypeUtil.classifyDimensionNamesByType(stringDimensions, numberDimensions, dateDimensions, dimensions);
        result.setString_dimensions(stringDimensions);
        result.setNumber_dimensions(numberDimensions);
        result.setDate_dimensions(dateDimensions);
        for (DimensionInfoSearchObj dimension : dimensions) {
            FieldInfoSearchObj fieldInfoSearchObj = new FieldInfoSearchObj();
            fieldInfoSearchObj.setDimension_id(dimension.getDimension_id());
            cacheData.get(metricName).put(dimension.getDimension_name(), fieldInfoSearchObj);
        }
    }

    private List<DimensionInfoSearchObj> searchCompositeDimensionsByValue(TextVector textVector, Long dataDomainId, List<String> relatedDimensionIds) {
        List<DimensionInfoSearchObj> stringDimensionList = this.vectorStoreService.queryStringDimensionListByIds(relatedDimensionIds, dataDomainId.toString());
        List<String> stringDimIds = stringDimensionList.stream().map(DimensionInfoSearchObj::getDimension_id).collect(Collectors.toList());
        List<DimensionValueSearchObj> dimValueList = this.vectorStoreService.searchValues(null, stringDimIds, "dense", 10, 10, null, null, textVector, dataDomainId.toString());
        List dimensionIdsForValue = dimValueList.stream().map(DimensionValueSearchObj::getDimension_id).collect(Collectors.toList());
        List<DimensionInfoSearchObj> dimensionListForValue = stringDimensionList.stream().filter(d -> dimensionIdsForValue.contains(d.getDimension_id())).collect(Collectors.toList());
        return dimensionListForValue;
    }

    private void searchDimensionsForNormalMetric(String searchType, int topK, int bm25TopK, Map<String, Object> denseParams, Map<String, Object> bm25Params, TextVector textVector, Long dataDomainId, MetricInfoSearchObj metric, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData, SearchMetricAndDimensionResult result) {
        String metricName = metric.getMetric_name();
        String datasetId = metric.getDataset_id();
        List<String> allDatasetIds = this.chatBiMapper.selectAllRelatedDatasetIds(datasetId, dataDomainId);
        if (allDatasetIds == null) {
            allDatasetIds = new ArrayList<String>();
        }
        allDatasetIds.add(datasetId);
        List<String> finalAllDatasetIds = allDatasetIds;
        CompletableFuture<List> futureValueFieldList = CompletableFuture.supplyAsync(() -> this.searchDimensionsByValue(textVector, dataDomainId, metric, finalAllDatasetIds), executor);
        CompletableFuture<List> futureFieldListForSearch = CompletableFuture.supplyAsync(() -> this.vectorStoreService.searchFieldList(searchType, topK, bm25TopK, denseParams, bm25Params, textVector, dataDomainId.toString(), finalAllDatasetIds, metric.getTime_dimension_id()), executor);
        CompletableFuture.allOf(futureValueFieldList, futureFieldListForSearch).join();
        List valueFieldList = futureValueFieldList.join();
        List fieldListForSearch = futureFieldListForSearch.join();
        fieldListForSearch.addAll(valueFieldList);
        HashSet<String> stringDimensions = new HashSet<String>();
        HashSet<String> numberDimensions = new HashSet<String>();
        HashSet<String> dateDimensions = new HashSet<String>();
        FieldTypeUtil.classifyFieldCommentsByType(stringDimensions, numberDimensions, dateDimensions, fieldListForSearch);
        result.setString_dimensions(stringDimensions);
        result.setNumber_dimensions(numberDimensions);
        result.setDate_dimensions(dateDimensions);
        for (FieldInfoSearchObj fieldInfo : fieldListForSearch) {
            FieldInfoSearchObj fieldInfoSearchObj;
            if (fieldInfo.getDimension_id() != null && !fieldInfo.getDimension_id().isEmpty()) {
                fieldInfoSearchObj = new FieldInfoSearchObj();
                fieldInfoSearchObj.setDimension_id(fieldInfo.getDimension_id());
                cacheData.get(metricName).put(fieldInfo.getField_comment(), fieldInfoSearchObj);
                continue;
            }
            fieldInfoSearchObj = new FieldInfoSearchObj();
            fieldInfoSearchObj.setField_id(fieldInfo.getField_id());
            fieldInfoSearchObj.setDataset_id(fieldInfo.getDataset_id());
            cacheData.get(metricName).put(fieldInfo.getField_comment(), fieldInfoSearchObj);
        }
    }

    private List<FieldInfoSearchObj> searchDimensionsByValue(TextVector textVector, Long dataDomainId, MetricInfoSearchObj metric, List<String> allDatasetIds) {
        List<FieldInfoSearchObj> allStringFieldList = this.vectorStoreService.queryStringFieldListByDatasetIds(allDatasetIds, dataDomainId.toString());
        ArrayList<String> fieldIds = new ArrayList<String>();
        ArrayList<String> dimensionIds = new ArrayList<String>();
        for (FieldInfoSearchObj field : allStringFieldList) {
            if (field.getDimension_id() != null && !field.getDimension_id().isEmpty()) {
                dimensionIds.add(field.getDimension_id());
                continue;
            }
            fieldIds.add(field.getField_id());
        }
        fieldIds.remove(metric.getTime_dimension_id());
        List<DimensionValueSearchObj> dimValueList = this.vectorStoreService.searchValues(fieldIds, dimensionIds, "dense", 10, 10, null, null, textVector, dataDomainId.toString());
        ArrayList<String> fieldIdsForValue = new ArrayList<String>();
        ArrayList<String> dimensionIdsForValue = new ArrayList<String>();
        for (DimensionValueSearchObj dimValue : dimValueList) {
            if (dimValue.getDimension_id() != null && !dimValue.getDimension_id().isEmpty()) {
                dimensionIdsForValue.add(dimValue.getDimension_id());
                continue;
            }
            fieldIdsForValue.add(dimValue.getField_id());
        }
        ArrayList<FieldInfoSearchObj> valueFieldList = new ArrayList<FieldInfoSearchObj>();
        for (FieldInfoSearchObj field : allStringFieldList) {
            if (!fieldIdsForValue.contains(field.getField_id()) && !dimensionIdsForValue.contains(field.getDimension_id())) continue;
            valueFieldList.add(field);
        }
        return valueFieldList;
    }

    @Override
    public Flux<String> dataAnalysis(Map<String, Object> params, String demoFlag) {
        return this.chatBIResourceService.dataAnalysis(params, demoFlag);
    }

    @Override
    public boolean updateAllFieldAndDimensionValueAsync() {
        this.chatBIManagerService.updateAllFieldAndDimensionValueAsync();
        return true;
    }

    @Override
    public Map<String, Object> initDataDomain(DataDomainAuthInfo dataDomainAuthInfo) {
        dataDomainAuthInfo.setCreator(this.chatBIResourceService.getAdminId());
        return this.chatBIManagerService.initDataDomain(dataDomainAuthInfo);
    }

    @Override
    public boolean updateDataDomainInfo(DataDomainAuthInfo dataDomainAuthInfo) {
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainAuthInfo.getDataDomainCode());
        dataDomainAuthInfo.setDataDomainId(dataDomainId);
        dataDomainAuthInfo.setCreator(this.chatBIResourceService.getAdminId());
        return this.chatBIManagerService.updateDataDomainInfo(dataDomainAuthInfo);
    }

    @Override
    public boolean deleteDataDomainInfo(String dataDomainCode) {
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        return this.chatBIManagerService.deleteDataDomainInfo(dataDomainId);
    }

    @Override
    public Map<String, Object> summarize(Map<String, Object> params, String demoFlag) {
        return this.chatBIResourceService.summarize(params, demoFlag);
    }

    @Override
    public Boolean refreshCache(String dataDomainCode) {
        this.chatBIResourceService.init();
        List<Long> dataDomainIds = this.chatBIResourceService.getDataDomainIds();
        List<String> idStrList = dataDomainIds.stream().map(String::valueOf).collect(Collectors.toList());
        this.vectorStoreService.refresh(idStrList);
        if (dataDomainCode == null || dataDomainCode.isEmpty()) {
            return true;
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        this.vectorStoreService.refresh(dataDomainId.toString());
        return true;
    }

    @Override
    public Map<String, Map<String, List<String>>> searchDatasetFieldValueBatch(SearchDatasetFieldValueBatch params, Long dataDomainId) {
        if (params == null) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<CompletableFuture> futureList = new ArrayList<CompletableFuture>();
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(params.getText())).get(0);
        for (SearchDatasetFieldValueBatch.DatasetAndField datasetAndField : params.getDataset_field()) {
            CompletableFuture future = CompletableFuture.supplyAsync(() -> {
                List<String> result = this.searchFieldDimensionValuesByVector(false, datasetAndField.getDataset_name(), datasetAndField.getField_comment(), params.getSearch_type(), params.getTop_k(), params.getBm25_top_k(), params.getDense_params(), params.getBm25_params(), textVector, dataDomainId.toString());
                return new AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, List<String>>>(datasetAndField.getDataset_name(), new AbstractMap.SimpleEntry<String, List<String>>(datasetAndField.getField_comment(), result));
            }, executor);
            futureList.add(future);
        }
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>();
        for (CompletableFuture future : futureList) {
            Map.Entry entry = (Map.Entry)future.join();
            String datasetName = (String)entry.getKey();
            String fieldComment = (String)((Map.Entry)entry.getValue()).getKey();
            List fieldValues = (List)((Map.Entry)entry.getValue()).getValue();
            resultMap.computeIfAbsent(datasetName, k -> new HashMap()).put(fieldComment, fieldValues);
        }
        return resultMap;
    }

    @Override
    public List<String> searchDatasetFieldValue(SearchDatasetFieldValue searchParameters, Long dataDomainId) {
        if (searchParameters.getText() == null || searchParameters.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1atext\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (searchParameters.getDataset_name() == null || searchParameters.getDataset_name().isEmpty() || searchParameters.getField_comment() == null || searchParameters.getField_comment().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1adataset_name\u548cfield_comment\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchParameters.getText())).get(0);
        return this.searchFieldDimensionValuesByVector(false, searchParameters.getDataset_name(), searchParameters.getField_comment(), searchParameters.getSearch_type(), searchParameters.getTop_k(), searchParameters.getBm25_top_k(), searchParameters.getDense_params(), searchParameters.getBm25_params(), textVector, dataDomainId.toString());
    }

    @Override
    public List<SearchDatasetAndFieldsResult> searchDatasetAndField(SearchDatasetAndFields searchParameters, Long dataDomainId) {
        if (searchParameters == null || searchParameters.getText() == null || searchParameters.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchParameters.getText())).get(0);
        List<DatasetInfoSearchObj> datasetInfoSearchObjs = this.vectorStoreService.searchDataset(searchParameters.getSearch_type(), searchParameters.getTop_k(), searchParameters.getBm25_top_k(), searchParameters.getDense_params(), searchParameters.getBm25_params(), textVector, dataDomainId.toString());
        return this.searchFieldsAsync(datasetInfoSearchObjs, textVector, searchParameters, dataDomainId);
    }

    private List<SearchDatasetAndFieldsResult> searchFieldsAsync(List<DatasetInfoSearchObj> datasetInfoSearchObjs, TextVector textVector, SearchDatasetAndFields searchParameters, Long dataDomainId) {
        ArrayList<CompletableFuture<SearchDatasetAndFieldsResult>> futureList = new ArrayList<CompletableFuture<SearchDatasetAndFieldsResult>>();
        ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> cacheData = new ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>();
        for (DatasetInfoSearchObj dataset : datasetInfoSearchObjs) {
            CompletableFuture<SearchDatasetAndFieldsResult> future = CompletableFuture.supplyAsync(() -> {
                cacheData.putIfAbsent(dataset.getDataset_name(), new ConcurrentHashMap());
                List<String> allDatasetIds = this.chatBiMapper.selectAllRelatedDatasetIds(dataset.getDataset_id(), dataDomainId);
                if (allDatasetIds == null) {
                    allDatasetIds = new ArrayList<String>();
                }
                allDatasetIds.add(dataset.getDataset_id());
                List<FieldInfoSearchObj> fieldInfoSearchObjs = this.vectorStoreService.searchFieldList(searchParameters.getF_search_type(), searchParameters.getF_top_k(), searchParameters.getF_bm25_top_k(), searchParameters.getF_search_params(), searchParameters.getF_bm25_params(), textVector, dataDomainId.toString(), allDatasetIds, null);
                HashSet<String> stringFields = new HashSet<String>();
                HashSet<String> numberFields = new HashSet<String>();
                HashSet<String> dateFields = new HashSet<String>();
                FieldTypeUtil.classifyFieldCommentsByType(stringFields, numberFields, dateFields, fieldInfoSearchObjs);
                SearchDatasetAndFieldsResult result = new SearchDatasetAndFieldsResult();
                result.setDataset_name(dataset.getDataset_name());
                result.setDataset_info(dataset.getDataset_info());
                result.setString_fields(stringFields);
                result.setNumber_fields(numberFields);
                result.setDate_fields(dateFields);
                for (FieldInfoSearchObj fieldInfo : fieldInfoSearchObjs) {
                    FieldInfoSearchObj fieldInfoSearchObj = new FieldInfoSearchObj();
                    if (fieldInfo.getDimension_id() != null && !fieldInfo.getDimension_id().isEmpty()) {
                        fieldInfoSearchObj.setDimension_id(fieldInfo.getDimension_id());
                    } else {
                        fieldInfoSearchObj.setField_id(fieldInfo.getField_id());
                        fieldInfoSearchObj.setDataset_id(fieldInfo.getDataset_id());
                    }
                    ((ConcurrentHashMap)cacheData.get(dataset.getDataset_name())).put(fieldInfo.getField_comment(), fieldInfoSearchObj);
                }
                return result;
            }, executor);
            futureList.add(future);
        }
        List<SearchDatasetAndFieldsResult> results = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
        this.fieldInfoCatch.saveDatasetFieldResult(dataDomainId.toString(), cacheData);
        return results;
    }

    @Override
    public List<QaPair> searchQaPair(SearchBase searchBase, Long dataDomainId) {
        if (searchBase == null || searchBase.getText() == null || searchBase.getText().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1atext\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(searchBase.getText())).get(0);
        return this.vectorStoreService.searchQaPair(searchBase.getSearch_type(), searchBase.getTop_k(), searchBase.getBm25_top_k(), searchBase.getDense_params(), searchBase.getBm25_params(), textVector, dataDomainId.toString());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateDatasetRelation(DatasetRelation datasetRelation, String dataDomainCode) {
        if (datasetRelation == null || datasetRelation.getDataset_id() == null || datasetRelation.getDataset_id().isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff0c\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        this.chatBiMapper.deleteDatasetRelationByMainDatasetId(datasetRelation.getDataset_id(), dataDomainId);
        if (datasetRelation.getRelation_id() != null && !datasetRelation.getRelation_id().isEmpty()) {
            for (String relatedDatasetId : datasetRelation.getRelation_id()) {
                this.chatBiMapper.insertDatasetRelation(datasetRelation.getDataset_id(), relatedDatasetId, dataDomainId);
            }
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> queryCollectionData(QueryCollectionData queryCollectionData) {
        return this.vectorStoreService.queryCollectionData(queryCollectionData);
    }

    @Override
    public Boolean deleteQaPair(String question, String dataDomainCode) {
        if (question == null || question.isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        this.vectorStoreService.deleteQaPair(question, dataDomainId.toString());
        return true;
    }

    @Override
    public Boolean addQaPairBatch(List<QaPair> qaPairs, String dataDomainCode) {
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728\uff01");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        if (qaPairs == null || qaPairs.isEmpty()) {
            throw new HussarException("\u95ee\u7b54\u793a\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> questions = new ArrayList<String>();
        for (QaPair qaPair : qaPairs) {
            if (qaPair.getQuestion() == null || qaPair.getQuestion().isEmpty() || qaPair.getAnswer() == null || qaPair.getAnswer().isEmpty()) {
                throw new HussarException("\u95ee\u9898\u548c\u7b54\u6848\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!JsonUtil.isValidJson(qaPair.getAnswer())) {
                throw new HussarException("\u7b54\u6848\u5fc5\u987b\u662f\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32\uff01");
            }
            qaPair.setAnswer(JsonUtil.toCompactJson(qaPair.getAnswer()));
            this.vectorStoreService.deleteQaPair(qaPair.getQuestion(), dataDomainId.toString());
            questions.add(qaPair.getQuestion());
        }
        List<TextVector> textVectors = this.chatBIResourceService.getVector(questions);
        ArrayList<QaEntity> qaEntities = new ArrayList<QaEntity>();
        for (int i = 0; i < qaPairs.size(); ++i) {
            QaPair qaPair = qaPairs.get(i);
            TextVector textVector = textVectors.get(i);
            String id = UUID.randomUUID().toString().replace("-", "");
            QaEntity qaEntity = new QaEntity();
            qaEntity.setQa_id(id);
            qaEntity.setQuestion(qaPair.getQuestion());
            qaEntity.setAnswer(qaPair.getAnswer());
            qaEntity.setQuestion_dense_vector(textVector.getDenseVector());
            qaEntities.add(qaEntity);
        }
        this.vectorStoreService.insertQaPairList(qaEntities, dataDomainId.toString());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteDataset(String datasetId, String dataDomainCode) {
        if (datasetId == null || datasetId.isEmpty()) {
            throw new HussarException("\u6570\u636e\u96c6id\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        this.vectorStoreService.deleteDataset(datasetId, dataDomainId.toString());
        this.chatBiMapper.deleteDatasetRelation(datasetId, dataDomainId);
        List<String> fieldIds = this.vectorStoreService.queryFieldIdsByDatasetId(datasetId, dataDomainId.toString());
        if (!fieldIds.isEmpty()) {
            this.chatBiMapper.deleteMetricsByFieldIds(fieldIds, dataDomainId);
            this.vectorStoreService.deleteFieldAndValue(fieldIds, dataDomainId.toString());
            this.updateValueAsyncService.cancelUpdateFieldTaskBatch(fieldIds, dataDomainId);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteMetric(String metricId, String dataDomainCode) {
        if (metricId == null || metricId.isEmpty()) {
            throw new HussarException("\u6307\u6807id\u4e3a\u7a7a\uff01");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        MetricEntity metricEntity = this.vectorStoreService.queryVMetric(metricId, dataDomainId.toString());
        if (metricEntity == null) {
            throw new HussarException("\u6307\u6807\u4e0d\u5b58\u5728");
        }
        String datasetId = metricEntity.getDataset_id();
        if (datasetId == null || datasetId.isEmpty()) {
            this.chatBiMapper.deleteCompositeMetricRelationByMetricId(metricId, dataDomainId);
        } else {
            this.chatBiMapper.deleteMetric(metricId, dataDomainId);
        }
        this.vectorStoreService.deleteMetric(metricId, dataDomainId.toString());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean upsertMetric(AddMetric updateMetric, String dataDomainCode) {
        if (updateMetric == null) {
            throw new HussarException("\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
        }
        if (updateMetric.getMetric_id() == null || updateMetric.getMetric_id().isEmpty()) {
            throw new HussarException("\u6307\u6807id\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        boolean isCompositeMetric = updateMetric.getDataset_id() == null || updateMetric.getDataset_id().isEmpty();
        MetricEntity oldData = this.vectorStoreService.queryVMetric(updateMetric.getMetric_id(), dataDomainId.toString());
        if (oldData == null) {
            return this.addMetric(updateMetric, dataDomainCode);
        }
        if (isCompositeMetric) {
            this.chatBiMapper.deleteCompositeMetricRelationByMetricId(updateMetric.getMetric_id(), dataDomainId);
            if (updateMetric.getAnalysis_dimension() != null && !updateMetric.getAnalysis_dimension().isEmpty()) {
                for (String analysisDimensionId : updateMetric.getAnalysis_dimension()) {
                    this.chatBiMapper.insertCompositeMetricAndDimensionRelation(updateMetric.getMetric_id(), analysisDimensionId, dataDomainId);
                }
            }
        } else {
            this.chatBiMapper.deleteMetric(updateMetric.getMetric_id(), dataDomainId);
            if (updateMetric.getAnalysis_dimension() != null && !updateMetric.getAnalysis_dimension().isEmpty()) {
                for (String analysisDimensionId : updateMetric.getAnalysis_dimension()) {
                    this.chatBiMapper.insertMetricAndAnalysisDimension(updateMetric.getMetric_id(), analysisDimensionId, dataDomainId);
                }
            }
        }
        MetricEntity metricEntity = new MetricEntity();
        metricEntity.setMetric_name(updateMetric.getMetric_name());
        metricEntity.setMetric_info(updateMetric.getMetric_info());
        metricEntity.setDataset_id(updateMetric.getDataset_id() == null ? "" : updateMetric.getDataset_id());
        metricEntity.setMetric_id(updateMetric.getMetric_id());
        metricEntity.setTime_dimension_id(updateMetric.getTime_dimension_id() == null ? "" : updateMetric.getTime_dimension_id());
        List<TextVector> textVectors = this.chatBIResourceService.getVector(Arrays.asList(updateMetric.getMetric_name(), updateMetric.getMetric_info()));
        metricEntity.setMetric_name_dense_vector(textVectors.get(0).getDenseVector());
        metricEntity.setMetric_info_dense_vector(textVectors.get(1).getDenseVector());
        this.vectorStoreService.updateMetric(metricEntity, dataDomainId.toString());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean addMetric(AddMetric addMetric, String dataDomainCode) {
        boolean isCompositeMetric;
        if (addMetric == null) {
            throw new HussarException("\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
        }
        if (addMetric.getMetric_id() == null || addMetric.getMetric_id().isEmpty()) {
            throw new HussarException("\u6307\u6807id\u4e3a\u7a7a");
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        boolean bl = isCompositeMetric = addMetric.getDataset_id() == null || addMetric.getDataset_id().isEmpty();
        if (addMetric.getAnalysis_dimension() != null && !addMetric.getAnalysis_dimension().isEmpty()) {
            if (isCompositeMetric) {
                for (String analysisDimensionId : addMetric.getAnalysis_dimension()) {
                    this.chatBiMapper.insertCompositeMetricAndDimensionRelation(addMetric.getMetric_id(), analysisDimensionId, dataDomainId);
                }
            } else {
                for (String analysisDimensionId : addMetric.getAnalysis_dimension()) {
                    this.chatBiMapper.insertMetricAndAnalysisDimension(addMetric.getMetric_id(), analysisDimensionId, dataDomainId);
                }
            }
        }
        MetricEntity metricEntity = new MetricEntity();
        metricEntity.setMetric_id(addMetric.getMetric_id());
        metricEntity.setMetric_name(addMetric.getMetric_name());
        metricEntity.setMetric_info(addMetric.getMetric_info());
        metricEntity.setDataset_id(addMetric.getDataset_id() == null ? "" : addMetric.getDataset_id());
        metricEntity.setTime_dimension_id(addMetric.getTime_dimension_id() == null ? "" : addMetric.getTime_dimension_id());
        List<TextVector> textVectors = this.chatBIResourceService.getVector(Arrays.asList(addMetric.getMetric_name(), addMetric.getMetric_info()));
        metricEntity.setMetric_name_dense_vector(textVectors.get(0).getDenseVector());
        metricEntity.setMetric_info_dense_vector(textVectors.get(1).getDenseVector());
        this.vectorStoreService.insertMetric(metricEntity, dataDomainId.toString());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean addDatasetAndFieldInfos(DatasetAndFieldInfos datasetAndFieldInfos, String dataDomainCode) {
        if (datasetAndFieldInfos == null) {
            throw new HussarException("\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
        }
        if (datasetAndFieldInfos.getDataset_id() == null || datasetAndFieldInfos.getDataset_id().isEmpty()) {
            throw new HussarException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (datasetAndFieldInfos.getDataset_name() == null || datasetAndFieldInfos.getDataset_name().isEmpty()) {
            throw new HussarException("\u6570\u636e\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (datasetAndFieldInfos.getField_list() != null) {
            for (FieldInfoSearchObj field : datasetAndFieldInfos.getField_list()) {
                if (field.getField_id() == null || field.getField_id().isEmpty() || field.getField_comment() == null || field.getField_comment().isEmpty() || field.getField_type() == null || field.getField_type().isEmpty()) {
                    throw new HussarException("\u5b57\u6bb5id\u3001\u5b57\u6bb5\u63cf\u8ff0\u3001\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (FieldTypeUtil.checkFieldType(field.getField_type())) continue;
                throw new HussarException("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5408\u6cd5");
            }
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        DatasetEntity datasetEntity = new DatasetEntity();
        datasetEntity.setDataset_id(datasetAndFieldInfos.getDataset_id());
        datasetEntity.setDataset_name(datasetAndFieldInfos.getDataset_name());
        datasetEntity.setDataset_info(datasetAndFieldInfos.getDataset_info() == null ? "" : datasetAndFieldInfos.getDataset_info());
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(datasetAndFieldInfos.getDataset_name() + ":" + datasetAndFieldInfos.getDataset_info())).get(0);
        datasetEntity.setDataset_name_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.insertDataset(datasetEntity, dataDomainId.toString());
        if (datasetAndFieldInfos.getRelation_id() != null && !datasetAndFieldInfos.getRelation_id().isEmpty()) {
            for (String relatedDatasetId : datasetAndFieldInfos.getRelation_id()) {
                this.chatBiMapper.insertDatasetRelation(datasetAndFieldInfos.getDataset_id(), relatedDatasetId, dataDomainId);
            }
        }
        if (datasetAndFieldInfos.getField_list() == null || datasetAndFieldInfos.getField_list().isEmpty()) {
            return true;
        }
        List<FieldInfoSearchObj> fieldList = datasetAndFieldInfos.getField_list();
        ArrayList<FieldEntity> fieldVectorObjs = new ArrayList<FieldEntity>();
        ArrayList<String> vectorStrList = new ArrayList<String>();
        for (FieldInfoSearchObj fieldInfo : fieldList) {
            vectorStrList.add(fieldInfo.getField_comment());
            fieldInfo.setDataset_id(datasetAndFieldInfos.getDataset_id());
            if (fieldInfo.getDimension_id() != null) continue;
            fieldInfo.setDimension_id("");
        }
        List<TextVector> textVectors = this.chatBIResourceService.getVector(vectorStrList);
        for (int i = 0; i < fieldList.size(); ++i) {
            FieldInfoSearchObj fieldInfoSearchObj = fieldList.get(i);
            FieldEntity fieldEntity = new FieldEntity();
            fieldEntity.setField_id(fieldInfoSearchObj.getField_id());
            fieldEntity.setField_comment(fieldInfoSearchObj.getField_comment());
            fieldEntity.setField_type(fieldInfoSearchObj.getField_type());
            fieldEntity.setDataset_id(datasetAndFieldInfos.getDataset_id());
            fieldEntity.setDimension_id(fieldInfoSearchObj.getDimension_id());
            fieldEntity.setField_comment_dense_vector(textVectors.get(i).getDenseVector());
            fieldVectorObjs.add(fieldEntity);
        }
        this.vectorStoreService.insertFieldList(fieldVectorObjs, dataDomainId.toString());
        this.updateValueAsyncService.addTaskBatch(fieldList, dataDomainId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateDatasetAndFieldInfos(DatasetAndFieldInfos datasetAndFieldInfos, String dataDomainCode) {
        if (datasetAndFieldInfos == null) {
            throw new HussarException("\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
        }
        if (datasetAndFieldInfos.getDataset_id() == null || datasetAndFieldInfos.getDataset_id().isEmpty()) {
            throw new HussarException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (datasetAndFieldInfos.getDataset_name() == null || datasetAndFieldInfos.getDataset_name().isEmpty()) {
            throw new HussarException("\u6570\u636e\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (datasetAndFieldInfos.getField_list() != null) {
            for (FieldInfoSearchObj field : datasetAndFieldInfos.getField_list()) {
                if (field.getField_id() == null || field.getField_id().isEmpty() || field.getField_comment() == null || field.getField_comment().isEmpty() || field.getField_type() == null || field.getField_type().isEmpty()) {
                    throw new HussarException("\u5b57\u6bb5id\u3001\u5b57\u6bb5\u63cf\u8ff0\u3001\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (FieldTypeUtil.checkFieldType(field.getField_type())) continue;
                throw new HussarException("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5408\u6cd5");
            }
        }
        if (!this.chatBIResourceService.checkDataDomainCode(dataDomainCode)) {
            throw new HussarException("\u6570\u636e\u57df\u4e0d\u5b58\u5728");
        }
        Long dataDomainId = this.chatBIResourceService.getDataDomainId(dataDomainCode);
        DatasetEntity datasetEntity = new DatasetEntity();
        datasetEntity.setDataset_id(datasetAndFieldInfos.getDataset_id());
        datasetEntity.setDataset_name(datasetAndFieldInfos.getDataset_name());
        datasetEntity.setDataset_info(datasetAndFieldInfos.getDataset_info() == null ? "" : datasetAndFieldInfos.getDataset_info());
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(datasetAndFieldInfos.getDataset_name() + ":" + datasetAndFieldInfos.getDataset_info())).get(0);
        datasetEntity.setDataset_name_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.updateDataset(datasetEntity, dataDomainId.toString());
        List<FieldEntity> oldFieldEntities = this.vectorStoreService.queryVFieldListByDatasetId(datasetAndFieldInfos.getDataset_id(), dataDomainId.toString());
        HashMap<String, FieldEntity> oldFieldInfosMap = new HashMap<String, FieldEntity>();
        ArrayList<String> oldFieldIds = new ArrayList<String>();
        for (FieldEntity fieldEntity : oldFieldEntities) {
            oldFieldInfosMap.put(fieldEntity.getField_id(), fieldEntity);
            oldFieldIds.add(fieldEntity.getField_id());
        }
        ArrayList<String> newFieldIds = new ArrayList<String>();
        if (datasetAndFieldInfos.getField_list() != null) {
            for (FieldInfoSearchObj fieldInfoSearchObj : datasetAndFieldInfos.getField_list()) {
                newFieldIds.add(fieldInfoSearchObj.getField_id());
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(oldFieldIds);
        arrayList.removeAll(newFieldIds);
        if (!arrayList.isEmpty()) {
            this.chatBiMapper.deleteMetricsByFieldIds(arrayList, dataDomainId);
            this.vectorStoreService.deleteFieldAndValue(arrayList, dataDomainId.toString());
            this.updateValueAsyncService.cancelUpdateFieldTaskBatch(arrayList, dataDomainId);
        }
        ArrayList<FieldEntity> fieldToAdd = new ArrayList<FieldEntity>();
        ArrayList<FieldEntity> fieldToUpdate = new ArrayList<FieldEntity>();
        ArrayList<FieldInfoSearchObj> addFieldList = new ArrayList<FieldInfoSearchObj>();
        ArrayList<String> updateFieldIdList = new ArrayList<String>();
        for (FieldInfoSearchObj fieldInfoSearchObj : datasetAndFieldInfos.getField_list()) {
            FieldEntity oldFieldEntity;
            if (fieldInfoSearchObj.getDimension_id() == null) {
                fieldInfoSearchObj.setDimension_id("");
            }
            if ((oldFieldEntity = (FieldEntity)oldFieldInfosMap.get(fieldInfoSearchObj.getField_id())) == null) {
                TextVector fieldInsertTextVector = this.chatBIResourceService.getVector(Collections.singletonList(fieldInfoSearchObj.getField_comment())).get(0);
                FieldEntity newFieldEntity = new FieldEntity();
                newFieldEntity.setField_id(fieldInfoSearchObj.getField_id());
                newFieldEntity.setField_comment(fieldInfoSearchObj.getField_comment());
                newFieldEntity.setDataset_id(datasetAndFieldInfos.getDataset_id());
                newFieldEntity.setDimension_id(fieldInfoSearchObj.getDimension_id());
                newFieldEntity.setField_type(fieldInfoSearchObj.getField_type());
                newFieldEntity.setField_comment_dense_vector(fieldInsertTextVector.getDenseVector());
                newFieldEntity.setDataset_id(datasetAndFieldInfos.getDataset_id());
                fieldToAdd.add(newFieldEntity);
                FieldInfoSearchObj addFieldSearchObj = new FieldInfoSearchObj();
                addFieldSearchObj.setField_id(fieldInfoSearchObj.getField_id());
                addFieldSearchObj.setField_comment(fieldInfoSearchObj.getField_comment());
                addFieldSearchObj.setField_type(fieldInfoSearchObj.getField_type());
                addFieldSearchObj.setDataset_id(datasetAndFieldInfos.getDataset_id());
                addFieldSearchObj.setDimension_id(fieldInfoSearchObj.getDimension_id());
                addFieldList.add(addFieldSearchObj);
                continue;
            }
            boolean isUpdated = false;
            if (!Objects.equals(oldFieldEntity.getField_comment(), fieldInfoSearchObj.getField_comment())) {
                isUpdated = true;
                oldFieldEntity.setField_comment(fieldInfoSearchObj.getField_comment());
                TextVector updateFieldTextVector = this.chatBIResourceService.getVector(Collections.singletonList(fieldInfoSearchObj.getField_comment())).get(0);
                oldFieldEntity.setField_comment_dense_vector(updateFieldTextVector.getDenseVector());
            }
            if (!Objects.equals(oldFieldEntity.getDimension_id(), fieldInfoSearchObj.getDimension_id())) {
                isUpdated = true;
                oldFieldEntity.setDimension_id(fieldInfoSearchObj.getDimension_id());
                FieldInfoSearchObj addFieldSearchObj = new FieldInfoSearchObj();
                addFieldSearchObj.setField_id(fieldInfoSearchObj.getField_id());
                addFieldSearchObj.setField_comment(fieldInfoSearchObj.getField_comment());
                addFieldSearchObj.setField_type(fieldInfoSearchObj.getField_type());
                addFieldSearchObj.setDataset_id(datasetAndFieldInfos.getDataset_id());
                addFieldSearchObj.setDimension_id(fieldInfoSearchObj.getDimension_id());
                addFieldList.add(addFieldSearchObj);
                if (!fieldInfoSearchObj.getDimension_id().isEmpty()) {
                    updateFieldIdList.add(fieldInfoSearchObj.getField_id());
                }
            }
            if (!Objects.equals(oldFieldEntity.getField_type(), fieldInfoSearchObj.getField_type())) {
                isUpdated = true;
                oldFieldEntity.setField_type(fieldInfoSearchObj.getField_type());
            }
            if (!isUpdated) continue;
            fieldToUpdate.add(oldFieldEntity);
        }
        if (!updateFieldIdList.isEmpty()) {
            this.vectorStoreService.deleteFieldValuesByFieldIds(updateFieldIdList, dataDomainId.toString());
        }
        if (!fieldToAdd.isEmpty()) {
            this.vectorStoreService.insertFieldList(fieldToAdd, dataDomainId.toString());
        }
        if (!addFieldList.isEmpty()) {
            this.updateValueAsyncService.addTaskBatch(addFieldList, dataDomainId);
        }
        if (!fieldToUpdate.isEmpty()) {
            this.vectorStoreService.updateFieldList(fieldToUpdate, dataDomainId.toString());
        }
        return true;
    }
}

