/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.config;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogApiDetailAspect {
    private static final Logger logger = LoggerFactory.getLogger(LogApiDetailAspect.class);

    @Around(value="execution(public * com.jxdinfo.hussar.chatbi.controller.ChatBIApiController.*(..))")
    public Object logApiDetail(ProceedingJoinPoint joinPoint) throws Throwable {
        Object data;
        Object result;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        String methodName = signature.getName();
        Object[] args = joinPoint.getArgs();
        logger.info("\u3010\u63a5\u53e3\u8c03\u7528\u3011{}.{} \u5165\u53c2\uff1a{}", new Object[]{className, methodName, Arrays.toString(args)});
        long startTime = System.currentTimeMillis();
        try {
            result = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            logger.error("\u3010\u63a5\u53e3\u5f02\u5e38\u3011{}.{} \u5f02\u5e38\uff1a{}", new Object[]{className, methodName, throwable.getMessage(), throwable});
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        if (result instanceof ApiResponse) {
            ApiResponse apiResponse = (ApiResponse)result;
            data = apiResponse.getData();
        } else {
            data = result;
        }
        logger.info("\u3010\u63a5\u53e3\u8c03\u7528\u3011{}.{} \u51fa\u53c2\uff1a{}", new Object[]{className, methodName, data.toString()});
        long diff = endTime - startTime;
        if (diff > 5000L) {
            logger.error("\u3010\u63a5\u53e3\u8c03\u7528\u3011{}.{} \u8017\u65f6\uff1a{} ms", new Object[]{className, methodName, diff});
        } else {
            logger.info("\u3010\u63a5\u53e3\u8c03\u7528\u3011{}.{} \u7528\u65f6\uff1a{} ms", new Object[]{className, methodName, diff});
        }
        return result;
    }
}

