/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.chatbi.dao.ChatBIMapper;
import com.jxdinfo.hussar.chatbi.dao.DataDomainAuthInfoMapper;
import com.jxdinfo.hussar.chatbi.dto.AddTerm;
import com.jxdinfo.hussar.chatbi.dto.QaPair;
import com.jxdinfo.hussar.chatbi.dto.TextVector;
import com.jxdinfo.hussar.chatbi.dto.result.DatasetInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.MetricInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.QaInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.TermInfoSearchObj;
import com.jxdinfo.hussar.chatbi.model.DataDomainAuthInfo;
import com.jxdinfo.hussar.chatbi.model.QaEntity;
import com.jxdinfo.hussar.chatbi.model.TermEntity;
import com.jxdinfo.hussar.chatbi.service.ChatBIManagerService;
import com.jxdinfo.hussar.chatbi.service.VectorStoreService;
import com.jxdinfo.hussar.chatbi.service.impl.ChatBIResourceService;
import com.jxdinfo.hussar.chatbi.service.impl.UpdateValueAsyncService;
import com.jxdinfo.hussar.chatbi.util.JsonUtil;
import com.jxdinfo.hussar.chatbi.vo.MetricPageObj;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.core.exception.HussarException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatBIManagerServiceImpl
implements ChatBIManagerService {
    private static final Logger logger = LoggerFactory.getLogger(ChatBIManagerServiceImpl.class);
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    @Resource
    private ChatBIResourceService chatBIResourceService;
    @Resource
    private VectorStoreService vectorStoreService;
    @Resource
    private ChatBIMapper chatBiMapper;
    @Resource
    private DataDomainAuthInfoMapper dataDomainAuthInfoMapper;
    @Resource
    private UpdateValueAsyncService updateValueAsyncService;

    @PostConstruct
    private void startScheduledTask() {
        logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316");
        scheduledExecutor.scheduleAtFixedRate(() -> {
            logger.info("\u667a\u80fd\u95ee\u6570\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
            logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u66f4\u65b0\u7cfb\u7edf\u9274\u6743\u4fe1\u606f");
            this.chatBIResourceService.init();
            logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u66f4\u65b0\u7cfb\u7edf\u9274\u6743\u4fe1\u606f\u7ed3\u675f");
            logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u66f4\u65b0\u6307\u6807\u5e73\u53f0\u7ef4\u5ea6\u503c");
            this.updateAllFieldAndDimensionValueAsync();
            logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u5f00\u59cb\u6267\u884c\u66f4\u65b0\u7ef4\u5ea6\u503c\u7684\u5f02\u6b65\u4efb\u52a1");
            logger.info("\u667a\u80fd\u95ee\u7b54\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
        }, this.getInitialDelay(), TimeUnit.HOURS.toSeconds(24L), TimeUnit.SECONDS);
        logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u6210\u529f");
        logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u521d\u59cb\u5316\u5411\u91cf\u5e93\u7f13\u5b58");
        this.refreshVectorCountCache();
        logger.info("\u667a\u80fd\u95ee\u6570\uff0c\u5411\u91cf\u5e93\u7f13\u5b58\u521d\u59cb\u5316\u6210\u529f");
    }

    private void refreshVectorCountCache() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{DataDomainAuthInfo::getDataDomainId});
        List list = this.dataDomainAuthInfoMapper.selectList((Wrapper)wrapper);
        if (list == null || list.isEmpty()) {
            return;
        }
        List<String> dataDomainIds = list.stream().map(DataDomainAuthInfo::getDataDomainId).map(Object::toString).collect(Collectors.toList());
        this.vectorStoreService.init(dataDomainIds);
    }

    @Override
    public void updateAllFieldAndDimensionValueAsync() {
        List list = this.dataDomainAuthInfoMapper.selectList((Wrapper)new QueryWrapper());
        if (list == null || list.isEmpty()) {
            return;
        }
        for (DataDomainAuthInfo dataDomainAuthInfo : list) {
            Long dataDomainId = dataDomainAuthInfo.getDataDomainId();
            List<FieldInfoSearchObj> fieldInfoSearchObjs = this.vectorStoreService.fieldList(dataDomainId.toString());
            List<DimensionInfoSearchObj> dimensionList = this.vectorStoreService.dimensionList(dataDomainId.toString());
            ArrayList<FieldInfoSearchObj> filteredFieldList = new ArrayList<FieldInfoSearchObj>();
            ArrayList<String> deleteValueFieldIds = new ArrayList<String>();
            for (FieldInfoSearchObj fieldInfoSearchObj : fieldInfoSearchObjs) {
                if (fieldInfoSearchObj.getDimension_id() != null && !fieldInfoSearchObj.getDimension_id().isEmpty()) {
                    deleteValueFieldIds.add(fieldInfoSearchObj.getField_id());
                    continue;
                }
                filteredFieldList.add(fieldInfoSearchObj);
            }
            for (DimensionInfoSearchObj dimension : dimensionList) {
                FieldInfoSearchObj field = new FieldInfoSearchObj();
                field.setDimension_id(dimension.getDimension_id());
                field.setField_type(dimension.getDimension_type());
                filteredFieldList.add(field);
            }
            this.vectorStoreService.deleteFieldValuesByFieldIds(deleteValueFieldIds, dataDomainId.toString());
            this.updateValueAsyncService.addTaskBatch(filteredFieldList, dataDomainId);
        }
    }

    private long getInitialDelay() {
        LocalDateTime nextRun;
        LocalDateTime now = LocalDateTime.now();
        if (!now.isBefore(nextRun = now.withHour(2).withMinute(30).withSecond(0).withNano(0))) {
            nextRun = nextRun.plusDays(1L);
        }
        return Duration.between(now, nextRun).getSeconds();
    }

    @Override
    public Map<String, Object> qa(Map<String, Object> params, Long dataDomainId) {
        return this.chatBIResourceService.qa(params, dataDomainId, null);
    }

    @Override
    public boolean deleteQaPairBatch(List<String> qaIds, Long dataDomainId) {
        this.vectorStoreService.deleteQaByIdList(qaIds, dataDomainId.toString());
        return true;
    }

    @Override
    public QaInfoSearchObj qaPairDetail(String qaId, Long dataDomainId) {
        if (qaId == null || qaId.isEmpty()) {
            return null;
        }
        QaInfoSearchObj detail = this.vectorStoreService.queryQaById(qaId, dataDomainId.toString());
        detail.setAnswer(JsonUtil.toPrettyJson(detail.getAnswer()));
        return detail;
    }

    @Override
    public boolean updateQaPair(QaInfoSearchObj qaInfoSearchObj, Long dataDomainId) {
        if (qaInfoSearchObj == null || qaInfoSearchObj.getQa_id() == null || qaInfoSearchObj.getQa_id().isEmpty() || qaInfoSearchObj.getQuestion() == null || qaInfoSearchObj.getQuestion().isEmpty() || qaInfoSearchObj.getAnswer() == null || qaInfoSearchObj.getAnswer().isEmpty()) {
            throw new HussarException("\u95ee\u7b54\u793a\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!JsonUtil.isValidJson(qaInfoSearchObj.getAnswer())) {
            throw new HussarException("\u7b54\u6848\u5fc5\u987b\u662f\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32\uff01");
        }
        List<QaInfoSearchObj> exitedQasList = this.vectorStoreService.queryQaListByQuestionList(Collections.singletonList(qaInfoSearchObj.getQuestion()), dataDomainId.toString());
        for (QaInfoSearchObj qa : exitedQasList) {
            if (qa.getQa_id().equals(qaInfoSearchObj.getQa_id())) continue;
            throw new HussarException("\u95ee\u7b54\u793a\u4f8b\u5df2\u5b58\u5728\uff01");
        }
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(qaInfoSearchObj.getQuestion())).get(0);
        QaEntity qaEntity = new QaEntity();
        qaEntity.setQa_id(qaInfoSearchObj.getQa_id());
        qaEntity.setQuestion(qaInfoSearchObj.getQuestion());
        qaEntity.setAnswer(JsonUtil.toCompactJson(qaInfoSearchObj.getAnswer()));
        qaEntity.setQuestion_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.updateQaPair(qaEntity, dataDomainId.toString());
        return true;
    }

    @Override
    public boolean addQaPairBatch(List<QaPair> qaPairs, Long dataDomainId) {
        if (qaPairs == null || qaPairs.isEmpty()) {
            throw new HussarException("\u95ee\u7b54\u793a\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> questions = new ArrayList<String>();
        for (QaPair qaPair : qaPairs) {
            if (qaPair.getQuestion() == null || qaPair.getQuestion().isEmpty() || qaPair.getAnswer() == null || qaPair.getAnswer().isEmpty()) {
                throw new HussarException("\u95ee\u9898\u548c\u7b54\u6848\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!JsonUtil.isValidJson(qaPair.getAnswer())) {
                throw new HussarException("\u7b54\u6848\u5fc5\u987b\u662f\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32\uff01");
            }
            qaPair.setAnswer(JsonUtil.toCompactJson(qaPair.getAnswer()));
            questions.add(qaPair.getQuestion());
        }
        List<QaInfoSearchObj> checkExistQaObjs = this.vectorStoreService.queryQaListByQuestionList(questions, dataDomainId.toString());
        if (checkExistQaObjs != null && !checkExistQaObjs.isEmpty()) {
            String msg = "\u4ee5\u4e0b\u95ee\u9898\u5df2\u5b58\u5728\uff1a" + checkExistQaObjs.stream().map(QaInfoSearchObj::getQuestion).reduce((a, b) -> a + "," + b).get() + "\uff01";
            throw new HussarException(msg);
        }
        List<TextVector> textVectors = this.chatBIResourceService.getVector(questions);
        ArrayList<QaEntity> qaEntities = new ArrayList<QaEntity>();
        for (int i = 0; i < qaPairs.size(); ++i) {
            QaPair qaPair = qaPairs.get(i);
            TextVector textVector = textVectors.get(i);
            String id = UUID.randomUUID().toString().replace("-", "");
            QaEntity qaEntity = new QaEntity();
            qaEntity.setQa_id(id);
            qaEntity.setQuestion(qaPair.getQuestion());
            qaEntity.setAnswer(qaPair.getAnswer());
            qaEntity.setQuestion_dense_vector(textVector.getDenseVector());
            qaEntities.add(qaEntity);
        }
        this.vectorStoreService.insertQaPairList(qaEntities, dataDomainId.toString());
        return true;
    }

    @Override
    public Page<QaInfoSearchObj> qaPairPage(Long current, Long size, Long dataDomainId) {
        current = current == null ? 1L : current;
        size = size == null ? 10L : size;
        Long total = this.vectorStoreService.countQa(dataDomainId.toString());
        Page page = new Page(current.longValue(), size.longValue(), total.longValue());
        List<QaInfoSearchObj> records = this.vectorStoreService.qaPage(current, size, dataDomainId.toString());
        page.setRecords(records);
        return page;
    }

    @Override
    public Page<TermInfoSearchObj> termPage(Long current, Long size, Long dataDomainId) {
        current = current == null ? 1L : current;
        size = size == null ? 10L : size;
        Long total = this.vectorStoreService.countTerm(dataDomainId.toString());
        Page page = new Page(current.longValue(), size.longValue(), total.longValue());
        List<TermInfoSearchObj> records = this.vectorStoreService.termPage(current, size, dataDomainId.toString());
        page.setRecords(records);
        return page;
    }

    @Override
    public boolean termCopy(Long fromId, Long toId) {
        List<TermEntity> termList;
        if (fromId == null || fromId <= 0L || toId == null || toId <= 0L) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        long total = this.vectorStoreService.countTerm(fromId.toString());
        for (long i = 0L; i < total && (termList = this.vectorStoreService.termVectorPage(i, 500L, fromId.toString())) != null && !termList.isEmpty(); i += 500L) {
            termList.forEach(term -> term.setTerm_id(UUID.randomUUID().toString().replace("-", "")));
            this.vectorStoreService.insertTermList(termList, toId.toString());
        }
        return true;
    }

    @Override
    public TermInfoSearchObj termDetail(String termId, Long dataDomainId) {
        if (termId == null || termId.isEmpty()) {
            return null;
        }
        return this.vectorStoreService.queryTermById(termId, dataDomainId.toString());
    }

    @Override
    public Boolean deleteTermBatch(List<String> termIds, Long dataDomainId) {
        if (termIds == null || termIds.isEmpty()) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38");
        }
        this.vectorStoreService.deleteTermList(termIds, dataDomainId.toString());
        return true;
    }

    @Override
    public Boolean updateTerm(TermInfoSearchObj term, Long dataDomainId) {
        if (term == null || term.getTerm_id() == null || term.getTerm_id().isEmpty() || term.getTerm() == null || term.getTerm().isEmpty() || term.getExplanation() == null || term.getExplanation().isEmpty()) {
            throw new HussarException("id\u3001\u672f\u8bed\u548c\u89e3\u91ca\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        TermEntity termEntity = new TermEntity();
        termEntity.setTerm_id(term.getTerm_id());
        termEntity.setTerm(term.getTerm());
        termEntity.setExplanation(term.getExplanation());
        TextVector textVector = this.chatBIResourceService.getVector(Collections.singletonList(term.getTerm())).get(0);
        termEntity.setTerm_dense_vector(textVector.getDenseVector());
        this.vectorStoreService.updateTerm(termEntity, dataDomainId.toString());
        return true;
    }

    @Override
    public boolean addTermBatch(List<AddTerm> terms, Long dataDomainId) {
        if (terms == null || terms.isEmpty()) {
            throw new HussarException("\u672f\u8bed\u548c\u89e3\u91ca\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> vectorTexts = new ArrayList<String>();
        for (AddTerm term : terms) {
            if (term.getTerm() == null || term.getTerm().isEmpty() || term.getExplanation() == null || term.getExplanation().isEmpty()) {
                throw new HussarException("\u672f\u8bed\u548c\u89e3\u91ca\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            vectorTexts.add(term.getTerm());
        }
        List<TextVector> textVectors = this.chatBIResourceService.getVector(vectorTexts);
        ArrayList<TermEntity> vectorObjs = new ArrayList<TermEntity>();
        for (int i = 0; i < terms.size(); ++i) {
            AddTerm term = terms.get(i);
            TermEntity termEntity = new TermEntity();
            termEntity.setTerm_id(UUID.randomUUID().toString().replace("-", ""));
            termEntity.setTerm(term.getTerm());
            termEntity.setExplanation(term.getExplanation());
            termEntity.setTerm_dense_vector(textVectors.get(i).getDenseVector());
            vectorObjs.add(termEntity);
        }
        this.vectorStoreService.insertTermList(vectorObjs, dataDomainId.toString());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> initDataDomain(DataDomainAuthInfo dataDomainAuthInfo) {
        if ("1".equals(dataDomainAuthInfo.getIsAuth())) {
            if (dataDomainAuthInfo.getAuthUrl() == null || dataDomainAuthInfo.getAuthUrl().isEmpty()) {
                throw new HussarException("\u9274\u6743\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dataDomainAuthInfo.getClientId() == null || dataDomainAuthInfo.getClientId().isEmpty()) {
                throw new HussarException("\u5ba2\u6237\u7aefid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dataDomainAuthInfo.getClientSecret() == null || dataDomainAuthInfo.getClientSecret().isEmpty()) {
                throw new HussarException("\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (this.isDataDomainCodeExist(dataDomainAuthInfo.getDataDomainCode(), null)) {
            throw new HussarException("\u6307\u6807\u5e93\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        this.dataDomainAuthInfoMapper.insert((Object)dataDomainAuthInfo);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataDomainId", dataDomainAuthInfo.getDataDomainId());
        result.put("dataDomainName", dataDomainAuthInfo.getDataDomainName());
        this.vectorStoreService.initCollection(dataDomainAuthInfo.getDataDomainId().toString());
        this.chatBIResourceService.insertSystemAuthInfo(dataDomainAuthInfo);
        return result;
    }

    private boolean isDataDomainCodeExist(String dataDomainCode, Long excludeId) {
        Long count;
        if (dataDomainCode == null || dataDomainCode.trim().isEmpty()) {
            throw new HussarException("\u6307\u6807\u5e93\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataDomainAuthInfo::getDataDomainCode, (Object)dataDomainCode);
        if (excludeId != null) {
            queryWrapper.ne(DataDomainAuthInfo::getDataDomainId, (Object)excludeId);
        }
        return (count = this.dataDomainAuthInfoMapper.selectCount((Wrapper)queryWrapper)) != null && count > 0L;
    }

    @Override
    public DataDomainAuthInfo getDataDomainInfo(Long dataDomainId) {
        return (DataDomainAuthInfo)((Object)this.dataDomainAuthInfoMapper.selectById(dataDomainId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateDataDomainInfo(DataDomainAuthInfo dataDomainAuthInfo) {
        if (dataDomainAuthInfo == null || dataDomainAuthInfo.getDataDomainId() == null) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u6307\u6807\u5e93\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("1".equals(dataDomainAuthInfo.getIsAuth())) {
            if (dataDomainAuthInfo.getAuthUrl() == null || dataDomainAuthInfo.getAuthUrl().isEmpty()) {
                throw new HussarException("\u9274\u6743\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dataDomainAuthInfo.getClientId() == null || dataDomainAuthInfo.getClientId().isEmpty()) {
                throw new HussarException("\u5ba2\u6237\u7aefid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dataDomainAuthInfo.getClientSecret() == null || dataDomainAuthInfo.getClientSecret().isEmpty()) {
                throw new HussarException("\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (this.isDataDomainCodeExist(dataDomainAuthInfo.getDataDomainCode(), dataDomainAuthInfo.getDataDomainId())) {
            throw new HussarException("\u6307\u6807\u5e93\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        this.dataDomainAuthInfoMapper.updateById((Object)dataDomainAuthInfo);
        this.chatBIResourceService.init();
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteDataDomainInfo(Long dataDomainId) {
        if (dataDomainId == null) {
            throw new HussarException("\u53c2\u6570\u5f02\u5e38\uff1a\u6307\u6807\u5e93\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.dataDomainAuthInfoMapper.deleteById(dataDomainId);
        this.chatBiMapper.deleteMetricByDataDomainId(dataDomainId);
        this.chatBiMapper.deleteDatasetRelationByDataDomainId(dataDomainId);
        this.chatBiMapper.deleteCompositeMetricByDataDomainId(dataDomainId);
        this.vectorStoreService.dropAllCollections(dataDomainId.toString());
        this.chatBIResourceService.init();
        return true;
    }

    @Override
    public Page<DataDomainAuthInfo> dataDomainInfoPage(Long current, Long size, String dataDomainName, String dataDomainCode) {
        current = current == null ? 1L : current;
        size = size == null ? 10L : size;
        Page page = new Page(current.longValue(), size.longValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{DataDomainAuthInfo::getDataDomainId, DataDomainAuthInfo::getDataDomainName, DataDomainAuthInfo::getDataDomainCode, DataDomainAuthInfo::getDescription, HussarBaseEntity::getCreateTime}).orderByDesc(HussarBaseEntity::getCreateTime);
        if (dataDomainName != null && !dataDomainName.isEmpty()) {
            wrapper.like(DataDomainAuthInfo::getDataDomainName, (Object)dataDomainName);
        }
        if (dataDomainCode != null && !dataDomainCode.isEmpty()) {
            wrapper.like(DataDomainAuthInfo::getDataDomainCode, (Object)dataDomainCode);
        }
        Page results = (Page)this.dataDomainAuthInfoMapper.selectPage((IPage)page, (Wrapper)wrapper);
        List records = results.getRecords();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (DataDomainAuthInfo dataDomainAuthInfo : records) {
            Long dataDomainId = dataDomainAuthInfo.getDataDomainId();
            CompletableFuture<Long> metricFuture = CompletableFuture.supplyAsync(() -> this.vectorStoreService.countMetric(dataDomainId.toString()));
            CompletableFuture<Long> termFuture = CompletableFuture.supplyAsync(() -> this.vectorStoreService.countTerm(dataDomainId.toString()));
            CompletableFuture<Long> qaFuture = CompletableFuture.supplyAsync(() -> this.vectorStoreService.countQa(dataDomainId.toString()));
            CompletionStage combined = CompletableFuture.allOf(metricFuture, termFuture, qaFuture).thenAccept(v -> {
                try {
                    dataDomainAuthInfo.setMetricCount((Long)metricFuture.get());
                    dataDomainAuthInfo.setTermCount((Long)termFuture.get());
                    dataDomainAuthInfo.setQaCount((Long)qaFuture.get());
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u6307\u6807/\u672f\u8bed/QA\u6570\u91cf\u65f6\u51fa\u9519", (Throwable)e);
                    dataDomainAuthInfo.setMetricCount(0L);
                    dataDomainAuthInfo.setTermCount(0L);
                    dataDomainAuthInfo.setQaCount(0L);
                }
            });
            futures.add(combined);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return results;
    }

    @Override
    public List<DataDomainAuthInfo> dataDomainList(Long excludeId, String type) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (excludeId != null) {
            wrapper.ne(DataDomainAuthInfo::getDataDomainId, (Object)excludeId);
        }
        wrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List list = this.dataDomainAuthInfoMapper.selectList((Wrapper)wrapper);
        if (list == null || list.isEmpty()) {
            return new ArrayList<DataDomainAuthInfo>();
        }
        if ("copyTerm".equals(type)) {
            return list.parallelStream().filter(dataDomainAuthInfo -> this.vectorStoreService.countTerm(dataDomainAuthInfo.getDataDomainId().toString()) > 0L).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public Page<MetricPageObj> metricPage(Long current, Long size, Long dataDomainId) {
        current = current == null ? 1L : current;
        size = size == null ? 10L : size;
        List<MetricInfoSearchObj> metricPage = this.vectorStoreService.metricPage(current, size, dataDomainId.toString());
        Long total = this.vectorStoreService.countMetric(dataDomainId.toString());
        Page page = new Page(current.longValue(), size.longValue(), total.longValue());
        ArrayList<MetricPageObj> records = new ArrayList<MetricPageObj>();
        ArrayList<String> timeDimensionIds = new ArrayList<String>();
        ArrayList<String> datasetIds = new ArrayList<String>();
        for (MetricInfoSearchObj metricInfoSearchObj : metricPage) {
            MetricPageObj metricPageObj = new MetricPageObj();
            metricPageObj.setMetric_id(metricInfoSearchObj.getMetric_id());
            metricPageObj.setMetric_name(metricInfoSearchObj.getMetric_name());
            metricPageObj.setMetric_info(metricInfoSearchObj.getMetric_info());
            if (metricInfoSearchObj.getTime_dimension_id() != null && !metricInfoSearchObj.getTime_dimension_id().isEmpty()) {
                metricPageObj.setTime_dimension_id(metricInfoSearchObj.getTime_dimension_id());
                timeDimensionIds.add(metricInfoSearchObj.getTime_dimension_id());
            }
            if (metricInfoSearchObj.getDataset_id() != null && !metricInfoSearchObj.getDataset_id().isEmpty()) {
                metricPageObj.setDataset_id(metricInfoSearchObj.getDataset_id());
                datasetIds.add(metricInfoSearchObj.getDataset_id());
            }
            records.add(metricPageObj);
        }
        page.setRecords(records);
        Map<Object, Object> timeFieldInfoMap = new HashMap();
        Map<Object, Object> datasetInfoSearchObjMap = new HashMap();
        if (!timeDimensionIds.isEmpty()) {
            List<FieldInfoSearchObj> timeFieldInfos = this.vectorStoreService.queryFieldListByIdList(timeDimensionIds, dataDomainId.toString());
            timeFieldInfoMap = timeFieldInfos.stream().collect(Collectors.toMap(FieldInfoSearchObj::getField_id, t -> t));
        }
        if (!datasetIds.isEmpty()) {
            List<DatasetInfoSearchObj> datasetInfoSearchObjs = this.vectorStoreService.queryDatasetListByIdList(datasetIds, dataDomainId.toString());
            datasetInfoSearchObjMap = datasetInfoSearchObjs.stream().collect(Collectors.toMap(DatasetInfoSearchObj::getDataset_id, t -> t));
        }
        if (timeFieldInfoMap.isEmpty() && datasetInfoSearchObjMap.isEmpty()) {
            return page;
        }
        for (MetricPageObj metricPageObj : records) {
            DatasetInfoSearchObj datasetInfoSearchObj;
            FieldInfoSearchObj fieldInfoSearchObj;
            if (metricPageObj.getTime_dimension_id() != null && !metricPageObj.getTime_dimension_id().isEmpty() && (fieldInfoSearchObj = (FieldInfoSearchObj)timeFieldInfoMap.get(metricPageObj.getTime_dimension_id())) != null) {
                metricPageObj.setTime_dimension_name(fieldInfoSearchObj.getField_comment());
            }
            if (metricPageObj.getDataset_id() == null || metricPageObj.getDataset_id().isEmpty() || (datasetInfoSearchObj = (DatasetInfoSearchObj)datasetInfoSearchObjMap.get(metricPageObj.getDataset_id())) == null) continue;
            metricPageObj.setDataset_name(datasetInfoSearchObj.getDataset_name());
        }
        return page;
    }
}

