/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.chatbi.dto.AddTerm;
import com.jxdinfo.hussar.chatbi.dto.QaPair;
import com.jxdinfo.hussar.chatbi.dto.result.QaInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.TermInfoSearchObj;
import com.jxdinfo.hussar.chatbi.model.DataDomainAuthInfo;
import com.jxdinfo.hussar.chatbi.service.ChatBIManagerService;
import com.jxdinfo.hussar.chatbi.vo.MetricPageObj;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/chatbi/manager"})
public class ChatBiManagerController {
    private static final Logger logger = LoggerFactory.getLogger(ChatBiManagerController.class);
    @Resource
    private ChatBIManagerService chatBIManagerService;

    @PostMapping(value={"/dataDomain/init"})
    public ApiResponse<Map<String, Object>> initDataDomain(@RequestBody DataDomainAuthInfo dataDomainAuthInfo) {
        logger.info("\u521d\u59cb\u5316\u6307\u6807\u5e93\uff1a{}", (Object)dataDomainAuthInfo.toString());
        return ApiResponse.success(this.chatBIManagerService.initDataDomain(dataDomainAuthInfo));
    }

    @GetMapping(value={"/dataDomain/detail"})
    public ApiResponse<DataDomainAuthInfo> getDataDomainInfo(Long dataDomainId) {
        return ApiResponse.success((Object)((Object)this.chatBIManagerService.getDataDomainInfo(dataDomainId)));
    }

    @PostMapping(value={"/dataDomain/update"})
    public ApiResponse<Boolean> updateDataDomainInfo(@RequestBody DataDomainAuthInfo dataDomainAuthInfo) {
        logger.info("\u4fee\u6539\u6307\u6807\u5e93\uff1a{}", (Object)dataDomainAuthInfo.toString());
        return ApiResponse.success((Object)this.chatBIManagerService.updateDataDomainInfo(dataDomainAuthInfo));
    }

    @GetMapping(value={"/dataDomain/delete"})
    public ApiResponse<Boolean> deleteDataDomainInfo(Long dataDomainId) {
        logger.info("\u5220\u9664\u6307\u6807\u5e93\uff0cid\uff1a{}", (Object)dataDomainId);
        return ApiResponse.success((Object)this.chatBIManagerService.deleteDataDomainInfo(dataDomainId));
    }

    @GetMapping(value={"/dataDomain/page"})
    public ApiResponse<Page<DataDomainAuthInfo>> pageDataDomainInfo(Long current, Long size, String dataDomainName, String dataDomainCode) {
        return ApiResponse.success(this.chatBIManagerService.dataDomainInfoPage(current, size, dataDomainName, dataDomainCode));
    }

    @GetMapping(value={"/dataDomain/list"})
    public ApiResponse<List<DataDomainAuthInfo>> listDataDomainInfo(Long excludeId, String type) {
        return ApiResponse.success(this.chatBIManagerService.dataDomainList(excludeId, type));
    }

    @PostMapping(value={"/term/batch/add"})
    public ApiResponse<Boolean> addTermBatch(@RequestBody List<AddTerm> terms, @RequestParam Long dataDomainId) {
        logger.info("\u6307\u6807\u5e93id\uff1a{}, \u65b0\u589e\u672f\u8bed\uff1a{}", (Object)dataDomainId, (Object)terms.toString());
        return ApiResponse.success((Object)this.chatBIManagerService.addTermBatch(terms, dataDomainId));
    }

    @PostMapping(value={"/term/update"})
    public ApiResponse<Boolean> updateTerm(@RequestBody TermInfoSearchObj term, @RequestParam Long dataDomainId) {
        logger.info("\u6307\u6807\u5e93id\uff1a{}\uff0c\u66f4\u65b0\u672f\u8bed\uff1a{}", (Object)dataDomainId, (Object)term.toString());
        return ApiResponse.success((Object)this.chatBIManagerService.updateTerm(term, dataDomainId));
    }

    @PostMapping(value={"/term/batch/delete"})
    public ApiResponse<Boolean> deleteTermBatch(@RequestBody List<String> termIds, @RequestParam Long dataDomainId) {
        logger.info("\u6307\u6807\u5e93id\uff1a{}\uff0c\u5220\u9664\u672f\u8bed\uff1a{}", (Object)dataDomainId, termIds);
        return ApiResponse.success((Object)this.chatBIManagerService.deleteTermBatch(termIds, dataDomainId));
    }

    @GetMapping(value={"/term/detail"})
    public ApiResponse<TermInfoSearchObj> termDetail(String term_id, Long dataDomainId) {
        return ApiResponse.success((Object)this.chatBIManagerService.termDetail(term_id, dataDomainId));
    }

    @GetMapping(value={"/term/page"})
    public ApiResponse<Page<TermInfoSearchObj>> termPage(Long current, Long size, Long dataDomainId) {
        return ApiResponse.success(this.chatBIManagerService.termPage(current, size, dataDomainId));
    }

    @GetMapping(value={"/term/copy"})
    public ApiResponse<Boolean> termCopy(Long fromId, Long toId) {
        return ApiResponse.success((Object)this.chatBIManagerService.termCopy(fromId, toId));
    }

    @GetMapping(value={"/qaPair/page"})
    public ApiResponse<Page<QaInfoSearchObj>> qaPairPage(Long current, Long size, Long dataDomainId) {
        return ApiResponse.success(this.chatBIManagerService.qaPairPage(current, size, dataDomainId));
    }

    @PostMapping(value={"/qaPair/batch/add"})
    public ApiResponse<Boolean> addQaPairBatch(@RequestBody List<QaPair> qaPairs, @RequestParam Long dataDomainId) {
        return ApiResponse.success((Object)this.chatBIManagerService.addQaPairBatch(qaPairs, dataDomainId), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/qaPair/update"})
    public ApiResponse<Boolean> updateQaPair(@RequestBody QaInfoSearchObj qaInfoSearchObj, @RequestParam Long dataDomainId) {
        return ApiResponse.success((Object)this.chatBIManagerService.updateQaPair(qaInfoSearchObj, dataDomainId));
    }

    @GetMapping(value={"/qaPair/detail"})
    public ApiResponse<QaInfoSearchObj> qaPairDetail(String qa_id, Long dataDomainId) {
        return ApiResponse.success((Object)this.chatBIManagerService.qaPairDetail(qa_id, dataDomainId));
    }

    @PostMapping(value={"/qaPair/batch/delete"})
    public ApiResponse<Boolean> deleteQaPairBatch(@RequestBody List<String> qaIds, Long dataDomainId) {
        return ApiResponse.success((Object)this.chatBIManagerService.deleteQaPairBatch(qaIds, dataDomainId));
    }

    @GetMapping(value={"/metric/page"})
    public ApiResponse<Page<MetricPageObj>> metricPage(Long current, Long size, Long dataDomainId) {
        return ApiResponse.success(this.chatBIManagerService.metricPage(current, size, dataDomainId));
    }

    @PostMapping(value={"/qa"})
    public ApiResponse<Map<String, Object>> qa(@RequestBody Map<String, Object> params, @RequestParam Long dataDomainId) {
        return ApiResponse.success(this.chatBIManagerService.qa(params, dataDomainId));
    }
}

