/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.util;

import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FieldInfoCatch {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>> metricDimensionCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> metricDimensionLastAccess = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>> datasetFieldCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> datasetFieldLastAccess = new ConcurrentHashMap();

    public FieldInfoCatch() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("MT-FieldInfoCatch-Scheduler");
            return t;
        });
        scheduler.scheduleAtFixedRate(this::cleanup, 30L, 30L, TimeUnit.MINUTES);
    }

    public void saveMetricDimensionResult(String dataDomainId, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> result) {
        this.saveResult(dataDomainId, result, this.metricDimensionCache, this.metricDimensionLastAccess);
    }

    public void saveDatasetFieldResult(String dataDomainId, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> result) {
        this.saveResult(dataDomainId, result, this.datasetFieldCache, this.datasetFieldLastAccess);
    }

    private void saveResult(String dataDomainId, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> result, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>> datasetFieldCache, ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> datasetFieldLastAccess) {
        ConcurrentHashMap storedMap = datasetFieldCache.computeIfAbsent(dataDomainId, key -> new ConcurrentHashMap());
        for (Map.Entry<String, ConcurrentHashMap<String, FieldInfoSearchObj>> entry : result.entrySet()) {
            String outerKey = entry.getKey();
            ConcurrentHashMap<String, FieldInfoSearchObj> incomingValueMap = entry.getValue();
            storedMap.merge(outerKey, incomingValueMap, (oldMap, newMap) -> {
                oldMap.putAll(newMap);
                return oldMap;
            });
            ConcurrentHashMap innerMap = datasetFieldLastAccess.computeIfAbsent(dataDomainId, k -> new ConcurrentHashMap());
            innerMap.put(outerKey, System.currentTimeMillis());
        }
    }

    private void cleanup() {
        long currentTime = System.currentTimeMillis();
        long expirationThreshold = 1800000L;
        this.removeExpired(currentTime, expirationThreshold, this.metricDimensionLastAccess, this.metricDimensionCache);
        this.removeExpired(currentTime, expirationThreshold, this.datasetFieldLastAccess, this.datasetFieldCache);
    }

    private void removeExpired(long currentTime, long expirationThreshold, ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> lastAccess, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>> dataCache) {
        for (Map.Entry<String, ConcurrentHashMap<String, Long>> sysEntry : lastAccess.entrySet()) {
            String dataDomainId = sysEntry.getKey();
            ConcurrentHashMap<String, Long> outerKeyAccessMap = sysEntry.getValue();
            Set outerKeysToRemove = outerKeyAccessMap.entrySet().stream().filter(e -> currentTime - (Long)e.getValue() > expirationThreshold).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (outerKeysToRemove.isEmpty()) continue;
            ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> outerMap = dataCache.get(dataDomainId);
            if (outerMap != null) {
                for (String outerKey : outerKeysToRemove) {
                    outerMap.remove(outerKey);
                    outerKeyAccessMap.remove(outerKey);
                }
                if (!outerMap.isEmpty()) continue;
                dataCache.remove(dataDomainId);
                lastAccess.remove(dataDomainId);
                continue;
            }
            lastAccess.remove(dataDomainId);
        }
    }

    public FieldInfoSearchObj getMetricDimension(String dataDomainId, String metricName, String dimensionName) {
        return this.getCacheData(dataDomainId, metricName, dimensionName, this.metricDimensionLastAccess, this.metricDimensionCache);
    }

    public FieldInfoSearchObj getDatasetField(String dataDomainId, String datasetName, String fieldName) {
        return this.getCacheData(dataDomainId, datasetName, fieldName, this.datasetFieldLastAccess, this.datasetFieldCache);
    }

    private FieldInfoSearchObj getCacheData(String dataDomainId, String outerKey, String innerKey, ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> lastAccess, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>>> dataCache) {
        ConcurrentHashMap innerMap = lastAccess.computeIfAbsent(dataDomainId, k -> new ConcurrentHashMap());
        innerMap.put(outerKey, System.currentTimeMillis());
        ConcurrentHashMap<String, ConcurrentHashMap<String, FieldInfoSearchObj>> innerDataMap = dataCache.get(dataDomainId);
        if (innerDataMap == null) {
            return null;
        }
        ConcurrentHashMap<String, FieldInfoSearchObj> fieldInfoMap = innerDataMap.get(outerKey);
        return fieldInfoMap != null ? fieldInfoMap.get(innerKey) : null;
    }
}

