/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.qa.service.impl;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.config.DisplayType;
import com.jxdinfo.hussar.ai.config.DisplayTypeProperties;
import com.jxdinfo.hussar.ai.qa.dao.IntelligentInterfaceMapper;
import com.jxdinfo.hussar.ai.qa.model.AiFieldTypeDict;
import com.jxdinfo.hussar.ai.qa.service.AiFieldTypeDictService;
import com.jxdinfo.hussar.ai.qa.service.AiProvinceService;
import com.jxdinfo.hussar.ai.qa.service.IntelligentInterfaceService;
import com.jxdinfo.hussar.ai.qa.vo.IntelligentInterfaceVo;
import com.jxdinfo.hussar.ai.qa.vo.ProvinceVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntelligentInterfaceServiceImpl
implements IntelligentInterfaceService {
    private Logger log = LoggerFactory.getLogger(IntelligentInterfaceServiceImpl.class);
    @Resource
    private IntelligentInterfaceMapper intelligentInterfaceMapper;
    @Resource
    private AiFieldTypeDictService fieldTypeDictService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private AiProvinceService aiProvinceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HussarDs(value="#datasourceKey")
    public Map<String, Object> getAnswer(String question, String sql, Page page, String datasourceKey, String url, Long dataSourceId) {
        Page pageMap = new Page(page.getCurrent(), page.getSize());
        JSONObject payload = new JSONObject();
        payload.put("query", (Object)question);
        payload.put("database_id", (Object)"ylja_train");
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        if (ToolUtil.isEmpty((Object)sql)) {
            try {
                long stime = System.currentTimeMillis();
                connection = IntelligentInterfaceServiceImpl.getStringObjectMap(url, payload, response);
                long endTime = System.currentTimeMillis();
                this.log.info("\u6267\u884c\u667a\u80fd\u63a5\u53e3\u8017\u65f6======>" + (endTime - stime));
            }
            catch (IOException e) {
                e.printStackTrace();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", null);
                map.put("data", "\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
                map.put("type", "text");
                map.put("fieldName", null);
                HashMap<String, Object> endTime = map;
                return endTime;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        IntelligentInterfaceVo intelligentInterfaceVo = (IntelligentInterfaceVo)JSON.parseObject((String)String.valueOf(response), IntelligentInterfaceVo.class);
        String sqlResult = String.valueOf(response);
        sql = ToolUtil.isNotEmpty((Object)sql) ? sql : intelligentInterfaceVo.getEn_answer().replaceAll("ilike", "like").replaceAll(";", "");
        try {
            long sqlsTime = System.currentTimeMillis();
            Page<Map<String, Object>> answer = this.intelligentInterfaceMapper.getAnswer(sql, (Page<Map<String, Object>>)pageMap);
            List records = answer.getRecords();
            for (Map map : records) {
                if (!map.containsKey("ROW_ID")) continue;
                map.remove("ROW_ID");
            }
            answer.setRecords(records);
            long sqleTime = System.currentTimeMillis();
            this.log.info("\u6267\u884csql\u8017\u65f6======>" + (sqleTime - sqlsTime));
            Map<String, Object> map = ((IntelligentInterfaceServiceImpl)AopContext.currentProxy()).getAnswerMap(question, sql, answer, intelligentInterfaceVo, sqlResult, "master");
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (e instanceof MyBatisSystemException) {
                map.put("data", "sql\u6267\u884c\u5931\u8d25");
            } else {
                map.put("data", "\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
            }
            map.put("name", null);
            map.put("type", "text");
            map.put("fieldName", null);
            map.put("sql", sql);
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @HussarDs(value="#datasourceKey")
    public Map<String, Object> getAnswerMap(String question, String sql, Page<Map<String, Object>> answer, IntelligentInterfaceVo intelligentInterfaceVo, String sqlResult, String datasourceKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isEmpty(answer) || HussarUtils.isEmpty((Object)answer.getRecords()) || ToolUtil.isEmpty(answer.getRecords().get(0))) {
            map.put("name", null);
            map.put("data", "\u6682\u65f6\u6ca1\u6709\u7ed3\u679c\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
            map.put("type", "text");
            map.put("fieldName", null);
            map.put("sql", sql);
        } else if (answer.getRecords().isEmpty()) {
            map.put("name", null);
            map.put("data", "\u67e5\u8be2\u7ed3\u679c\u4e3a0\u6761");
            map.put("type", "text");
            map.put("fieldName", null);
            map.put("sql", sql);
        } else {
            List<ProvinceVo> provinceVos = this.getProvinceVos(answer);
            for (Map answerMap : answer.getRecords()) {
                this.replaceDictLabel(answerMap, provinceVos);
                answerMap.entrySet().removeIf(entry -> StringUtil.containsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"id") && ((String)entry.getKey()).indexOf("id") + 2 == ((String)entry.getKey()).length());
            }
            DisplayTypeProperties displayTypeProperties = (DisplayTypeProperties)SpringUtil.getBean(DisplayTypeProperties.class);
            List<DisplayType> displayTypeList = displayTypeProperties.getDisplayTypeList();
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(AiFieldTypeDict::getIsCount, (Object)"1");
            AiFieldTypeDictService aiFieldTypeDictService = (AiFieldTypeDictService)SpringUtil.getBean(AiFieldTypeDictService.class);
            List dictList = aiFieldTypeDictService.list((Wrapper)lambdaQueryWrapper);
            List names = dictList.stream().map(AiFieldTypeDict::getFieldName).distinct().collect(Collectors.toList());
            Set keys = ((Map)answer.getRecords().get(0)).keySet();
            HashMap<String, String> xyMap = new HashMap<String, String>();
            for (String key : keys) {
                if (names.contains(key) && !xyMap.containsKey("valueAxis")) {
                    xyMap.put("valueAxis", key);
                    continue;
                }
                if (xyMap.containsKey("nameAxis")) continue;
                xyMap.put("nameAxis", key);
            }
            for (DisplayType displayType : displayTypeList) {
                String[] splitName;
                for (String name : splitName = displayType.getName().split(",")) {
                    if (!question.contains(name) || !xyMap.containsKey("valueAxis")) continue;
                    map.put("displayType", displayType.getType());
                    map.putAll(xyMap);
                }
            }
            map.put("name", keys);
            map.put("data", answer);
            map.put("type", "list");
            Map<String, String> addMap = this.getAddMap(intelligentInterfaceVo, sql);
            map.put("fieldName", addMap);
        }
        map.put("sqlResult", sqlResult);
        map.put("sql", sql);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSql(String question) {
        String url = null;
        JSONObject payload = new JSONObject();
        payload.put("query", (Object)question);
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        try {
            long stime = System.currentTimeMillis();
            connection = IntelligentInterfaceServiceImpl.getStringObjectMap(url, payload, response);
            long endTime = System.currentTimeMillis();
            this.log.info("\u6267\u884c\u667a\u80fd\u63a5\u53e3\u8017\u65f6======>" + (endTime - stime));
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5";
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        IntelligentInterfaceVo intelligentInterfaceVo = (IntelligentInterfaceVo)JSON.parseObject((String)String.valueOf(response), IntelligentInterfaceVo.class);
        return intelligentInterfaceVo.getEn_answer().replaceAll("ilike", "like").replaceAll(";", "");
    }

    private List<ProvinceVo> getProvinceVos(Page<Map<String, Object>> answer) {
        List<ProvinceVo> provinceVos = new ArrayList<ProvinceVo>();
        if (((Map)answer.getRecords().get(0)).containsKey("province")) {
            provinceVos = this.aiProvinceService.getProvinceList();
        }
        return provinceVos;
    }

    private Map<String, String> getAddMap(IntelligentInterfaceVo intelligentInterfaceVo, String sql) {
        List list = this.fieldTypeDictService.list();
        HashMap<String, String> filedMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (AiFieldTypeDict filedTypeDict : list) {
                filedMap.put(filedTypeDict.getFieldName(), filedTypeDict.getFieldComment());
            }
        }
        HashMap<String, String> addMap = new HashMap<String, String>();
        List<String> selectColumnName = this.getSelectColumnName(sql);
        for (String key : selectColumnName) {
            if (!ToolUtil.isNotEmpty(filedMap.get(key.toUpperCase()))) continue;
            addMap.put(key, (String)filedMap.get(key.toUpperCase()));
        }
        if (ToolUtil.isNotEmpty((Object)intelligentInterfaceVo) && ToolUtil.isNotEmpty(intelligentInterfaceVo.getTrans_map())) {
            Map<String, String> transMap = intelligentInterfaceVo.getTrans_map();
            for (String key : transMap.keySet()) {
                String dictKey = key.toUpperCase();
                if (filedMap.containsKey(dictKey)) continue;
                addMap.put(key, transMap.get(key));
                AiFieldTypeDict filedTypeDict = new AiFieldTypeDict();
                filedTypeDict.setFieldName(dictKey);
                filedTypeDict.setFieldComment(transMap.get(key));
                this.fieldTypeDictService.save(filedTypeDict);
            }
        }
        return addMap;
    }

    private static HttpURLConnection getStringObjectMap(String url, JSONObject params, StringBuilder response) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        connection.setConnectTimeout(10000);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = params.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        var5_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                response.append(new String(responseLine.trim().getBytes(), "UTF-8"));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        return connection;
    }

    private void replaceDictLabel(Map<String, Object> answerMap, List<ProvinceVo> provinceVos) {
        for (Map.Entry<String, Object> entry : answerMap.entrySet()) {
            String key = entry.getKey();
            if ("trade".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("industry", entry.getValue().toString()));
                continue;
            }
            if ("cust_level".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("customer_level", entry.getValue().toString()));
                continue;
            }
            if ("product_type".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("product_type", entry.getValue().toString()));
                continue;
            }
            if (!"province".equals(key)) continue;
            HashMap<String, String> provinceMap = new HashMap<String, String>();
            for (ProvinceVo provinceVo : provinceVos) {
                provinceMap.put(provinceVo.getProvinceId().toString(), provinceVo.getProvinceName());
            }
            entry.setValue(provinceMap.get(entry.getValue().toString()));
        }
    }

    public List<String> getSelectColumnName(String sql) {
        ArrayList<String> items = new ArrayList<String>();
        Select stmt = null;
        try {
            stmt = (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        for (SelectItem selectItem : ((PlainSelect)stmt.getSelectBody()).getSelectItems()) {
            if (selectItem instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                String columnName = "";
                Alias alias = selectExpressionItem.getAlias();
                Expression expression = selectExpressionItem.getExpression();
                if (expression instanceof CaseExpression) {
                    columnName = alias.getName();
                } else if (expression instanceof LongValue || expression instanceof StringValue || expression instanceof DateValue || expression instanceof DoubleValue) {
                    columnName = Objects.nonNull(alias.getName()) ? alias.getName() : expression.getASTNode().jjtGetValue().toString();
                } else if (expression instanceof TimeKeyExpression) {
                    columnName = alias.getName();
                } else if (alias != null) {
                    columnName = alias.getName();
                } else {
                    SimpleNode node = expression.getASTNode();
                    Object value = node.jjtGetValue();
                    if (value instanceof Column) {
                        columnName = ((Column)value).getColumnName();
                    } else if (value instanceof Function) {
                        columnName = value.toString();
                    } else {
                        columnName = String.valueOf(value);
                        columnName = columnName.replace("'", "");
                        columnName = columnName.replace("\"", "");
                        columnName = columnName.replace("`", "");
                    }
                }
                columnName = columnName.replace("'", "");
                columnName = columnName.replace("\"", "");
                columnName = columnName.replace("`", "");
                items.add(columnName);
                continue;
            }
            if (selectItem instanceof AllTableColumns) {
                AllTableColumns allTableColumns = (AllTableColumns)selectItem;
                items.add(allTableColumns.toString());
                continue;
            }
            items.add(selectItem.toString());
        }
        return items;
    }
}

