/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dialogue.service.impl;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.ai.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.ai.attachment.service.BaseAttachmentManagerService;
import com.jxdinfo.hussar.ai.attachment.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.ai.dialogue.service.IModelQALeaveMarkService;
import com.jxdinfo.hussar.ai.dialogue.util.pdfUtil.changeToPdfThread;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.common.util.IqaSpringContextUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.dialogue.dao.KnowledgeBaseModelMapper;
import com.jxdinfo.hussar.dialogue.dto.TransFileDTO;
import com.jxdinfo.hussar.dialogue.model.KnowledgeBaseModel;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ModelQALeaveMarkServiceImpl
implements IModelQALeaveMarkService {
    @Resource
    private KnowledgeBaseModelMapper modelDao;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private OssFileProperties ossFileProperties;
    @Resource
    private BaseAttachmentManagerService baseAttachmentManagerService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());

    @Override
    @Transactional
    public String createKnowledBase(String kbName, String kbType) {
        Snowflake snowflake = new Snowflake(10L, 10L);
        Long modelId = snowflake.nextId();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", modelId.toString());
        param.put("knowledge_base_description", kbName);
        String url = "";
        String code = "";
        String msg = "";
        if ("knowledge".equals(kbType)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u521b\u5efa\u63a5\u53e3");
        } else if ("question".equals(kbType)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u95ee\u7b54\u5e93\u521b\u5efa\u63a5\u53e3");
        }
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        if ("200".equals(code)) {
            KnowledgeBaseModel model = new KnowledgeBaseModel();
            model.setId(modelId);
            if ("knowledge".equals(kbType)) {
                model.setBaseType("0");
            } else if ("question".equals(kbType)) {
                model.setBaseType("1");
            }
            model.setKbName(kbName);
            model.setFileCount(Integer.valueOf(0));
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                model.setCreateUserId(user.getId());
                model.setCreateUserName(user.getUserName());
            }
            model.setCreateTime(new Date());
            model.setDelFlag("0");
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)qw.orderByDesc(KnowledgeBaseModel::getSeq)).last("LIMIT 1");
            List knowledgeBaseModelList = this.modelDao.selectList((Wrapper)qw);
            if (knowledgeBaseModelList != null && !knowledgeBaseModelList.isEmpty()) {
                KnowledgeBaseModel knowledgeBaseModel = (KnowledgeBaseModel)knowledgeBaseModelList.get(0);
                int maxOrderNum = knowledgeBaseModel.getSeq();
                model.setSeq(Integer.valueOf(maxOrderNum + 1));
            } else {
                model.setSeq(Integer.valueOf(1));
            }
            this.modelDao.insert((Object)model);
        }
        return msg;
    }

    @Override
    public List<Map> getknowledgeBasesList(String query, String type) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("query", query);
        String url = "";
        List list = new ArrayList();
        if ("knowledge".equals(type)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u5217\u8868\u63a5\u53e3");
        } else if ("question".equals(type)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u95ee\u7b54\u5e93\u5217\u8868\u63a5\u53e3");
        }
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String data = jsonObject.getString("data");
            list = (List)JSONObject.parseObject((String)data, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        }
        List modelList = new ArrayList();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"DEL_FLAG", (Object)"0");
        if ("knowledge".equals(type)) {
            ew.eq((Object)"BASE_TYPE", (Object)"0");
        } else if ("question".equals(type)) {
            ew.eq((Object)"BASE_TYPE", (Object)"1");
        } else {
            ew.eq((Object)"BASE_TYPE", (Object)"0");
        }
        ew.eq((Object)"CREATE_USER_ID", (Object)BaseSecurityUtil.getUser().getId());
        ew.orderByAsc((Object)"SEQ");
        modelList = this.modelDao.selectList((Wrapper)ew);
        ArrayList<Map> reslist = new ArrayList<Map>();
        for (KnowledgeBaseModel model : modelList) {
            for (String tem : list) {
                if (!tem.equals(model.getId().toString())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("kbName", model.getKbName());
                map.put("kbId", model.getId());
                reslist.add(map);
            }
        }
        return reslist;
    }

    @Override
    @Transactional
    public String delKnowledBase(String kbName, String kbType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", kbName);
        String url = "";
        String code = "";
        String msg = "";
        if ("knowledge".equals(kbType)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u5220\u9664\u63a5\u53e3");
        } else if ("question".equals(kbType)) {
            url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u95ee\u7b54\u5e93\u5220\u9664\u63a5\u53e3");
        }
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        if ("200".equals(code)) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"BASE_ID", (Object)kbName);
            if ("knowledge".equals(kbType)) {
                ew.eq((Object)"BASE_TYPE", (Object)"0");
            } else if ("question".equals(kbType)) {
                ew.eq((Object)"BASE_TYPE", (Object)"1");
            }
            KnowledgeBaseModel model = (KnowledgeBaseModel)this.modelDao.selectOne((Wrapper)ew);
            if (model != null) {
                model.setDelFlag("1");
                this.modelDao.updateById((Object)model);
            }
        }
        return msg;
    }

    @Override
    public String moveKnowledBase(List<Map<String, String>> knowledgeBaseList) {
        String msg = "";
        if (knowledgeBaseList.size() > 0) {
            for (Map<String, String> knowledgeBaseMap : knowledgeBaseList) {
                String id = knowledgeBaseMap.get("id").toString();
                Integer seq = Integer.parseInt(knowledgeBaseMap.get("seq") == null ? "0" : knowledgeBaseMap.get("seq").toString());
                KnowledgeBaseModel knowledgeBaseModel = (KnowledgeBaseModel)this.modelDao.selectById((Serializable)((Object)id));
                knowledgeBaseModel.setSeq(seq);
                this.modelDao.updateById((Object)knowledgeBaseModel);
            }
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return msg;
    }

    @Override
    public Map<String, Object> getDocsList(String kbName, String query, int pageNo, int pageSize) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", kbName);
        String url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u6587\u6863\u5217\u8868\u63a5\u53e3");
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String data = jsonObject.getString("data");
            List list = (List)JSONObject.parseObject((String)data, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
            ArrayList<String> queryList = new ArrayList<String>();
            for (String fileName : list) {
                if (!fileName.contains(query)) continue;
                queryList.add(fileName);
            }
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(AttachmentManagerModel::getBusinessId, (Object)kbName);
            qw.like(AttachmentManagerModel::getAttachmentName, (Object)query);
            qw.eq(AttachmentManagerModel::getDelFlag, (Object)"0");
            qw.orderByDesc(AttachmentManagerModel::getUploadDate);
            List attachmentManagerModelList = this.baseAttachmentManagerService.list((Wrapper)qw);
            List<AttachmentManagerModel> subList = new ArrayList<AttachmentManagerModel>();
            for (AttachmentManagerModel model : attachmentManagerModelList) {
                subList.add(model);
            }
            int total = subList.size();
            int pageSum = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
            subList = subList.stream().skip((pageNo - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            resultMap.put("pageNo", pageNo);
            resultMap.put("pageSize", pageSize);
            resultMap.put("total", total);
            resultMap.put("pageSum", pageSum);
            resultMap.put("list", subList);
        }
        return resultMap;
    }

    @Override
    public String uploadDoc(String kbName, MultipartHttpServletRequest multipartRequest, Integer chunk_size, Integer overlap_size) throws Exception {
        KnowledgeBaseModel model;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", kbName);
        param.put("chunk_size", String.valueOf(chunk_size));
        param.put("overlap_size", String.valueOf(overlap_size));
        ArrayList<MultipartHttpServletRequest> fileList = new ArrayList<MultipartHttpServletRequest>();
        fileList.add(multipartRequest);
        String url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u6587\u6863\u4e0a\u4f20\u63a5\u53e3");
        String code = "";
        String msg = "";
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpFilePost((String)url, fileList, param, new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        if ("200".equals(code) && (model = (KnowledgeBaseModel)this.modelDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"BASE_ID", (Object)kbName))) != null) {
            multipartRequest.setCharacterEncoding("UTF-8");
            new HashMap();
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            Long businessId = model.getId();
            MultipartFile multipartFile = null;
            Map map = multipartRequest.getFileMap();
            Iterator var7 = map.values().iterator();
            while (var7.hasNext()) {
                MultipartFile value;
                multipartFile = value = (MultipartFile)var7.next();
            }
            if (ToolUtil.isNotEmpty(multipartFile)) {
                String fileName = multipartFile.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                AttachmentManagerModel fileModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BUSINESS_ID", (Object)kbName)).eq((Object)"ATTACHMENT_NAME", (Object)fileName)).eq((Object)"DEL_FLAG", (Object)"0"));
                if (fileModel != null) {
                    this.baseAttachmentManagerService.removeById(fileModel.getId());
                }
                try {
                    String fileSavePath = this.ossFileProperties.getFileUploadPath();
                    AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(businessId, fileName, suffix, fileSavePath);
                    multipartFile.transferTo(new File(fileSavePath + attachmentManagerModel.getId() + suffix));
                    attachmentManagerModelVo.setId(attachmentManagerModel.getId());
                    attachmentManagerModelVo.setFileName(fileName);
                    Integer fileNum = model.getFileCount();
                    model.setFileCount(Integer.valueOf(fileNum + 1));
                    this.modelDao.updateById((Object)model);
                }
                catch (IOException var15) {
                    throw new BaseException(BizExceptionEnum.UPLOAD_ERROR.getMessage());
                }
            }
        }
        return msg;
    }

    @Override
    public String printThreadPoolStatus() {
        return "\u961f\u5217\u4e2d\u7684\u4efb\u52a1\u6570\uff1a" + threadPoolExecutor.getQueue().size() + "\n\u6267\u884c\u5668\u4e2d\u7684\u4efb\u52a1\u6570\uff1a " + threadPoolExecutor.getActiveCount() + "\n\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u6570\uff1a " + threadPoolExecutor.getCompletedTaskCount() + "\nPoolSize\u4e2d\u7684\u4efb\u52a1\u6570\uff1a " + threadPoolExecutor.getPoolSize() + "\nCorePoolSize\u4e2d\u7684\u4efb\u52a1\u6570\uff1a " + threadPoolExecutor.getCorePoolSize() + "\n";
    }

    @Override
    public void fileUp(TransFileDTO transFileDTO) {
        String dirPath = transFileDTO.getDirPath();
        Long docBaseId = transFileDTO.getDocBaseId();
        if (HussarUtils.isEmpty((Object)dirPath)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(AttachmentManagerModel::getDelFlag, (Object)"9");
            List list = this.baseAttachmentManagerService.list((Wrapper)lambdaQueryWrapper);
            String sourceFilePath = this.getSourceFilePath();
            for (AttachmentManagerModel attachmentManagerModel : list) {
                LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AttachmentManagerModel::getId, (Object)attachmentManagerModel.getId())).set(AttachmentManagerModel::getDelFlag, (Object)"0");
                this.baseAttachmentManagerService.update((Wrapper)wrapper);
                threadPoolExecutor.execute((Runnable)new changeToPdfThread(false, attachmentManagerModel.getId().toString(), attachmentManagerModel.getAttachmentDir().substring(sourceFilePath.length()) + attachmentManagerModel.getAttachmentName()));
            }
            return;
        }
        Path directory = Paths.get(dirPath, new String[0]);
        String sourceFilePath = this.getSourceFilePath();
        try {
            Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String fileName = path.getFileName().toString();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(docBaseId, fileName, suffix, sourceFilePath.substring(0, sourceFilePath.length() - 1) + path.getParent() + File.separatorChar);
                if (fileName.endsWith(".pdf")) {
                    try {
                        Files.copy(path, Paths.get(sourceFilePath.substring(0, sourceFilePath.length() - 1) + path.getParent() + File.separatorChar + attachmentManagerModel.getId() + ".pdf", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                threadPoolExecutor.execute((Runnable)new changeToPdfThread(false, attachmentManagerModel.getId().toString(), path.toString()));
            });
        }
        catch (IOException e) {
            System.err.println("Error occurred while walking the directory: " + e.getMessage());
        }
    }

    @Override
    public void handleFile() throws IOException {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AttachmentManagerModel::getBusinessId, (Object)1810605036650405888L)).eq(AttachmentManagerModel::getAttachmentType, (Object)"pdf");
        List list = this.baseAttachmentManagerService.list((Wrapper)wrapper);
        int i = 0;
        for (AttachmentManagerModel attachmentManagerModel : list) {
            Files.copy(Paths.get(attachmentManagerModel.getAttachmentDir() + attachmentManagerModel.getAttachmentName(), new String[0]), Paths.get(this.getSourceFilePath() + attachmentManagerModel.getId() + ".pdf", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("---------------------->>>>>>>>>>>>>>>>\u603b\u6570" + list.size() + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\u5df2\u64cd\u4f5c:" + ++i);
        }
    }

    @Override
    @Transactional
    public String deleteDoc(String kbName, String fileName) {
        AttachmentManagerModel fileModel;
        KnowledgeBaseModel model;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_base_name", kbName);
        param.put("doc_name", fileName);
        String url = this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u6587\u6863\u5220\u9664\u63a5\u53e3");
        String code = "";
        String msg = "";
        if (StringUtil.isNotEmpty((Object)url)) {
            String result = IqaHttpClientUtil.httpPost((String)url, (String)JSONObject.toJSONString(param), new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            code = jsonObject.getString("code");
            msg = jsonObject.getString("msg");
        }
        if ("200".equals(code) && (model = (KnowledgeBaseModel)this.modelDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"BASE_ID", (Object)kbName))) != null && (fileModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BUSINESS_ID", (Object)model.getId())).eq((Object)"ATTACHMENT_NAME", (Object)fileName)).eq((Object)"DEL_FLAG", (Object)"0"))) != null) {
            fileModel.setDelFlag("1");
            this.baseAttachmentManagerService.updateById(fileModel);
            Integer fileNum = model.getFileCount();
            model.setFileCount(Integer.valueOf(fileNum - 1));
            this.modelDao.updateById((Object)model);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, String knowledge_base_name, String doc_name) {
        KnowledgeBaseModel model = (KnowledgeBaseModel)this.modelDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"BASE_ID", (Object)knowledge_base_name));
        if (model != null) {
            File file;
            AttachmentManagerModel fileModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BUSINESS_ID", (Object)model.getId())).eq((Object)"ATTACHMENT_NAME", (Object)doc_name)).eq((Object)"DEL_FLAG", (Object)"0"));
            String pathtem = "D:/hussar/2022/04/14/566983530928939009.pdf";
            if (fileModel != null) {
                pathtem = fileModel.getAttachmentDir() + fileModel.getId() + ".pdf";
            }
            if ((file = new File(pathtem)).exists()) {
                byte[] data = null;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(file);
                    data = new byte[input.available()];
                    input.read(data);
                    response.setContentType("application/pdf");
                    response.addHeader("cache-control", "no-cache");
                    response.getOutputStream().write(data);
                }
                catch (Exception e) {
                    System.out.println("pdf\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a" + e);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean checkName(String kbName, String kbType) {
        boolean res = false;
        List modelList = this.modelDao.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BASE_TYPE", (Object)kbType)).eq((Object)"KB_NAME", (Object)kbName)).eq((Object)"DEL_FLAG", (Object)"0"));
        if (modelList.size() == 0) {
            res = true;
        }
        return res;
    }

    private String getSourceFilePath() {
        ApplicationContext appCtx = IqaSpringContextUtils.getApplicationContext();
        Environment environment = (Environment)appCtx.getBean(Environment.class);
        return environment.getProperty("docbase.sourceFilePath");
    }
}

