/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.generalForm.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.generalForm.dto.FormDetail;
import com.jxdinfo.hussar.ai.generalForm.dto.FormQueryParam;
import com.jxdinfo.hussar.ai.generalForm.dto.TextDto;
import com.jxdinfo.hussar.ai.generalForm.model.AIForm;
import com.jxdinfo.hussar.ai.generalForm.service.AIFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form"})
public class AIFormController {
    @Resource
    private AIFormService aiFormService;

    @PostMapping(value={"/save"})
    public ApiResponse<Map<String, Object>> save(@RequestBody FormDetail formDetail) {
        return ApiResponse.success(this.aiFormService.saveForm(formDetail));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<Long> ids) {
        return ApiResponse.success((Object)this.aiFormService.delete(ids));
    }

    @GetMapping(value={"/list"})
    public ApiResponse<Page<AIForm>> list(Page<AIForm> page, FormQueryParam queryParam) {
        return ApiResponse.success(this.aiFormService.list(page, queryParam));
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<FormDetail> detail(Long formId) {
        return ApiResponse.success((Object)this.aiFormService.detail(formId));
    }

    @PostMapping(value={"/getFormField"})
    public ApiResponse<Map> getFormField(@RequestBody TextDto textDto) {
        return ApiResponse.success((Object)this.aiFormService.getFormField(textDto));
    }
}

