/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.qaGroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.qaGroup.dao.QAGroupBaseMapper;
import com.jxdinfo.hussar.ai.qaGroup.dao.QAGroupPairMapper;
import com.jxdinfo.hussar.ai.qaGroup.dto.QueryParamsDto;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupBase;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupPair;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupSQLHistory;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupDealExcelService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupPairService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQASQLHistoryService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QAGroupDealExcelServiceImpl
extends ServiceImpl<QAGroupPairMapper, QAGroupPair>
implements IQAGroupDealExcelService {
    @Resource
    private QAGroupPairMapper groupPairMapper;
    @Resource
    private QAGroupBaseMapper groupBaseMapper;
    @Resource
    private IQASQLHistoryService historyService;
    @Resource
    private IQAGroupPairService qaGroupPairService;
    private static final Logger logger = LoggerFactory.getLogger(QAGroupDealExcelServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean excelUpload(MultipartFile file, Long baseId) {
        boolean result = true;
        HSSFWorkbook wk = null;
        ArrayList<QAGroupSQLHistory> histories = new ArrayList<QAGroupSQLHistory>();
        try {
            if (file.getOriginalFilename() != null) {
                if (file.getOriginalFilename().endsWith(".xls")) {
                    wk = new HSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
                } else if (file.getOriginalFilename().endsWith(".xlsx")) {
                    wk = new XSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
                }
            }
            int sheetNums = 0;
            if (wk != null) {
                sheetNums = wk.getNumberOfSheets();
            }
            int question = -1;
            int ans = -1;
            for (int i = 0; i < sheetNums; ++i) {
                Sheet sheet = wk.getSheetAt(i);
                boolean first = true;
                for (Row row : sheet) {
                    if (first) {
                        for (Cell cell : row) {
                            if (cell.getStringCellValue().equals("\u95ee\u9898")) {
                                question = cell.getColumnIndex();
                                continue;
                            }
                            if (!cell.getStringCellValue().equals("\u7b54\u6848")) continue;
                            ans = cell.getColumnIndex();
                        }
                        if (question == -1 || ans == -1) {
                            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
                            boolean bl = false;
                            return bl;
                        }
                        first = false;
                        continue;
                    }
                    QAGroupPair groupPair = new QAGroupPair();
                    groupPair.setParentId(0L);
                    groupPair.setQaGroupId(baseId);
                    QAGroupSQLHistory history = new QAGroupSQLHistory();
                    for (Cell cell : row) {
                        if (cell.getColumnIndex() == question) {
                            groupPair.setQuestion(cell.getStringCellValue());
                            history.setQuestion(cell.getStringCellValue());
                            continue;
                        }
                        if (cell.getColumnIndex() != ans) continue;
                        groupPair.setAnswer(cell.getStringCellValue());
                        history.setSqlAnswer(cell.getStringCellValue());
                    }
                    if (groupPair.getQuestion().isEmpty() || groupPair.getAnswer().isEmpty()) continue;
                    this.groupPairMapper.insert((Object)groupPair);
                    history.setGroupPairId(groupPair.getGroupPairId());
                    histories.add(history);
                }
            }
            this.historyService.saveBatch(histories);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
        }
        finally {
            try {
                if (wk != null) {
                    wk.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadModel(HttpServletResponse response) {
        String fileName = "QaGroupModel.xlsx";
        ServletOutputStream servletOutputStream = null;
        InputStream fileInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            fileInputStream = this.getClass().getClassLoader().getResourceAsStream("modelFile/" + fileName);
            if (fileInputStream != null) {
                outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                IOUtils.close((Closeable)fileInputStream);
                byte[] bytes = outputStream.toByteArray();
                response.setContentType("application/octet-stream");
                response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
                servletOutputStream = response.getOutputStream();
                servletOutputStream.write(bytes);
                servletOutputStream.flush();
            } else {
                response.sendError(500, "\u6587\u4ef6\u4e3a\u7a7a\u6216\u5df2\u635f\u574f");
            }
        }
        catch (IOException e) {
            logger.error("\u6a21\u7248\u4e0b\u8f7d\u5f02\u5e38");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadGroupPairs(HttpServletResponse response, QueryParamsDto queryParamsDto) {
        HussarException.throwByNull((Object)queryParamsDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        String pairType = queryParamsDto.getPairType();
        HussarException.throwByNull((Object)pairType, (String)"\u95ee\u7b54\u5bf9\u7c7b\u578b\u4e3a\u7a7a");
        HashMap<Long, String> groupPairMap = new HashMap<Long, String>();
        OutputStream outputStream = null;
        Boolean allSelected = queryParamsDto.getAllSelected();
        List<Long> groupPairIds = queryParamsDto.getGroupPairIds();
        if (allSelected.booleanValue()) {
            groupPairIds = this.qaGroupPairService.getGroupPairIds(queryParamsDto);
        }
        List groupPairs = new ArrayList();
        List entityExpandPairs = new ArrayList();
        List modelExpandPairs = new ArrayList();
        List expandPairs = new ArrayList();
        if ("1".equals(pairType)) {
            LambdaQueryWrapper pairWrapper = new LambdaQueryWrapper();
            pairWrapper.in(QAGroupPair::getGroupPairId, groupPairIds);
            groupPairs = this.groupPairMapper.selectList((Wrapper)pairWrapper);
            LambdaQueryWrapper entityWrapper = new LambdaQueryWrapper();
            entityWrapper.in(QAGroupPair::getParentId, groupPairIds);
            entityWrapper.eq(QAGroupPair::getPairType, (Object)"2");
            entityExpandPairs = this.groupPairMapper.selectList((Wrapper)entityWrapper);
            LambdaQueryWrapper modelWrapper = new LambdaQueryWrapper();
            modelWrapper.in(QAGroupPair::getParentId, groupPairIds);
            modelWrapper.eq(QAGroupPair::getPairType, (Object)"3");
            modelExpandPairs = this.groupPairMapper.selectList((Wrapper)modelWrapper);
        } else {
            LambdaQueryWrapper expandWrapper = new LambdaQueryWrapper();
            expandWrapper.eq(QAGroupPair::getPairType, (Object)pairType);
            expandWrapper.in(QAGroupPair::getGroupPairId, groupPairIds);
            expandPairs = this.groupPairMapper.selectList((Wrapper)expandWrapper);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet;
            if ("1".equals(pairType)) {
                Cell cell2;
                Cell cell1;
                Cell cell0;
                Cell cell12;
                Cell cell02;
                sheet = workbook.createSheet("\u539f\u95ee\u7b54\u5bf9");
                for (int i = 0; i < groupPairs.size() + 1; ++i) {
                    Row row = sheet.createRow(i);
                    if (i == 0) {
                        Cell cell03 = row.createCell(0);
                        Cell cell13 = row.createCell(1);
                        cell03.setCellValue("\u95ee\u9898");
                        cell13.setCellValue("\u7b54\u6848");
                        continue;
                    }
                    QAGroupPair groupPair = (QAGroupPair)((Object)groupPairs.get(i - 1));
                    cell02 = row.createCell(0);
                    cell12 = row.createCell(1);
                    cell02.setCellValue(groupPair.getQuestion());
                    cell12.setCellValue(groupPair.getAnswer());
                    groupPairMap.put(groupPair.getGroupPairId(), groupPair.getQuestion());
                }
                Sheet sheet2 = workbook.createSheet("\u6309\u5b9e\u4f53\u6269\u5145\u95ee\u7b54\u5bf9");
                for (int i = 0; i < entityExpandPairs.size() + 1; ++i) {
                    Row row = sheet2.createRow(i);
                    if (i == 0) {
                        cell02 = row.createCell(0);
                        cell12 = row.createCell(1);
                        Cell cell22 = row.createCell(2);
                        cell02.setCellValue("\u539f\u95ee\u9898");
                        cell12.setCellValue("\u6269\u5145\u540e\u95ee\u9898");
                        cell22.setCellValue("\u7b54\u6848");
                        continue;
                    }
                    QAGroupPair expandPair = (QAGroupPair)((Object)entityExpandPairs.get(i - 1));
                    cell0 = row.createCell(0);
                    cell1 = row.createCell(1);
                    cell2 = row.createCell(2);
                    cell0.setCellValue((String)groupPairMap.get(expandPair.getParentId()));
                    cell1.setCellValue(expandPair.getQuestion());
                    cell2.setCellValue(expandPair.getAnswer());
                }
                Sheet sheet3 = workbook.createSheet("\u6309\u6a21\u578b\u6269\u5145\u95ee\u7b54\u5bf9");
                for (int i = 0; i < modelExpandPairs.size() + 1; ++i) {
                    Row row = sheet3.createRow(i);
                    if (i == 0) {
                        cell0 = row.createCell(0);
                        cell1 = row.createCell(1);
                        cell2 = row.createCell(2);
                        cell0.setCellValue("\u539f\u95ee\u9898");
                        cell1.setCellValue("\u6269\u5145\u540e\u95ee\u9898");
                        cell2.setCellValue("\u7b54\u6848");
                        continue;
                    }
                    QAGroupPair expandPair = (QAGroupPair)((Object)modelExpandPairs.get(i - 1));
                    Cell cell04 = row.createCell(0);
                    Cell cell14 = row.createCell(1);
                    Cell cell23 = row.createCell(2);
                    cell04.setCellValue((String)groupPairMap.get(expandPair.getParentId()));
                    cell14.setCellValue(expandPair.getQuestion());
                    cell23.setCellValue(expandPair.getAnswer());
                }
            } else {
                QAGroupPair qaGroupPair = (QAGroupPair)((Object)this.groupPairMapper.selectById(queryParamsDto.getParentId()));
                sheet = "2".equals(pairType) ? workbook.createSheet("\u6309\u5b9e\u4f53\u6269\u5145\u95ee\u7b54\u5bf9") : workbook.createSheet("\u6309\u6a21\u578b\u6269\u5145\u95ee\u7b54\u5bf9");
                for (int i = 0; i < expandPairs.size() + 1; ++i) {
                    Row row = sheet.createRow(i);
                    if (i == 0) {
                        Cell cell0 = row.createCell(0);
                        Cell cell1 = row.createCell(1);
                        Cell cell2 = row.createCell(2);
                        cell0.setCellValue("\u539f\u95ee\u9898");
                        cell1.setCellValue("\u6269\u5145\u540e\u95ee\u9898");
                        cell2.setCellValue("\u7b54\u6848");
                        continue;
                    }
                    QAGroupPair expandPair = (QAGroupPair)((Object)expandPairs.get(i - 1));
                    Cell cell0 = row.createCell(0);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    cell0.setCellValue(qaGroupPair.getQuestion());
                    cell1.setCellValue(expandPair.getQuestion());
                    cell2.setCellValue(expandPair.getAnswer());
                }
            }
            QAGroupBase groupBase = (QAGroupBase)((Object)this.groupBaseMapper.selectById(queryParamsDto.getQaGroupId()));
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(groupBase.getQaGroupName() + ".xlsx", "utf-8"));
            outputStream = response.getOutputStream();
            workbook.write(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            logger.error("\u95ee\u7b54\u5bf9\u5bfc\u51fa\u5931\u8d25");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private Sheet createExcelSheet(Workbook workbook, List<QAGroupPair> groupPairs) {
        Sheet sheet = workbook.createSheet("\u539f\u95ee\u7b54\u5bf9");
        for (int i = 0; i < groupPairs.size() + 1; ++i) {
            Row row = sheet.createRow(i);
            if (i == 0) {
                Cell cell0 = row.createCell(0);
                Cell cell1 = row.createCell(1);
                cell0.setCellValue("\u95ee\u9898");
                cell1.setCellValue("\u7b54\u6848");
                continue;
            }
            QAGroupPair groupPair = groupPairs.get(i - 1);
            Cell cell0 = row.createCell(0);
            Cell cell1 = row.createCell(1);
            cell0.setCellValue(groupPair.getQuestion());
            cell1.setCellValue(groupPair.getAnswer());
        }
        return sheet;
    }
}

