/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.generalForm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.generalForm.factory.CombineParamFactory;
import com.jxdinfo.hussar.ai.generalForm.model.AIFormField;
import com.jxdinfo.hussar.ai.generalForm.service.CombineParamService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TableServiceImpl
implements CombineParamService {
    @Override
    public String getType() {
        return "table";
    }

    @Override
    public Map<String, Object> combineParam(AIFormField field) {
        JSONObject jsonObject;
        JSONObject fieldConfig;
        String fieldLabel = field.getFieldLabel();
        String fieldType = field.getFieldType();
        List<AIFormField> childFields = field.getChildren();
        Map<String, Object> entityConfig = this.combineChildFields(childFields);
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        param.put("label", fieldLabel);
        param.put("type", fieldType);
        param.put("entity_config", entityConfig);
        String fieldDesc = field.getFieldDesc();
        if (HussarUtils.isNotEmpty((Object)fieldDesc)) {
            param.put("description", fieldDesc);
        }
        if (HussarUtils.isNotEmpty((Object)(fieldConfig = field.getFieldConfig())) && HussarUtils.isNotEmpty((Object)(jsonObject = fieldConfig.getJSONObject("config")))) {
            ArrayList<String> list = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)jsonObject)) {
                for (String key : jsonObject.keySet()) {
                    list.add(jsonObject.getString(key));
                }
            }
            String join = StringUtils.join(list, (String)",");
            param.put("illustration", join);
        }
        return param;
    }

    private Map<String, Object> combineChildFields(List<AIFormField> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(fields)) {
            for (AIFormField aiFormField : fields) {
                String fieldCode;
                String fieldType = aiFormField.getFieldType();
                if ("single_choice".equals(fieldType) || "multiple_choice".equals(fieldType) || "true_false".equals(fieldType)) {
                    fieldType = "choice";
                }
                if ("table".equals(fieldType)) {
                    Long fieldId = aiFormField.getFieldId();
                    String fieldLabel = aiFormField.getFieldLabel();
                    String fieldDesc = aiFormField.getFieldDesc();
                    List<AIFormField> childFields = aiFormField.getChildren();
                    Map<String, Object> entityConfig = this.combineChildFields(childFields);
                    LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
                    param.put("label", fieldLabel);
                    param.put("type", fieldType);
                    param.put("entity_config", entityConfig);
                    if (HussarUtils.isNotEmpty((Object)fieldDesc)) {
                        param.put("description", fieldDesc);
                    }
                    JSONObject fieldConfig = aiFormField.getFieldConfig();
                    JSONObject jsonObject = fieldConfig.getJSONObject("config");
                    ArrayList<String> list = new ArrayList<String>();
                    if (HussarUtils.isNotEmpty((Object)jsonObject)) {
                        for (String key : jsonObject.keySet()) {
                            list.add(jsonObject.getString(key));
                        }
                    }
                    String join = StringUtils.join(list, (String)",");
                    param.put("illustration", join);
                    map.put(aiFormField.getFieldCode(), param);
                }
                if (!HussarUtils.isNotEmpty((Object)(fieldCode = aiFormField.getFieldCode())) || "table".equals(fieldType)) continue;
                CombineParamService combineParamService = CombineParamFactory.getCombineParamService(fieldType);
                Map<String, Object> params = combineParamService.combineParam(aiFormField);
                map.put(fieldCode, params);
            }
        }
        return map;
    }
}

