/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dataManager41.service.impl;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.dataManager41.common.AiUtil;
import com.jxdinfo.hussar.ai.dataManager41.dao.AiDatasourceMapper;
import com.jxdinfo.hussar.ai.dataManager41.dto.AiDataSourceDto;
import com.jxdinfo.hussar.ai.dataManager41.model.AiBaseEntity;
import com.jxdinfo.hussar.ai.dataManager41.model.AiDatasource;
import com.jxdinfo.hussar.ai.dataManager41.model.AiDatasourceConfig;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceConfigService;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaScenarioMapper;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.datasource.DataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HussarDs(value="master")
public class AiDatasourceServiceImpl
extends HussarServiceImpl<AiDatasourceMapper, AiDatasource>
implements AiDatasourceService {
    private static final Logger logger = LoggerFactory.getLogger(AiDatasourceServiceImpl.class);
    private static String CACHE_KEY_PREFIX = "AI:DATASOURCE:";
    private static String CACHE_NAME = "ai:datasource:all";
    private static Long EXPIRE_TIME = 36000L;
    @Resource
    private AiDatasourceMapper aiDatasourceMapper;
    @Autowired
    private QaScenarioMapper scenarioMapper;
    private final DynamicDatasourceService dynamicDatasourceService;
    private final AiDatasourceConfigService datasourceConfigService;
    private final DynamicDataSourceProperties dataSourceProperties;
    private final HussarTenantProperties tenantProperties;

    public AiDatasourceServiceImpl(DynamicDatasourceService dynamicDatasourceService, AiDatasourceConfigService datasourceConfigService, DynamicDataSourceProperties dataSourceProperties, HussarTenantProperties tenantProperties) {
        this.dynamicDatasourceService = dynamicDatasourceService;
        this.datasourceConfigService = datasourceConfigService;
        this.dataSourceProperties = dataSourceProperties;
        this.tenantProperties = tenantProperties;
    }

    @Override
    public AiDataSourceDto getDataSourceById(Long dbId) {
        HussarException.throwByNull((Object)dbId, (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        String key = CACHE_KEY_PREFIX + dbId;
        String str = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)key);
        if (!StringUtils.isEmpty((Object)str)) {
            return (AiDataSourceDto)JSON.parseObject((String)str, AiDataSourceDto.class);
        }
        AiDatasource dataSource = (AiDatasource)this.getById(dbId);
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        AiDataSourceDto sysDataSourceDto = this.getDataSourceDto(dataSource);
        String string = JSON.toJSONString((Object)sysDataSourceDto);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)string, (long)EXPIRE_TIME);
        return sysDataSourceDto;
    }

    @Override
    public AiDataSourceDto getDataSourceByConnName(String connName) {
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(AiDatasource::getConnName, (Object)connName)).eq(AiDatasource::getDelFlag, (Object)"0");
        AiDatasource dataSource = (AiDatasource)this.getOne((Wrapper)wrapper);
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        return this.getDataSourceDto(dataSource);
    }

    private AiDataSourceDto getDataSourceDto(AiDatasource dataSource) {
        AiDataSourceDto copy = (AiDataSourceDto)BeanUtil.copy((Object)dataSource, AiDataSourceDto.class);
        assert (copy != null);
        AiDatasourceConfig sysDatasourceConfig = (AiDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)Wrappers.lambdaQuery(AiDatasourceConfig.class).eq(AiDatasourceConfig::getDbId, (Object)copy.getDbId()));
        if (!HussarUtils.isNull((Object)sysDatasourceConfig)) {
            copy.setProperties(sysDatasourceConfig.getParameterValue());
        }
        return copy;
    }

    @DSTransactional
    public AiDataSourceDto addDatasource(AiDataSourceDto dataSource) {
        AiUtil.setBaseEntity(dataSource);
        this.checkDbName(dataSource.getDbName(), true);
        this.checkConnName(dataSource.getConnName(), true);
        this.saveDataSource(dataSource);
        this.save(dataSource);
        if (HussarUtils.isNotEmpty((Object)dataSource.getProperties())) {
            Long dbId = dataSource.getDbId();
            AiDatasourceConfig sysDatasourceConfig = new AiDatasourceConfig();
            sysDatasourceConfig.setConnName(dataSource.getConnName());
            sysDatasourceConfig.setDbId(dbId);
            sysDatasourceConfig.setParameterValue(dataSource.getProperties());
            AiUtil.setBaseEntity(sysDatasourceConfig);
            this.datasourceConfigService.save(sysDatasourceConfig);
        }
        return dataSource;
    }

    @Override
    @DSTransactional
    public AiDataSourceDto updateDatasource(AiDataSourceDto dataSourceDto) {
        String key_dbId;
        boolean b1;
        String key_connName;
        boolean b;
        String key;
        Boolean containKey;
        AiDatasource dataSource = (AiDatasource)this.getById(dataSourceDto.getDbId());
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        AiUtil.setBaseEntity(dataSourceDto);
        if (!HussarUtils.equals((Object)dataSource.getDbName(), (Object)dataSourceDto.getDbName())) {
            this.checkDbName(dataSourceDto.getDbName(), true);
        }
        if (!HussarUtils.equals((Object)dataSource.getConnName(), (Object)dataSourceDto.getConnName())) {
            this.checkConnName(dataSourceDto.getConnName(), true);
        }
        this.checkDruidFiled(dataSourceDto);
        ApiResponse<String> connResult = this.tryConnection(dataSourceDto);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (!this.updateById(dataSourceDto)) {
            throw new DataSourceException("\u4fee\u6539\u6570\u636e\u6e90\u5931\u8d25");
        }
        Long dbId = dataSourceDto.getDbId();
        this.datasourceConfigService.remove((Wrapper)Wrappers.lambdaQuery(AiDatasourceConfig.class).eq(AiDatasourceConfig::getDbId, (Object)dbId));
        if (HussarUtils.isNotEmpty((Object)dataSourceDto.getProperties())) {
            AiDatasourceConfig sysDatasourceConfig = new AiDatasourceConfig();
            sysDatasourceConfig.setDbId(dbId);
            sysDatasourceConfig.setConnName(dataSource.getConnName());
            sysDatasourceConfig.setParameterValue(dataSourceDto.getProperties());
            AiUtil.setBaseEntity(sysDatasourceConfig);
            this.datasourceConfigService.save(sysDatasourceConfig);
        }
        if ((containKey = Boolean.valueOf(HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key = CACHE_KEY_PREFIX + dbId)))).booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        if (b = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_connName = CACHE_KEY_PREFIX + dataSourceDto.getConnName()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_connName);
        }
        if (b1 = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_dbId = CACHE_KEY_PREFIX + dataSourceDto.getDbId()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_dbId);
        }
        return dataSourceDto;
    }

    @Override
    @DSTransactional
    public List<AiDatasource> deleteDataSource(List<String> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
        }
        List idList = ids.stream().map(HussarUtils::toLong).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(QaScenarioModel::getScenarioId, idList)).eq(QaScenarioModel::getDelFlag, (Object)0);
        List qaScenarioModels = this.scenarioMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)qaScenarioModels)) {
            List scenarioNames = qaScenarioModels.stream().map(QaScenarioModel::getScenarioName).collect(Collectors.toList());
            throw new HussarException("\u8be5\u6570\u636e\u6e90\u65e0\u6cd5\u5220\u9664\uff0c\u5df2\u88ab\u573a\u666f" + scenarioNames + "\u7ed1\u5b9a\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\u3002");
        }
        List list = this.listByIds(idList);
        if (!this.removeByIds(idList)) {
            throw new DataSourceException("\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(AiDatasourceConfig::getDbId, idList);
        this.datasourceConfigService.remove((Wrapper)wrapper);
        for (AiDatasource sysDataSource : list) {
            if (!HussarUtils.isNotEmpty((Object)sysDataSource.getConnName())) continue;
            this.dynamicDatasourceService.removeDynamicDatasource(sysDataSource.getConnName());
        }
        return list;
    }

    @Override
    public List<AiDataSourceDto> listDataSource() {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(AiDatasource.class).eq(AiDatasource::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)list)) {
            return new ArrayList<AiDataSourceDto>();
        }
        ArrayList<AiDataSourceDto> result = new ArrayList<AiDataSourceDto>();
        HashMap<Long, AiDataSourceDto> dataSourceDtoMap = new HashMap<Long, AiDataSourceDto>();
        for (AiDatasource dataSource : list) {
            AiDataSourceDto copy = (AiDataSourceDto)BeanUtil.copy((Object)dataSource, AiDataSourceDto.class);
            assert (copy != null);
            result.add(copy);
            dataSourceDtoMap.put(copy.getDbId(), copy);
        }
        List configs = this.datasourceConfigService.list();
        if (HussarUtils.isNotEmpty((Object)configs)) {
            for (AiDatasourceConfig config : configs) {
                AiDataSourceDto dataSourceDto = (AiDataSourceDto)dataSourceDtoMap.get(config.getDbId());
                if (HussarUtils.isEmpty((Object)dataSourceDto)) continue;
                dataSourceDto.setProperties(config.getParameterValue());
            }
        }
        return result;
    }

    @Override
    public Boolean checkDbName(String dbName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)dbName, (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(AiDatasource::getDbName, (Object)dbName)).eq(AiDatasource::getDelFlag, (Object)"0");
        boolean bl = result = this.count((Wrapper)wrapper) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    @Override
    public Boolean checkConnName(String connName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(AiDatasource::getConnName, (Object)connName)).eq(AiDatasource::getDelFlag, (Object)"0");
        boolean bl = result = this.count((Wrapper)wrapper) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    @Override
    public IPage<AiDatasource> listDataSource(Page<AiDatasource> page, AiDatasource sysDataSource) {
        if (!HussarUtils.isEmpty((Object)sysDataSource) && !HussarUtils.isEmpty(page)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysDataSource.getDbName()), AiDatasource::getDbName, (Object)sysDataSource.getDbName())).like(!StringUtils.isEmpty((Object)sysDataSource.getDriverClass()), AiDatasource::getDriverClass, (Object)sysDataSource.getDriverClass())).eq(AiDatasource::getDelFlag, (Object)"0")).eq(HussarUtils.isNotEmpty((Object)sysDataSource.getDatasourceType()), AiDatasource::getDatasourceType, (Object)sysDataSource.getDatasourceType())).orderByDesc(AiBaseEntity::getCreateTime);
            if (HussarUtils.isEmpty((Object)sysDataSource.getTenantCode())) {
                queryWrapper.eq(AiDatasource::getTenantCode, (Object)"0");
            } else {
                queryWrapper.eq(AiDatasource::getTenantCode, (Object)sysDataSource.getTenantCode());
            }
            queryWrapper.eq(AiBaseEntity::getCreator, (Object)BaseSecurityUtil.getUser().getId());
            return this.page((IPage)page, (Wrapper)queryWrapper);
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private ApiResponse<String> tryConnection(AiDataSourceDto sysDataSourceDto) {
        if (!(HussarUtils.isEmpty((Object)sysDataSourceDto) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName()))) {
            ApiResponse var4;
            Connection conn = null;
            try {
                conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
                String driverName = conn.getMetaData().getDriverName();
                var4 = ApiResponse.success((String)driverName.toUpperCase());
            }
            catch (Exception var13) {
                logger.error("errorMessage:{}", (Object)var13.getMessage(), (Object)var13);
                throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
            }
            finally {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException var12) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)var12);
                }
            }
            return var4;
        }
        throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
    }

    @Override
    @DSTransactional
    public ApiResponse<AiDatasource> saveDataSourceWithCheck(AiDataSourceDto sysDataSource, boolean isCheck) {
        sysDataSource.setConnName(sysDataSource.getDbType() + HussarUtils.randomUUID());
        AiUtil.setBaseEntity(sysDataSource);
        if (!"1".equals(sysDataSource.getIsUpdate())) {
            sysDataSource.setJdbcUrl(sysDataSource.getJdbcUrl().replaceAll("\n", ""));
            this.checkDbName(sysDataSource.getDbName(), true);
            this.checkConnName(sysDataSource.getConnName(), true);
        }
        ApiResponse<String> connResult = this.tryConnection(sysDataSource);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (isCheck) {
            return ApiResponse.success((Object)sysDataSource, (String)String.valueOf(true));
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException var5) {
            logger.error("errorMessage:{}", (Object)var5.getMessage(), (Object)var5);
        }
        this.checkDruidFiled(sysDataSource);
        this.setInstantName(sysDataSource);
        this.addDatasource(sysDataSource);
        this.saveCache(sysDataSource);
        return ApiResponse.success((Object)sysDataSource, (String)String.valueOf(true));
    }

    @Override
    public ApiResponse<Boolean> checkDataSourceById(Long id) {
        AiDatasource aiDatasource = (AiDatasource)this.aiDatasourceMapper.selectById(id);
        AiDataSourceDto aiDataSourceDto = new AiDataSourceDto();
        BeanUtil.copy((Object)aiDatasource, (Object)aiDataSourceDto);
        try {
            this.tryConnection(aiDataSourceDto);
        }
        catch (Exception e) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    private void saveCache(AiDataSourceDto sysDataSource) {
        Object tokenValue = null;
        String key = CACHE_KEY_PREFIX + sysDataSource.getDbId();
        Boolean containKey = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)key);
        if (containKey.booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        String string = JSON.toJSONString((Object)sysDataSource);
        String key_connName = CACHE_KEY_PREFIX + sysDataSource.getConnName();
        String key_dbId = CACHE_KEY_PREFIX + sysDataSource.getDbId();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_connName, (Object)string, (long)EXPIRE_TIME);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_dbId, (Object)string, (long)EXPIRE_TIME);
    }

    private void saveDataSource(AiDataSourceDto sysDataSource) {
        try {
            DynamicDataSourceDto dynamicDatasourceDto = this.getDynamicDatasourceDto(sysDataSource);
            String pollName = dynamicDatasourceDto.getPoolName();
            Set allPollName = this.dynamicDatasourceService.getAllDatasourcesName();
            if (!HussarUtils.isNotEmpty((Object)allPollName) || !allPollName.contains(pollName)) {
                this.dynamicDatasourceService.addDynamicDatasource(dynamicDatasourceDto);
            }
        }
        catch (Exception var5) {
            throw new HussarException(var5.getMessage(), (Throwable)var5);
        }
    }

    private Boolean checkTableExist(AiDataSourceDto sysDataSource) {
        this.saveDataSource(sysDataSource);
        return true;
    }

    private void setInstantName(AiDataSourceDto sysDataSourceDto) {
        if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:mysql")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getDataBaseName());
        } else if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:oracle")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getUserName());
        } else {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getExample());
        }
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException var5) {
                var5.printStackTrace();
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    private DynamicDataSourceDto getDynamicDatasourceDto(AiDataSourceDto dataSource) {
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource), (String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getConnName()), (String)"\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getUserName()), (String)"\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getPassword()), (String)"\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getJdbcUrl()), (String)"\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getDriverClass()), (String)"\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
        dynamicDataSourceDto.setPoolName(dataSource.getConnName());
        dynamicDataSourceDto.setDriverClassName(dataSource.getDriverClass());
        dynamicDataSourceDto.setUrl(dataSource.getJdbcUrl());
        dynamicDataSourceDto.setUserName(dataSource.getUserName());
        dynamicDataSourceDto.setPassword(dataSource.getPassword());
        DruidConfig druid = DynamicDatasourceUtils.createDataSourceDruid((DynamicDataSourceProperties)this.dataSourceProperties, (String)dataSource.getProperties());
        dynamicDataSourceDto.setDruidConfig(druid);
        return dynamicDataSourceDto;
    }

    private void checkDruidFiled(AiDataSourceDto dataSource) {
        String validationQuery;
        JSONObject map;
        String properties = dataSource.getProperties();
        try {
            map = HussarUtils.isEmpty((Object)properties) ? new JSONObject() : JSON.parseObject((String)properties);
        }
        catch (JSONException var10) {
            logger.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)var10);
            throw new HussarException("\u6570\u636e\u6e90\u914d\u7f6e\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getDriverClass()) && !map.containsKey((Object)"validationQuery") && HussarUtils.isNotBlank((CharSequence)(validationQuery = this.defaultValidationQuery(dataSource.getDriverClass())))) {
            map.put("validationQuery", (Object)validationQuery);
            dataSource.setProperties(JSON.toJSONString((Object)map));
        }
        if (HussarUtils.isNotEmpty((Object)map)) {
            Field[] fields = DruidConfig.class.getDeclaredFields();
            HashSet<String> fieldNames = new HashSet<String>();
            Field[] var6 = fields;
            int var7 = fields.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                Field field = var6[var8];
                fieldNames.add(field.getName());
            }
            for (String key : map.keySet()) {
                if (fieldNames.contains(key)) continue;
                throw new HussarException("\u975e\u6cd5\u5c5e\u6027\u540d" + key);
            }
        }
    }

    private String defaultValidationQuery(String driverClass) {
        if (JdbcUtils.isMySqlDriver((String)driverClass)) {
            return "SELECT 1";
        }
        if (!driverClass.equals("oracle.jdbc.OracleDriver") && !driverClass.equals("oracle.jdbc.driver.OracleDriver")) {
            if (!(driverClass.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver") || driverClass.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver") || driverClass.equals("net.sourceforge.jtds.jdbc.Driver"))) {
                return !driverClass.equals("org.postgresql.Driver") && !driverClass.equals("com.highgo.jdbc.Driver") && !driverClass.equals("com.edb.Driver") && !driverClass.equals("com.aliyun.polardb.Driver") ? null : "SELECT 'x'";
            }
            return "SELECT 1";
        }
        return "SELECT 'x' FROM DUAL";
    }

    @HussarDs(value="#connName")
    public Boolean checkTableExist(String connName, AiDataSourceDto sysDataSource) {
        String dsName;
        String dbName;
        String url = sysDataSource.getJdbcUrl();
        String userName = sysDataSource.getUserName();
        if (url.startsWith("jdbc:mysql") ? this.aiDatasourceMapper.mysqlTableNum(dbName = (dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"))).substring(dsName.indexOf("/") + 1)) > 0 : (url.startsWith("jdbc:oracle") ? this.aiDatasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:oscar") ? this.aiDatasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:dm") ? this.aiDatasourceMapper.oracleTableNum(userName) > 0 : this.aiDatasourceMapper.pgSqlTableNum() > 0)))) {
            return false;
        }
        return true;
    }
}

