/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.docKnowledgeBase.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.ai.docKnowledgeBase.controller.DocKnowledgeBaseController;
import com.jxdinfo.hussar.ai.docKnowledgeBase.dto.SplittingStrategyDataset;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QASplittingStrategy;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.ISplittingStrategyService;
import com.jxdinfo.hussar.ai.docKnowledgeBase.vo.SplittingStrategyVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/splitStrategy"})
public class SplittingStrategyController {
    private static final Logger log = LoggerFactory.getLogger(DocKnowledgeBaseController.class);
    @Autowired
    private ISplittingStrategyService strategyService;

    @RequestMapping(value={"/get"})
    public ApiResponse<SplittingStrategyVO> selectSplittingStrategy(@RequestBody SplittingStrategyDataset strategyDataset) {
        try {
            return ApiResponse.success((Object)this.strategyService.selectSplittingStrategy(strategyDataset));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u7b56\u7565\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/save"})
    public ApiResponse<Long> insertSplittingStrategy(@RequestBody QASplittingStrategy qaSplittingStrategy) {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(QASplittingStrategy::getName, (Object)qaSplittingStrategy.getName());
            List list = this.strategyService.list((Wrapper)queryWrapper);
            if (list.size() > 0) {
                return ApiResponse.fail((String)"\u5207\u5206\u7b56\u7565\u91cd\u540d");
            }
            return ApiResponse.success((Object)this.strategyService.insertSplittingStrategy(qaSplittingStrategy));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u7b56\u7565\u65b0\u589e\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/upd"})
    public ApiResponse<Boolean> updateSplittingStrategy(@RequestBody QASplittingStrategy qaSplittingStrategy) {
        try {
            return ApiResponse.success((Object)this.strategyService.updateSplittingStrategy(qaSplittingStrategy));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u7b56\u7565\u66f4\u65b0\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/del"})
    public ApiResponse<Boolean> delSplittingStrategyByBatch(@RequestBody List<Long> ids) {
        try {
            return ApiResponse.success((Object)this.strategyService.delSplittingStrategyByBatch(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u7b56\u7565\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/text"})
    public ApiResponse<String> splittingText(@RequestBody String text) {
        try {
            return ApiResponse.success((String)this.strategyService.splittingText(text));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u6587\u672c\u5931\u8d25");
        }
    }
}

