/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dialogue.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.dialogue.service.IModelQALeaveMarkService;
import com.jxdinfo.hussar.dialogue.dto.DocQuestion;
import com.jxdinfo.hussar.dialogue.dto.TransFileDTO;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.util.StreamRequestUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/mqaLeaveMark"})
public class ModelQALeaveMarkController {
    @Resource
    private IModelQALeaveMarkService iModelQALeaveMarkService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private IDialogueService dialogueService;

    @PostMapping(value={"/createKnowledBase"})
    public ApiResponse createKnowledBase(@RequestBody Map<String, String> param) {
        try {
            String knowledge_base_name = param.get("knowledge_base_name");
            String knowledge_base_type = param.get("knowledge_base_type");
            return ApiResponse.success((String)this.iModelQALeaveMarkService.createKnowledBase(knowledge_base_name, knowledge_base_type));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getknowledgeBasesList"})
    public ApiResponse getknowledgeBasesList(@RequestBody Map<String, String> param) {
        try {
            String queryName = param.get("query");
            String queryType = param.get("type");
            return ApiResponse.success(this.iModelQALeaveMarkService.getknowledgeBasesList(queryName, queryType));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delKnowledBase"})
    public ApiResponse delKnowledBase(@RequestBody Map<String, String> param) {
        try {
            String knowledge_base_name = param.get("knowledge_base_name");
            String knowledge_base_type = param.get("knowledge_base_type");
            return ApiResponse.success((String)this.iModelQALeaveMarkService.delKnowledBase(knowledge_base_name, knowledge_base_type));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/moveKnowledBase"})
    public ApiResponse moveKnowledBase(@RequestBody List<Map<String, String>> knowledgeBaseList) {
        try {
            return ApiResponse.success((String)this.iModelQALeaveMarkService.moveKnowledBase(knowledgeBaseList));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getDocsList"})
    public ApiResponse getDocsList(@RequestBody Map<String, String> param) {
        try {
            String knowledge_base_name = param.get("knowledge_base_name");
            String query = param.get("query");
            int pageNo = Integer.parseInt(param.get("pageNo") == null ? "1" : param.get("pageNo"));
            int pageSize = Integer.parseInt(param.get("pageSize") == null ? "10" : param.get("pageSize"));
            return ApiResponse.success(this.iModelQALeaveMarkService.getDocsList(knowledge_base_name, query, pageNo, pageSize));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/uploadDoc"})
    public ApiResponse uploadDoc(String knowledge_base_name, MultipartHttpServletRequest multipartRequest, Integer chunk_size, Integer overlap_size) {
        try {
            return ApiResponse.success((String)this.iModelQALeaveMarkService.uploadDoc(knowledge_base_name, multipartRequest, chunk_size, overlap_size));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/handleFile"})
    public ApiResponse handleFile() throws IOException {
        this.iModelQALeaveMarkService.handleFile();
        return ApiResponse.success();
    }

    @PostMapping(value={"/fileUp"})
    public ApiResponse fileUp(@RequestBody TransFileDTO transFileDTO) {
        try {
            this.iModelQALeaveMarkService.fileUp(transFileDTO);
            return ApiResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getDocDataFlux"}, produces={"text/event-stream"})
    @CrossOrigin
    public Flux<String> getDocDataFlux(@RequestBody DocQuestion docQuestion) {
        StreamRequestUtil streamRequestUtil = new StreamRequestUtil();
        docQuestion.setStream(Boolean.valueOf(true));
        Flux stringFlux = streamRequestUtil.requestStreamFlux(docQuestion, this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u6587\u672c\u95ee\u7b54\u63a5\u53e3"));
        stringFlux.collectList().subscribe(strings -> {
            JSONObject answer = new JSONObject();
            StringBuilder messageBuilder = new StringBuilder();
            for (int i = 0; i < strings.size(); ++i) {
                JSONObject jsonObject = JSONObject.parseObject((String)((String)strings.get(i)));
                String message = jsonObject.getString("message");
                if (HussarUtils.isEmpty((Object)message)) {
                    messageBuilder.append((String)strings.get(i));
                    break;
                }
                if (i == 0) {
                    answer.put("doc", (Object)jsonObject.getJSONArray("doc"));
                }
                messageBuilder.append(message);
            }
            answer.put("message", (Object)messageBuilder.toString());
            DialogueQa dialogueQa = new DialogueQa();
            dialogueQa.setQaType("1");
            dialogueQa.setDialogueName(docQuestion.getQuery());
            dialogueQa.setQuestions(docQuestion.getQuery());
            dialogueQa.setDialogueId(Long.valueOf(docQuestion.getUid()));
            dialogueQa.setAnswers(answer.toJSONString());
            dialogueQa.setScenarioId(Long.valueOf(docQuestion.getKnowledge_base_name()));
            this.dialogueService.addDialogueQa(dialogueQa);
        });
        return stringFlux;
    }

    @PostMapping(value={"/getDocData"})
    @CrossOrigin
    public String getDocData(@RequestBody DocQuestion docQuestion) {
        StreamRequestUtil streamRequestUtil = new StreamRequestUtil();
        docQuestion.setStream(Boolean.valueOf(false));
        String stringFlux = streamRequestUtil.requestStream(docQuestion, this.sysDicSingleService.getDictValue(Long.valueOf(819504347712069632L), "\u77e5\u8bc6\u5e93\u6587\u672c\u95ee\u7b54\u63a5\u53e3"));
        DialogueQa dialogueQa = new DialogueQa();
        dialogueQa.setQaType("1");
        dialogueQa.setDialogueName(docQuestion.getQuery());
        dialogueQa.setQuestions(docQuestion.getQuery());
        dialogueQa.setDialogueId(Long.valueOf(docQuestion.getUid()));
        dialogueQa.setAnswers(stringFlux);
        dialogueQa.setScenarioId(Long.valueOf(docQuestion.getKnowledge_base_name()));
        this.dialogueService.addDialogueQa(dialogueQa);
        return stringFlux;
    }

    @GetMapping(value={"/printThreadPoolStatus"})
    public ApiResponse printThreadPoolStatus() {
        try {
            return ApiResponse.success((String)this.iModelQALeaveMarkService.printThreadPoolStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteDoc"})
    public ApiResponse deleteDoc(@RequestBody Map<String, String> param) {
        try {
            String knowledge_base_name = param.get("knowledge_base_name");
            String doc_name = param.get("doc_name");
            return ApiResponse.success((String)this.iModelQALeaveMarkService.deleteDoc(knowledge_base_name, doc_name));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteDocs"})
    public ApiResponse deleteManyDocs(@RequestBody Map<String, String> param) {
        try {
            String[] doc_name_array;
            String knowledge_base_name = param.get("knowledge_base_name");
            String doc_names_json = param.get("doc_names_json");
            for (String doc_name : doc_name_array = doc_names_json.split(",")) {
                this.iModelQALeaveMarkService.deleteDoc(knowledge_base_name, doc_name);
            }
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/previewPdf"})
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="knowledge_base_name") String knowledge_base_name, @RequestParam(value="doc_name") String doc_name) {
        this.iModelQALeaveMarkService.previewPdf(request, response, knowledge_base_name, doc_name);
    }

    @PostMapping(value={"/checkName"})
    public ApiResponse checkName(@RequestBody Map<String, String> param) {
        try {
            String knowledge_base_name = param.get("knowledge_base_name");
            String knowledge_base_type = param.get("knowledge_base_type");
            return ApiResponse.success((Object)this.iModelQALeaveMarkService.checkName(knowledge_base_name, knowledge_base_type));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

