/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.directoryNavigation.config.NavModelConfig;
import com.jxdinfo.hussar.ai.directoryNavigation.constant.DirectoryNavConstant;
import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryBusiness;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.ai.directoryNavigation.service.INavModelService;
import com.jxdinfo.hussar.ai.directoryNavigation.util.WebClientService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class NavModelServiceImpl
implements INavModelService {
    @Resource
    private NavModelConfig navModelConfig;
    private static final Logger logger = LoggerFactory.getLogger(NavModelServiceImpl.class);

    @Override
    public Flux<String> uploadKnowledgeBase(Directory directory) {
        JSONObject params = this.getUploadParams(directory);
        WebClientService webClientService = new WebClientService();
        return webClientService.postStreamRequest(this.navModelConfig.getUploadUrl(), params);
    }

    @Override
    public String requestModel(String knowledgeBaseId, String userQuery, Integer resultNum) {
        WebClientService webClientService = new WebClientService();
        JSONObject params = new JSONObject();
        params.put("id", (Object)knowledgeBaseId);
        params.put("text", (Object)userQuery);
        params.put("num", (Object)(resultNum == null ? 5 : resultNum));
        params.put("thr_sim_name", (Object)0.47);
        params.put("thr_sim_embed", (Object)0.54);
        return (String)webClientService.postRequest(this.navModelConfig.getTestUrl(), params).doOnError(error -> logger.error("\u667a\u80fd\u5bfc\u822a\u6a21\u578b\u670d\u52a1\u8bf7\u6c42\u5931\u8d25", error)).block();
    }

    @Override
    public void extractKeywords(List<DirectoryNode> nodes) {
        WebClientService webClientService = new WebClientService();
        JSONObject params = this.getExtractParams(nodes);
        String response = (String)webClientService.postRequest(this.navModelConfig.getExtractKeywordsUrl(), params).doOnError(error -> logger.error("\u5173\u952e\u8bcd\u63d0\u53d6\u8bf7\u6c42\u5931\u8d25", error)).block();
        JSONObject result = JSONObject.parseObject((String)response).getJSONObject("result");
        for (DirectoryNode node : nodes) {
            JSONArray thesaurusByExplanation = result.getJSONArray(node.getId());
            HashSet thesaurusByExplanationSet = new HashSet(thesaurusByExplanation.toJavaList(String.class));
            if (thesaurusByExplanationSet.isEmpty()) continue;
            String newThesaurusByExplanation = "";
            thesaurusByExplanationSet.remove(node.getNodeName());
            if (node.getThesaurusByExplanation() != null && !node.getThesaurusByExplanation().isEmpty()) {
                newThesaurusByExplanation = node.getThesaurusByExplanation() + DirectoryNavConstant.KEYWORD_SEPARATOR.getCode();
                List explanationThesaurus = Arrays.stream(node.getThesaurusByExplanation().split(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())).collect(Collectors.toList());
                for (String thesaurus : explanationThesaurus) {
                    thesaurusByExplanationSet.remove(thesaurus);
                }
            }
            newThesaurusByExplanation = newThesaurusByExplanation + String.join((CharSequence)DirectoryNavConstant.KEYWORD_SEPARATOR.getCode(), thesaurusByExplanationSet);
            node.setThesaurusByExplanation(newThesaurusByExplanation);
        }
    }

    @Override
    public void extractNodesKeywords(List<DirectoryNode> nodes) {
        JSONObject params = this.getExtractParams(nodes);
        WebClientService webClientService = new WebClientService();
        String response = (String)webClientService.postRequest(this.navModelConfig.getExtractKeywordsUrl(), params).doOnError(error -> logger.error("\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u5173\u952e\u8bcd\u63d0\u53d6\u5931\u8d25", error)).block();
        JSONObject result = JSONObject.parseObject((String)response).getJSONObject("result");
        for (DirectoryNode node : nodes) {
            JSONArray thesaurusByExplanation = result.getJSONArray(node.getId());
            LinkedHashSet thesaurusSet = new LinkedHashSet(thesaurusByExplanation.toJavaList(String.class));
            thesaurusSet.remove(node.getNodeName());
            if (node.getThesaurusByExplanation() != null && !node.getThesaurusByExplanation().isEmpty()) {
                List explanationThesaurus = Arrays.stream(node.getThesaurusByExplanation().split(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())).collect(Collectors.toList());
                for (String thesaurus : explanationThesaurus) {
                    thesaurusSet.remove(thesaurus);
                }
            }
            node.setNewKeywords(thesaurusSet.stream().collect(Collectors.joining(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())));
        }
    }

    private JSONObject getExtractParams(List<DirectoryNode> nodes) {
        JSONObject params = new JSONObject();
        JSONObject menu = new JSONObject();
        params.put("menu", (Object)menu);
        for (DirectoryNode node : nodes) {
            JSONObject nodeJson = new JSONObject();
            menu.put(node.getId(), (Object)nodeJson);
            nodeJson.put("name", (Object)node.getNodeName());
            nodeJson.put("description", (Object)node.getExplanation());
        }
        return params;
    }

    private JSONObject getUploadParams(Directory directory) {
        JSONObject params = new JSONObject();
        if (directory.getKnowledgeBaseId() == null || directory.getKnowledgeBaseId().isEmpty()) {
            String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            directory.setKnowledgeBaseId(directory.getDirectoryName() + "_" + now);
        }
        params.put("id", (Object)directory.getKnowledgeBaseId());
        JSONObject base = new JSONObject();
        JSONObject thesaurus = new JSONObject();
        JSONObject main = new JSONObject();
        base.put("thesaurus", (Object)thesaurus);
        base.put("main", (Object)main);
        this.nodeTreeToJson(main, directory.getChildren());
        this.thesaurusToJson(thesaurus, directory.getBusinessList());
        params.put("base", (Object)base);
        return params;
    }

    private void thesaurusToJson(JSONObject parent, List<DirectoryBusiness> thesaurusList) {
        if (thesaurusList == null || thesaurusList.isEmpty()) {
            return;
        }
        for (DirectoryBusiness thesaurus : thesaurusList) {
            JSONObject thesaurusJson = new JSONObject();
            parent.put(thesaurus.getBusinessId().toString(), (Object)thesaurusJson);
            thesaurusJson.put("name", (Object)thesaurus.getBusinessName());
            thesaurusJson.put("thesaurus", Arrays.stream(thesaurus.getThesaurus().split(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())).map(String::trim).collect(Collectors.toSet()));
        }
    }

    private void nodeTreeToJson(JSONObject parent, List<DirectoryNode> nodeTree) {
        if (nodeTree == null || nodeTree.isEmpty()) {
            return;
        }
        for (DirectoryNode node : nodeTree) {
            JSONObject nodeJson = new JSONObject();
            parent.put(node.getNodeId().toString(), (Object)nodeJson);
            nodeJson.put("name", (Object)node.getNodeName());
            HashSet label = new HashSet();
            if (node.getThesaurus() != null && !node.getThesaurus().isEmpty()) {
                label.addAll(Arrays.stream(node.getThesaurus().split(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())).map(String::trim).collect(Collectors.toSet()));
            }
            if (node.getExplanation() != null && !node.getExplanation().isEmpty()) {
                nodeJson.put("explanation", (Object)node.getExplanation());
            }
            if (node.getThesaurusByExplanation() != null && !node.getThesaurusByExplanation().isEmpty()) {
                label.addAll(Arrays.stream(node.getThesaurusByExplanation().split(DirectoryNavConstant.KEYWORD_SEPARATOR.getCode())).map(String::trim).collect(Collectors.toSet()));
            }
            label.remove(node.getNodeName());
            if (!label.isEmpty()) {
                nodeJson.put("label", label);
            }
            if (node.getChildren() == null || node.getChildren().isEmpty()) continue;
            JSONObject children = new JSONObject();
            nodeJson.put("sub_menu", (Object)children);
            this.nodeTreeToJson(children, node.getChildren());
        }
    }
}

