/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.datamanager.common.DataBaseContentFileUtil;
import com.jxdinfo.hussar.ai.datamanager.dto.QADateBaseContentDto;
import com.jxdinfo.hussar.ai.datamanager.model.QADateBaseContent;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentExcelQuery;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentModelQuery;
import com.jxdinfo.hussar.ai.datamanager.service.QADateBaseContentService;
import com.jxdinfo.hussar.ai.datamanager.vo.DataGroupVO;
import com.jxdinfo.hussar.ai.datamanager.vo.QADateBaseContentVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u95ee\u7b54\u6570\u636e\u7ec4"})
@RestController
@RequestMapping(value={"qa/databaseContent"})
public class QADateBaseContentController {
    @Resource
    private DataBaseContentFileUtil fileUtil;
    @Resource
    private QADateBaseContentService qaDateBaseContentService;

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<QADateBaseContentVO>> list(Page<QADateBaseContent> page, QADateBaseContent aiDataBaseContent) {
        return ApiResponse.success(this.qaDateBaseContentService.listQaDateBaseContent(page, aiDataBaseContent));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@RequestBody QADateBaseContent aiDataBaseContent) {
        this.qaDateBaseContentService.saveOrUpdate((Object)aiDataBaseContent);
        return ApiResponse.success((Object)((Object)aiDataBaseContent));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<String> ids) {
        return ApiResponse.success((Object)this.qaDateBaseContentService.removeDateBaseContentByIds(ids));
    }

    @GetMapping(value={"/findAll"})
    public ApiResponse<List<DataGroupVO>> findAll() {
        return ApiResponse.success(this.qaDateBaseContentService.findAll());
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<QADateBaseContent> detail(Long id) {
        return ApiResponse.success((Object)this.qaDateBaseContentService.getById(id));
    }

    @PostMapping(value={"/upload"})
    public ApiResponse<Long> upload(@RequestParam(value="fileList") List<MultipartFile> fileList, QADateBaseContentDto contentDto) {
        Long result = this.qaDateBaseContentService.createQaDateBaseContent(fileList, contentDto);
        if (result == 0L) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f");
        }
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/downloadModel"})
    public void downloadModel(HttpServletResponse response, @RequestBody DataBaseContentModelQuery query) {
        this.fileUtil.downloadModel(response, query);
    }

    @PostMapping(value={"/downloadExcel"})
    public void download(HttpServletResponse response, @RequestBody DataBaseContentExcelQuery query) {
        this.fileUtil.downloadExcel(response, query);
    }
}

