/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.constant.SysWorkstationConstant;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemLayoutMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateRoleMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysWorkstationTemplateDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssembly;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssemblyAttr;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemLayout;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplate;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplateRole;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplateUser;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyAttrService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemLayoutService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateRoleService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateUserService;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationSimpleTemplateVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationUserAllTemplateVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationTemplateServiceImpl")
public class SysWorkstationTemplateServiceImpl
extends HussarServiceImpl<SysWorkstationTemplateMapper, SysWorkstationTemplate>
implements ISysWorkstationTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysWorkstationTemplateServiceImpl.class);
    @Resource
    private SysWorkstationTemplateMapper sysWorkstationTemplateMapper;
    @Resource
    private SysWorkstationTemplateRoleMapper sysWorkstationTemplateRoleMapper;
    @Resource
    private SysWorkstationTemLayoutMapper sysWorkstationTemLayoutMapper;
    @Autowired
    private ISysWorkstationTemplateRoleService sysWorkstationTemplateRoleService;
    @Autowired
    private ISysWorkstationTemLayoutService sysWorkstationTemLayoutService;
    @Autowired
    private ISysWorkstationTemplateUserService sysWorkstationTemplateUserService;
    @Autowired
    private ISysWorkstationAssemblyService sysWorkstationAssemblyService;
    @Autowired
    private ISysWorkstationAssemblyAttrService sysWorkstationAssemblyAttrService;
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Autowired
    private IHussarBasePostBoService hussarBasePostBoService;

    @HussarTransactional
    public SysWorkstationTemplateVo saveTemplate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        SysWorkstationTemplate sysWorkstationTemplate = new SysWorkstationTemplate();
        BeanUtils.copyProperties((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        Integer maxSeq = this.sysWorkstationTemplateMapper.getMaxSeq();
        maxSeq = HussarUtils.equals(null, (Object)maxSeq) && HussarUtils.equals((Object)0, (Object)maxSeq) ? Integer.valueOf(1) : Integer.valueOf(maxSeq + 1);
        sysWorkstationTemplate.setSeq(maxSeq.intValue());
        this.sysWorkstationTemplateMapper.insert(sysWorkstationTemplate);
        SysWorkstationTemLayout sysWorkstationTemLayout = (SysWorkstationTemLayout)sysWorkstationTemplateDto.getWtlList().get(0);
        if (HussarUtils.isNotEmpty((Object)sysWorkstationTemLayout)) {
            sysWorkstationTemLayout.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            this.sysWorkstationTemLayoutService.save((Object)sysWorkstationTemLayout);
            sysWorkstationTemplateVo.setWtlList(Collections.singletonList(sysWorkstationTemLayout));
        }
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        return sysWorkstationTemplateVo;
    }

    @HussarTransactional
    public SysWorkstationTemplateVo updateTemplate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysWorkstationTemplate::getId, (Object)sysWorkstationTemplateDto.getId()));
        if (HussarUtils.isEmpty((Object)sysWorkstationTemplate)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_TEMPLATE_DELETED.getMessage()));
        }
        HussarUtils.copy((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        this.sysWorkstationTemplateMapper.updateById(sysWorkstationTemplate);
        SysWorkstationTemLayout sysWorkstationTemLayoutDto = (SysWorkstationTemLayout)sysWorkstationTemplateDto.getWtlList().get(0);
        if (HussarUtils.isNotEmpty((Object)sysWorkstationTemLayoutDto)) {
            if (HussarUtils.isNotEmpty((Object)sysWorkstationTemLayoutDto.getId())) {
                SysWorkstationTemLayout sysWorkstationTemLayout = (SysWorkstationTemLayout)this.sysWorkstationTemLayoutService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysWorkstationTemLayout::getId, (Object)sysWorkstationTemLayoutDto.getId()));
                HussarUtils.copy((Object)sysWorkstationTemLayoutDto, (Object)sysWorkstationTemLayout);
                this.sysWorkstationTemLayoutService.updateById((Object)sysWorkstationTemLayout);
                sysWorkstationTemplateVo.setWtlList(Collections.singletonList(sysWorkstationTemLayout));
            } else {
                sysWorkstationTemLayoutDto.setWorkstationTemplateId(sysWorkstationTemplateDto.getId());
                this.sysWorkstationTemLayoutService.save((Object)sysWorkstationTemLayoutDto);
                sysWorkstationTemplateVo.setWtlList(Collections.singletonList(sysWorkstationTemLayoutDto));
            }
        } else {
            this.sysWorkstationTemLayoutService.remove((Wrapper)new LambdaQueryWrapper().eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)sysWorkstationTemplateDto.getId()));
        }
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        return sysWorkstationTemplateVo;
    }

    @HussarTransactional
    public ApiResponse<SysWorkstationTemplateVo> insertOrUpdate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        if (HussarUtils.isEmpty((Object)sysWorkstationTemplateDto.getId())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_TEMPLATE_ID_EMPTY.getMessage()));
        }
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysWorkstationTemplate::getId, (Object)sysWorkstationTemplateDto.getId()));
        HussarUtils.copy((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        this.sysWorkstationTemplateMapper.updateById(sysWorkstationTemplate);
        List wtrList = sysWorkstationTemplateDto.getWtrList();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplateDto.getId());
        this.sysWorkstationTemplateRoleService.remove((Wrapper)queryWrapper);
        if (null != wtrList && sysWorkstationTemplateDto.getSeeRange().equals("1")) {
            for (SysWorkstationTemplateRole wtr : wtrList) {
                wtr.setWorkstationTemplateId(sysWorkstationTemplateDto.getId());
                this.sysWorkstationTemplateRoleService.insertOrUpdate(wtr);
            }
            sysWorkstationTemplateDto.setWtrList(wtrList);
        }
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        HussarUtils.copy((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplateVo);
        return ApiResponse.success((Object)sysWorkstationTemplateVo);
    }

    public SysWorkstationUserAllTemplateVo listUserTemplateData(String applicationScenario) {
        long l = System.currentTimeMillis();
        SysWorkstationUserAllTemplateVo sysWorkstationUserAllTemplateVo = new SysWorkstationUserAllTemplateVo();
        SecurityUser user = BaseSecurityUtil.getUser();
        JSONArray roleList = JSON.parseArray((String)Optional.ofNullable(user.getExtendUserMap().get("rolesList")).map(Object::toString).orElse(""));
        if (!(user.getAccount().equals("superadmin") || BaseSecurityUtil.isAdmin() || roleList.contains((Object)SysWorkstationConstant.TENANT_ADMIN_ROLE))) {
            this.ordinaryPersonalTemplate(applicationScenario, sysWorkstationUserAllTemplateVo);
            this.ordinaryCommonTemplate(applicationScenario, sysWorkstationUserAllTemplateVo);
        } else {
            this.adminPersonalTemplate(applicationScenario, sysWorkstationUserAllTemplateVo);
            this.adminCommonTemplate(applicationScenario, sysWorkstationUserAllTemplateVo);
        }
        SysWorkstationTemplateUser startUserTemplate = this.sysWorkstationTemplateUserService.getStartUserTemplate(applicationScenario);
        if (HussarUtils.isNotEmpty((Object)startUserTemplate)) {
            sysWorkstationUserAllTemplateVo.setStartTemplateId(startUserTemplate.getWorkstationTemplateId());
        } else {
            sysWorkstationUserAllTemplateVo.setStartTemplateId(this.sysWorkstationTemplateUserService.getDefaultTemplateId(applicationScenario));
        }
        long l2 = System.currentTimeMillis();
        LOGGER.info("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u6240\u6709\u6a21\u677f\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(l2 - l));
        return sysWorkstationUserAllTemplateVo;
    }

    public SysWorkstationTemplateVo getTemplateById(Long workstationTemplateId) {
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById(workstationTemplateId);
        SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
        if (HussarUtils.isEmpty((Object)sysWorkstationTemplate)) {
            return vo;
        }
        TranslateUtil.translate((Object)sysWorkstationTemplate, SysWorkstationTemplate::getWorkstationTemplateName, SysWorkstationTemplate::setWorkstationTemplateName);
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)vo);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId());
        List layoutList = this.sysWorkstationTemLayoutService.list((Wrapper)queryWrapper);
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<Map> layoutConfigurationList = new ArrayList<Map>();
            ArrayList<Map> resMap = new ArrayList<Map>();
            for (SysWorkstationTemLayout layout : layoutList) {
                String templateConfiguration = layout.getTemplateConfiguration();
                JSONArray configurationJsonArray = JSON.parseArray((String)templateConfiguration);
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Object configuration : configurationJsonArray) {
                    Map map = (Map)mapper.convertValue(configuration, Map.class);
                    Object moduleId = map.get("moduleId");
                    if (!HussarUtils.isNotEmpty(moduleId)) continue;
                    ids.add(Long.parseLong(moduleId.toString()));
                    layoutConfigurationList.add(map);
                }
                List<SysWorkstationAssemblyAttr> attrByAssemblyIds = this.getAttrByAssemblyIds(ids);
                List assemblyList = this.sysWorkstationAssemblyService.listByIds(ids);
                if (HussarUtils.isEmpty((Object)assemblyList)) {
                    return vo;
                }
                HashMap<Long, String> seeRangeMap = new HashMap<Long, String>();
                for (SysWorkstationAssembly assembly : assemblyList) {
                    if (!"1".equals(assembly.getApplyFlag())) continue;
                    seeRangeMap.put(assembly.getId(), assembly.getSeeRange());
                }
                Map flag = this.sysWorkstationAssemblyService.loadUserAssemblyPowers(seeRangeMap, ids);
                for (int i = 0; i < layoutConfigurationList.size(); ++i) {
                    Map map = (Map)layoutConfigurationList.get(i);
                    List res = attrByAssemblyIds.stream().filter(r -> String.valueOf(r.getAssemblyId()).equals(String.valueOf(map.get("moduleId")))).collect(Collectors.toList());
                    if (res == null || res.size() <= 0) continue;
                    map.put("flag", flag.get(Long.valueOf(String.valueOf(map.get("moduleId")))));
                    map.put("router", ((SysWorkstationAssemblyAttr)res.get(0)).getRoutingAddress());
                    map.put("assemblyIdentifying", ((SysWorkstationAssemblyAttr)res.get(0)).getAssemblyIdentifying());
                    map.put("minH", ((SysWorkstationAssemblyAttr)res.get(0)).getMinHeight());
                    map.put("minW", ((SysWorkstationAssemblyAttr)res.get(0)).getMinWidth());
                    resMap.add(map);
                }
                String jsonString = JSON.toJSONString(resMap);
                layout.setTemplateConfiguration(jsonString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setWtlList(layoutList);
        return vo;
    }

    private SysWorkstationAssemblyAttr getAttrByAssemblyId(Long assemblyId) {
        SysWorkstationAssemblyAttr sysWorkstationAssemblyAttr = null;
        LambdaQueryWrapper attrWrapper = Wrappers.lambdaQuery();
        attrWrapper.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)assemblyId);
        List attrList = this.sysWorkstationAssemblyAttrService.list((Wrapper)attrWrapper);
        if (HussarUtils.isNotEmpty((Object)attrList)) {
            sysWorkstationAssemblyAttr = (SysWorkstationAssemblyAttr)attrList.get(0);
        }
        return sysWorkstationAssemblyAttr;
    }

    private List<SysWorkstationAssemblyAttr> getAttrByAssemblyIds(List<Long> assemblyIds) {
        LambdaQueryWrapper attrWrapper = Wrappers.lambdaQuery();
        attrWrapper.in(SysWorkstationAssemblyAttr::getAssemblyId, assemblyIds);
        return this.sysWorkstationAssemblyAttrService.list((Wrapper)attrWrapper);
    }

    public SysWorkstationTemplateVo LoadTemplateRoleById(Long workstationTemplateId) {
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById(workstationTemplateId);
        SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
        if (!HussarUtils.isNotEmpty((Object)sysWorkstationTemplate)) {
            return vo;
        }
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)vo);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId());
        List roleList = this.sysWorkstationTemplateRoleService.list((Wrapper)queryWrapper1);
        if (HussarUtils.isNotEmpty((Object)roleList)) {
            List<SysWorkstationTemplateRole> sysWorkstationTemplateRoles;
            Map<String, List<SysWorkstationTemplateRole>> roleMap = roleList.stream().collect(Collectors.groupingBy(SysWorkstationTemplateRole::getPermissionTypes));
            roleList.clear();
            if (HussarUtils.isNotEmpty(roleMap.get("0"))) {
                try {
                    List organIds = roleMap.get("0").stream().map(SysWorkstationTemplateRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(organIds)) {
                        List organList = this.hussarBaseOrganizationBoService.getSimpleOrganByIds(organIds);
                        sysWorkstationTemplateRoles = this.compareOrganList(roleMap.get("0"), organList);
                        roleList.addAll(sysWorkstationTemplateRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_ORG_QUERY_EMPTY.getMessage()));
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("1"))) {
                try {
                    List identitys = roleMap.get("1").stream().map(SysWorkstationTemplateRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(identitys)) {
                        List roleInfoByIds = this.sysRolesExternalService.getRoleInfoByIds(identitys);
                        sysWorkstationTemplateRoles = this.compareRoleList(roleMap.get("1"), roleInfoByIds);
                        roleList.addAll(sysWorkstationTemplateRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_RULE_QUERY_EMPTY.getMessage()));
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("2"))) {
                try {
                    List postIds = roleMap.get("2").stream().map(SysWorkstationTemplateRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(postIds)) {
                        List postInfoByIds = this.hussarBasePostBoService.getPostInfoByIds(postIds);
                        sysWorkstationTemplateRoles = this.comparePostList(roleMap.get("2"), postInfoByIds);
                        roleList.addAll(sysWorkstationTemplateRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_USER_QUERY_EMPTY.getMessage()));
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("3"))) {
                try {
                    List userIds = roleMap.get("3").stream().map(SysWorkstationTemplateRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(userIds)) {
                        Map map = this.hussarBaseUserBoService.getUserInfo(userIds);
                        sysWorkstationTemplateRoles = this.comparePersonList(roleMap.get("3"), map);
                        roleList.addAll(sysWorkstationTemplateRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_USER_QUERY_EMPTY.getMessage()));
                }
            }
        }
        vo.setWtrList(roleList);
        return vo;
    }

    private List<SysWorkstationTemplateRole> compareOrganList(List<SysWorkstationTemplateRole> roleList, List<OrganVo> organList) {
        if (HussarUtils.isEmpty(organList)) {
            return new ArrayList<SysWorkstationTemplateRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationTemplateRole::getPermissionId, Function.identity()));
        Map organMap = organList.stream().collect(Collectors.toMap(OrganVo::getId, Function.identity()));
        for (Long next : roleMap.keySet()) {
            OrganVo organizationBo = (OrganVo)organMap.get(String.valueOf(next));
            if (HussarUtils.isNotEmpty((Object)organizationBo)) {
                ((SysWorkstationTemplateRole)roleMap.get(next)).setPermissionName(organizationBo.getLabel());
                continue;
            }
            roleMap.remove(next);
        }
        List<SysWorkstationTemplateRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationTemplateRole> compareRoleList(List<SysWorkstationTemplateRole> roleList, List<RoleVo> roleInfoByIds) {
        if (HussarUtils.isEmpty(roleInfoByIds)) {
            return new ArrayList<SysWorkstationTemplateRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationTemplateRole::getPermissionId, Function.identity()));
        Map roleInfoMap = roleInfoByIds.stream().collect(Collectors.toMap(RoleVo::getId, Function.identity()));
        for (Long next1 : roleMap.keySet()) {
            RoleVo roleVo = (RoleVo)roleInfoMap.get(next1);
            if (HussarUtils.isNotEmpty((Object)roleVo)) {
                ((SysWorkstationTemplateRole)roleMap.get(next1)).setPermissionName(roleVo.getRoleName());
                continue;
            }
            roleMap.remove(next1);
        }
        List<SysWorkstationTemplateRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationTemplateRole> comparePostList(List<SysWorkstationTemplateRole> roleList, List<PostBasicVo> postInfoByIds) {
        if (HussarUtils.isEmpty(postInfoByIds)) {
            return new ArrayList<SysWorkstationTemplateRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationTemplateRole::getPermissionId, Function.identity()));
        Map postMap = postInfoByIds.stream().collect(Collectors.toMap(PostBasicVo::getPostId, Function.identity()));
        for (Long next2 : roleMap.keySet()) {
            PostBasicVo postBasicVo = (PostBasicVo)postMap.get(next2);
            if (HussarUtils.isNotEmpty((Object)postBasicVo)) {
                ((SysWorkstationTemplateRole)roleMap.get(next2)).setPermissionName(postBasicVo.getPostName());
                continue;
            }
            roleMap.remove(next2);
        }
        List<SysWorkstationTemplateRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationTemplateRole> comparePersonList(List<SysWorkstationTemplateRole> roleList, Map<Long, SysUsers> map) {
        if (HussarUtils.isEmpty(map)) {
            return new ArrayList<SysWorkstationTemplateRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationTemplateRole::getPermissionId, Function.identity()));
        for (Long next3 : roleMap.keySet()) {
            SysUsers sysUsers = map.get(next3);
            if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                ((SysWorkstationTemplateRole)roleMap.get(next3)).setPermissionName(sysUsers.getUserName());
                continue;
            }
            roleMap.remove(next3);
        }
        List<SysWorkstationTemplateRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    @HussarTransactional
    public SysWorkstationTemplateVo copyTemplateById(Long workstationTemplateId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray roleList = null;
        roleList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById(workstationTemplateId);
        TranslateUtil.translate((Object)sysWorkstationTemplate, SysWorkstationTemplate::getNameLangKey, SysWorkstationTemplate::setWorkstationTemplateName);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)workstationTemplateId);
        List layoutList = this.sysWorkstationTemLayoutMapper.selectList((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)workstationTemplateId);
        List rolesList = this.sysWorkstationTemplateRoleService.list((Wrapper)queryWrapper1);
        sysWorkstationTemplate.setId(null);
        sysWorkstationTemplate.setCreator(user.getUserId());
        sysWorkstationTemplate.setCreateTime(LocalDateTime.now());
        sysWorkstationTemplate.setLastEditor(user.getUserId());
        sysWorkstationTemplate.setLastTime(LocalDateTime.now());
        sysWorkstationTemplate.setSeq(this.sysWorkstationTemplateMapper.getMaxSeq() + 1);
        sysWorkstationTemplate.setWorkstationTemplateName(sysWorkstationTemplate.getWorkstationTemplateName() + TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_COPY.getMessage()));
        if (!(user.getAccount().equals("superadmin") || BaseSecurityUtil.isAdmin() || roleList.contains((Object)SysWorkstationConstant.TENANT_ADMIN_ROLE))) {
            sysWorkstationTemplate.setSeeRange("0");
            sysWorkstationTemplate.setTemplateType("0");
            this.save((BaseEntity)sysWorkstationTemplate);
            for (SysWorkstationTemLayout layout : layoutList) {
                layout.setId(null);
                layout.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemLayoutService.saveBatch((Collection)layoutList);
        } else {
            this.save((BaseEntity)sysWorkstationTemplate);
            for (SysWorkstationTemLayout layout : layoutList) {
                layout.setId(null);
                layout.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemLayoutService.saveBatch((Collection)layoutList);
            for (SysWorkstationTemplateRole roles : rolesList) {
                roles.setId(null);
                roles.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemplateRoleService.saveBatch((Collection)rolesList);
        }
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        return sysWorkstationTemplateVo;
    }

    @HussarTransactional
    public ApiResponse<String> deleteTemplateById(Long workstationTemplateId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemplate::getId, (Object)workstationTemplateId);
        int count = this.sysWorkstationTemplateMapper.delete((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemplateRoleMapper.delete((Wrapper)queryWrapper1);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemLayoutMapper.delete((Wrapper)queryWrapper2);
        LambdaQueryWrapper queryWrapper3 = Wrappers.lambdaQuery();
        queryWrapper3.eq(SysWorkstationTemplateUser::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemplateUserService.remove((Wrapper)queryWrapper3);
        if (count > 0) {
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DELETE_SUCCESS.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DELETE_FAILED.getMessage()));
    }

    public boolean checkHaveStartTempRole(Long workstationTemplateId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String account = user.getAccount();
        HashSet rolesList = new HashSet();
        JSONArray roles = JSON.parseArray((String)Optional.ofNullable(user.getExtendUserMap().get("rolesList")).map(Object::toString).orElse(""));
        roles.forEach(role -> rolesList.add(Long.parseLong(role.toString())));
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById(workstationTemplateId);
        if ("superadmin".equals(account) || BaseSecurityUtil.isAdmin() || rolesList.contains(SysWorkstationConstant.TENANT_ADMIN_ROLE) || "2".equals(sysWorkstationTemplate.getSeeRange()) || "0".equals(sysWorkstationTemplate.getSeeRange()) && "0".equals(sysWorkstationTemplate.getTemplateType())) {
            return true;
        }
        Long userId = user.getUserId();
        Long deptId = 1L;
        if (HussarUtils.isNotEmpty(user.getExtendUserMap().get("deptId"))) {
            deptId = Long.parseLong(user.getExtendUserMap().get("deptId").toString());
        }
        Long postId = 1L;
        if (HussarUtils.isNotEmpty(user.getExtendUserMap().get("postId"))) {
            postId = Long.parseLong(user.getExtendUserMap().get("postId").toString());
        }
        List roleList = this.sysWorkstationTemplateRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId()));
        for (SysWorkstationTemplateRole role2 : roleList) {
            String permissionType = role2.getPermissionTypes();
            Long permissionId = role2.getPermissionId();
            switch (permissionType) {
                case "0": {
                    if (!permissionId.equals(deptId)) break;
                    return true;
                }
                case "1": {
                    if (!rolesList.contains(permissionId)) break;
                    return true;
                }
                case "2": {
                    if (!permissionId.equals(postId)) break;
                    return true;
                }
                case "3": {
                    if (!permissionId.equals(userId)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void ordinaryPersonalTemplate(String applicationScenario, SysWorkstationUserAllTemplateVo sysWorkstationUserAllTemplateVo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"0")).eq(HussarBaseEntity::getCreator, (Object)BaseSecurityUtil.getUser().getUserId())).orderByAsc(SysWorkstationTemplate::getSeq);
        List personalTemplate = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)personalTemplate)) {
            TranslateUtil.translate((List)personalTemplate, SysWorkstationTemplate::getNameLangKey, SysWorkstationTemplate::setWorkstationTemplateName);
            sysWorkstationUserAllTemplateVo.setPersonalVoList(HussarUtils.copyProperties((Collection)personalTemplate, SysWorkstationSimpleTemplateVo.class));
        }
    }

    private void ordinaryCommonTemplate(String applicationScenario, SysWorkstationUserAllTemplateVo sysWorkstationUserAllTemplateVo) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        long deptId = 1L;
        if (HussarUtils.isNotEmpty(user.getExtendUserMap().get("deptId"))) {
            deptId = Long.parseLong(user.getExtendUserMap().get("deptId").toString());
        }
        long postId = 1L;
        if (HussarUtils.isNotEmpty(user.getExtendUserMap().get("postId"))) {
            postId = Long.parseLong(user.getExtendUserMap().get("postId").toString());
        }
        JSONArray rolesList = JSON.parseArray((String)Optional.ofNullable(user.getExtendUserMap().get("rolesList")).map(Object::toString).orElse(""));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"1")).eq(SysWorkstationTemplate::getSeeRange, (Object)"2");
        List templateAllList = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        TranslateUtil.translate((List)templateAllList, SysWorkstationTemplate::getWorkstationTemplateName, SysWorkstationTemplate::setWorkstationTemplateName);
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getPermissionId, (Object)userId)).or()).eq(SysWorkstationTemplateRole::getPermissionId, (Object)deptId)).or()).in(null != rolesList, SysWorkstationTemplateRole::getPermissionId, (Collection)rolesList)).or()).eq(SysWorkstationTemplateRole::getPermissionId, (Object)postId);
        Set templateIds = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toSet());
        if (HussarUtils.isNotEmpty(templateIds)) {
            List templateRangeList = this.sysWorkstationTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).in(SysWorkstationTemplate::getId, templateIds));
            TranslateUtil.translate((List)templateRangeList, SysWorkstationTemplate::getWorkstationTemplateName, SysWorkstationTemplate::setWorkstationTemplateName);
            templateAllList.addAll(templateRangeList);
        }
        if (HussarUtils.isNotEmpty((Object)templateAllList)) {
            List sysWorkstationTemplates = templateAllList.stream().sorted(Comparator.comparing(SysWorkstationTemplate::getSeq)).collect(Collectors.toList());
            sysWorkstationUserAllTemplateVo.setCommonVoList(HussarUtils.copyProperties(sysWorkstationTemplates, SysWorkstationSimpleTemplateVo.class));
        }
    }

    private void adminPersonalTemplate(String applicationScenario, SysWorkstationUserAllTemplateVo sysWorkstationUserAllTemplateVo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(HussarBaseEntity::getCreator, (Object)BaseSecurityUtil.getUser().getUserId())).eq(SysWorkstationTemplate::getTemplateType, (Object)"0")).orderByAsc(SysWorkstationTemplate::getSeq);
        List personalTemplate = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)personalTemplate)) {
            TranslateUtil.translate((List)personalTemplate, SysWorkstationTemplate::getNameLangKey, SysWorkstationTemplate::setWorkstationTemplateName);
            List personalSimpleTemplateVos = HussarUtils.copyProperties((Collection)personalTemplate, SysWorkstationSimpleTemplateVo.class);
            sysWorkstationUserAllTemplateVo.setPersonalVoList(personalSimpleTemplateVos);
        }
    }

    private void adminCommonTemplate(String applicationScenario, SysWorkstationUserAllTemplateVo sysWorkstationUserAllTemplateVo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"1")).orderByAsc(SysWorkstationTemplate::getSeq);
        List commonTemplate = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonTemplate)) {
            TranslateUtil.translate((List)commonTemplate, SysWorkstationTemplate::getWorkstationTemplateName, SysWorkstationTemplate::setWorkstationTemplateName);
            List commonSimpleTemplateVos = HussarUtils.copyProperties((Collection)commonTemplate, SysWorkstationSimpleTemplateVo.class);
            sysWorkstationUserAllTemplateVo.setCommonVoList(commonSimpleTemplateVos);
        }
    }
}

