/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationAssemblyGroupMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysWorkstationAssemblyGroupDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssembly;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssemblyGroup;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyGroupService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyService;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationAssemblyGroupService")
public class SysWorkstationAssemblyGroupService
extends HussarServiceImpl<SysWorkstationAssemblyGroupMapper, SysWorkstationAssemblyGroup>
implements ISysWorkstationAssemblyGroupService {
    @Autowired
    private ISysWorkstationAssemblyService sysWorkstationAssemblyService;

    public ApiResponse insertOrUpdate(SysWorkstationAssemblyGroupDto sysWorkstationAssemblyGroupDto) {
        if (null == sysWorkstationAssemblyGroupDto.getId()) {
            sysWorkstationAssemblyGroupDto.setCreator(BaseSecurityUtil.getUser().getId());
            sysWorkstationAssemblyGroupDto.setCreateTime(LocalDateTime.now());
            sysWorkstationAssemblyGroupDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysWorkstationAssemblyGroupDto.setLastTime(LocalDateTime.now());
        } else {
            sysWorkstationAssemblyGroupDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysWorkstationAssemblyGroupDto.setLastTime(LocalDateTime.now());
        }
        this.saveOrUpdate((BaseEntity)sysWorkstationAssemblyGroupDto);
        return ApiResponse.success((Object)sysWorkstationAssemblyGroupDto);
    }

    public List<SysWorkstationAssemblyGroup> listAssemblyGroupByType(String applicationScenario) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationAssemblyGroup::getApplicationScenario, (Object)applicationScenario);
        List groupList = this.list((Wrapper)queryWrapper);
        return groupList;
    }

    @HussarTransactional
    public ApiResponse<String> deleteGroupById(Long groupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationAssembly::getGroupId, (Object)groupId);
        int size = this.sysWorkstationAssemblyService.list((Wrapper)queryWrapper).size();
        if (size == 0) {
            this.removeById(groupId);
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DELETE_GROUP_NOT_EMPTY.getMessage()));
    }
}

