/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.constant.SysWorkstationConstant;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateUserMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysWorkstationTemplateUserDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplate;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplateUser;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateBoService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateUserService;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateUserVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateVo;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationTemplateUserServiceImpl")
public class SysWorkstationTemplateUserServiceImpl
extends HussarServiceImpl<SysWorkstationTemplateUserMapper, SysWorkstationTemplateUser>
implements ISysWorkstationTemplateUserService {
    @Resource
    private SysWorkstationTemplateUserMapper sysWorkstationTemplateUserMapper;
    @Autowired
    private ISysWorkstationTemplateService sysWorkstationTemplateService;
    @Autowired
    private ISysWorkstationTemplateUserService sysWorkstationTemplateUserService;
    @Autowired
    private ISysWorkstationTemplateBoService sysWorkstationTemplateBoService;

    @HussarTransactional
    public SysWorkstationTemplateUserVo insertOrUpdate(SysWorkstationTemplateUserDto sysWorkstationTemplateUserDto) {
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateService.getById((Serializable)sysWorkstationTemplateUserDto.getWorkstationTemplateId());
        if (HussarUtils.isEmpty((Object)sysWorkstationTemplate)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_TEMPLATE_DELETED.getMessage()));
        }
        SysWorkstationTemplateUser sysWorkstationTemplateUser1 = new SysWorkstationTemplateUser();
        HussarUtils.copy((Object)sysWorkstationTemplateUserDto, (Object)sysWorkstationTemplateUser1);
        SecurityUser user = BaseSecurityUtil.getUser();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        rolesList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (!(user.getAccount().equals("superadmin") || BaseSecurityUtil.isAdmin() || rolesList.contains((Object)SysWorkstationConstant.TENANT_ADMIN_ROLE))) {
            Object dept = user.getExtendUserMap().get("deptId");
            String deptId = "";
            if (HussarUtils.isNotEmpty(dept)) {
                deptId = dept.toString();
            }
            Object post = user.getExtendUserMap().get("postId");
            String postId = "";
            if (HussarUtils.isNotEmpty(post)) {
                postId = post.toString();
            }
            String identity = deptId + postId;
            sysWorkstationTemplateUser1.setIdentityInfo(Strings.emptyToNull((String)identity));
            if (HussarUtils.isNotEmpty((Object)identity)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplateUser::getUserId, (Object)user.getId())).eq(SysWorkstationTemplateUser::getIdentityInfo, (Object)identity)).eq(SysWorkstationTemplateUser::getApplicationScenario, (Object)sysWorkstationTemplate.getApplicationScenario());
            } else {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplateUser::getUserId, (Object)user.getId())).eq(SysWorkstationTemplateUser::getApplicationScenario, (Object)sysWorkstationTemplate.getApplicationScenario())).isNull(SysWorkstationTemplateUser::getIdentityInfo);
            }
        } else {
            ((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplateUser::getUserId, (Object)user.getId())).eq(SysWorkstationTemplateUser::getApplicationScenario, (Object)sysWorkstationTemplate.getApplicationScenario());
        }
        sysWorkstationTemplateUser1.setUserId(user.getId());
        this.sysWorkstationTemplateUserMapper.delete((Wrapper)queryWrapper);
        this.sysWorkstationTemplateUserMapper.insert(sysWorkstationTemplateUser1);
        return (SysWorkstationTemplateUserVo)HussarUtils.copyProperties((Object)sysWorkstationTemplateUser1, SysWorkstationTemplateUserVo.class);
    }

    public SysWorkstationTemplateVo loadStartUseTemplateByIdentity(String applicationScenario) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SysWorkstationTemplateUser templateUser = this.getStartUserTemplate(applicationScenario);
        Long workstationTemplateId = this.getDefaultTemplateId(applicationScenario);
        if (HussarUtils.isNotEmpty((Object)templateUser)) {
            boolean isHaveStartTempRole = this.sysWorkstationTemplateService.checkHaveStartTempRole(templateUser.getWorkstationTemplateId());
            if (!isHaveStartTempRole) {
                this.sysWorkstationTemplateUserService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysWorkstationTemplateUser::getWorkstationTemplateId, (Object)templateUser.getWorkstationTemplateId())).eq(SysWorkstationTemplateUser::getUserId, (Object)user.getId()));
            } else {
                workstationTemplateId = templateUser.getWorkstationTemplateId();
            }
        }
        return this.sysWorkstationTemplateService.getTemplateById(workstationTemplateId);
    }

    public SysWorkstationTemplateUser getStartUserTemplate(String applicationScenario) {
        SecurityUser user = BaseSecurityUtil.getUser();
        JSONArray rolesList = JSON.parseArray((String)Optional.ofNullable(user.getExtendUserMap().get("rolesList")).map(Object::toString).orElse(""));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplateUser::getUserId, (Object)user.getId())).eq(SysWorkstationTemplateUser::getApplicationScenario, (Object)applicationScenario);
        if (!(user.getAccount().equals("superadmin") || BaseSecurityUtil.isAdmin() || rolesList.contains((Object)SysWorkstationConstant.TENANT_ADMIN_ROLE))) {
            String deptId = Optional.ofNullable(user.getExtendUserMap().get("deptId")).map(Object::toString).orElse("");
            String postId = Optional.ofNullable(user.getExtendUserMap().get("postId")).map(Object::toString).orElse("");
            String identity = deptId + postId;
            if (HussarUtils.isNotEmpty((Object)identity)) {
                queryWrapper.eq(SysWorkstationTemplateUser::getIdentityInfo, (Object)identity);
            } else {
                queryWrapper.isNull(SysWorkstationTemplateUser::getIdentityInfo);
            }
        }
        return (SysWorkstationTemplateUser)this.sysWorkstationTemplateUserService.getOne((Wrapper)queryWrapper);
    }

    public Long getDefaultTemplateId(String applicationScenario) {
        Long extraTemplateId = this.sysWorkstationTemplateBoService.getExtraTemplateId(applicationScenario);
        if (HussarUtils.isNotEmpty((Object)extraTemplateId)) {
            return extraTemplateId;
        }
        if ("1".equals(applicationScenario)) {
            return SysWorkstationConstant.DEFAULT_MOBILE_TEMPLATE_ID;
        }
        return SysWorkstationConstant.DEFAULT_WEB_TEMPLATE_ID;
    }
}

