/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workstation.config.dao.SysShortcutMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysShortcutDto;
import com.jxdinfo.hussar.workstation.config.model.SysShortcut;
import com.jxdinfo.hussar.workstation.config.service.ISysShortcutService;
import com.jxdinfo.hussar.workstation.config.utils.AdvertisementUtils;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@HussarTransactional
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysShortcutServiceImpl")
public class SysShortcutServiceImpl
extends HussarServiceImpl<SysShortcutMapper, SysShortcut>
implements ISysShortcutService {
    @Resource
    private SysShortcutMapper sysShortcutMapper;

    public ApiResponse<IPage<SysShortcut>> listSysShortcuts(SysShortcutDto dto) {
        if (dto.getCurrent() == 0L || dto.getSize() == 0L) {
            throw new HussarException("\u5206\u9875\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysShortcut::getShortcutStatus, (Object)"0");
        wrapper.isNotNull(SysShortcut::getShortcutDueTime);
        List needUpdateDataList = this.list((Wrapper)wrapper);
        int i = 0;
        for (SysShortcut sysShortcut : needUpdateDataList) {
            if (sysShortcut.getShortcutDueTime().compareTo(LocalDateTime.now()) > 0) continue;
            sysShortcut.setShortcutStatus("1");
            ++i;
        }
        if (i > 0) {
            this.updateBatchById(needUpdateDataList);
        }
        dto.setCreateEndTime(AdvertisementUtils.dealLe(dto.getCreateEndTime()));
        dto.setAdDueEndTime(AdvertisementUtils.dealLe(dto.getAdDueEndTime()));
        Page page = new Page(dto.getCurrent(), dto.getSize());
        dto.setShortcutTitle(dto.getShortcutTitle().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        IPage<SysShortcut> sysShortcutDtoIPage = this.sysShortcutMapper.listSysShortcutsWithPage(page, dto);
        return ApiResponse.success(sysShortcutDtoIPage);
    }

    public ApiResponse<?> insertOrUpdate(SysShortcutDto dto) {
        this.checkField(dto);
        if (null == dto.getId()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(SysShortcut::getShortcutSort);
            List sysShortcutList = this.list((Wrapper)wrapper);
            int maxAdSort = 0;
            if (sysShortcutList.size() > 0) {
                maxAdSort = ((SysShortcut)sysShortcutList.get(0)).getShortcutSort();
            }
            dto.setShortcutSort(Integer.valueOf(maxAdSort + 1));
            dto.setCreator(BaseSecurityUtil.getUser().getId());
            dto.setCreateTime(LocalDateTime.now());
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        } else {
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        }
        this.saveOrUpdate((BaseEntity)dto);
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteSysShortcuts(SysShortcutDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u9700\u8981\u5220\u9664\u7684\u6570\u636eid\u4e3a\u7a7a");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        this.removeByIds(longList);
        return ApiResponse.success();
    }

    public ApiResponse<?> stopUseSysShortcuts(SysShortcutDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u6570\u636e\u9009\u62e9\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysShortcut::getId, longList);
        List sysToolbarAdvertisementList = this.list((Wrapper)wrapper);
        for (SysShortcut sysShortcut : sysToolbarAdvertisementList) {
            sysShortcut.setShortcutStatus("1");
        }
        this.updateBatchById(sysToolbarAdvertisementList);
        return ApiResponse.success();
    }

    public ApiResponse<?> startUseSysShortcuts(SysShortcutDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u6570\u636e\u9009\u62e9\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysShortcut::getId, longList);
        List sysToolbarAdvertisementList = this.list((Wrapper)wrapper);
        for (SysShortcut sysShortcut : sysToolbarAdvertisementList) {
            String checkResult = AdvertisementUtils.checkAdDueTime(sysShortcut.getShortcutDueTime());
            if ("1".equals(checkResult)) {
                throw new HussarException("\u9009\u62e9\u7684\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u5728\u4fee\u6539\u9875\u9762\u914d\u7f6e\u8fc7\u671f\u65f6\u95f4");
            }
            sysShortcut.setShortcutStatus("0");
        }
        this.updateBatchById(sysToolbarAdvertisementList);
        return ApiResponse.success();
    }

    public ApiResponse<?> moveAdvertisements(SysShortcutDto dto) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        Integer adSort = dto.getShortcutSort();
        if ("0".equals(dto.getMoveFlag())) {
            wrapper.gt(SysShortcut::getShortcutSort, (Object)adSort);
            wrapper.orderByAsc(SysShortcut::getShortcutSort);
        } else if ("1".equals(dto.getMoveFlag())) {
            wrapper.lt(SysShortcut::getShortcutSort, (Object)adSort);
            wrapper.orderByDesc(SysShortcut::getShortcutSort);
        }
        wrapper.eq(SysShortcut::getShortcutStatus, (Object)dto.getShortcutStatus());
        List sysShortcutList = this.sysShortcutMapper.selectList((Wrapper)wrapper);
        if (sysShortcutList.size() > 0) {
            SysShortcut sysShortcut = (SysShortcut)sysShortcutList.get(0);
            SysShortcut sysShortcutDto = (SysShortcut)this.getById(dto.getId());
            sysShortcutDto.setShortcutSort(sysShortcut.getShortcutSort());
            sysShortcut.setShortcutSort(adSort);
            this.updateById((BaseEntity)sysShortcut);
            this.updateById((BaseEntity)sysShortcutDto);
        } else {
            if ("0".equals(dto.getMoveFlag())) {
                return ApiResponse.fail((String)"\u8be5\u6761\u6570\u636e\u5df2\u662f\u7b2c\u4e00\u6761\uff0c\u4e0d\u80fd\u4e0a\u79fb");
            }
            if ("1".equals(dto.getMoveFlag())) {
                return ApiResponse.fail((String)"\u8be5\u6761\u6570\u636e\u5df2\u662f\u6700\u540e\u4e00\u6761\uff0c\u4e0d\u80fd\u4e0b\u79fb");
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysShortcut>> listToolbarShortcuts() {
        List<SysShortcut> SysShortcutList = this.sysShortcutMapper.listSysShortcuts(LocalDateTime.now());
        return ApiResponse.success(SysShortcutList);
    }

    public ApiResponse<Boolean> getShortcutByAdTitle(SysShortcutDto dto) {
        SysShortcut sysShortcut;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysShortcut::getShortcutTitle, (Object)dto.getShortcutTitle());
        if (null != dto.getId()) {
            wrapper.ne(SysShortcut::getId, (Object)dto.getId());
        }
        if ((sysShortcut = (SysShortcut)this.getOne((Wrapper)wrapper, false)) != null) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public void checkField(SysShortcutDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getShortcutTitle())) {
            throw new HussarException("\u6807\u9898\u4e3a\u5fc5\u586b\u5b57\u6bb5");
        }
        if (HussarUtils.isBlank((CharSequence)dto.getShortcutOutside())) {
            throw new HussarException("\u662f\u5426\u5916\u94fe\u4e3a\u5fc5\u586b\u5b57\u6bb5");
        }
        if (HussarUtils.isNotBlank((CharSequence)dto.getShortcutLink())) {
            String url_agreement = dto.getShortcutLink().split(":")[0];
            if (!"http".equalsIgnoreCase(url_agreement) && !"https".equalsIgnoreCase(url_agreement)) {
                throw new HussarException("\u8d85\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        } else {
            throw new HussarException("\u8d85\u94fe\u63a5\u4e3a\u5fc5\u586b\u5b57\u6bb5");
        }
        if (null == dto.getShortcutPicture()) {
            throw new HussarException("\u56fe\u7247\u4e0a\u4f20\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
    }
}

