/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workstation.application.dao.SysAppCommonWorkMapper;
import com.jxdinfo.hussar.workstation.application.model.SysAppCommon;
import com.jxdinfo.hussar.workstation.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import com.jxdinfo.hussar.workstation.application.vo.SysAppCommonVo;
import com.jxdinfo.hussar.workstation.application.vo.SysApplicationVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.application.service.impl.SysAppCommonServiceImpl")
public class SysAppCommonServiceImpl
extends HussarServiceImpl<SysAppCommonWorkMapper, SysAppCommon>
implements ISysAppCommonService {
    @Resource
    private SysAppCommonWorkMapper sysAppCommonWorkMapper;
    @Resource
    private ISysAppVisitAuthorizeService sysAppAuthorizeService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;

    @HussarTransactional
    public ApiResponse<Boolean> addCommonApp(List<SysAppCommon> appCommonList, String platform) {
        if (appCommonList.size() > 12) {
            return ApiResponse.fail((String)"\u5e38\u7528\u5e94\u7528\u4e0d\u53ef\u8d85\u8fc712\u4e2a");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        wrapper.eq(SysAppCommon::getUserId, (Object)userId);
        wrapper.eq(SysAppCommon::getPlatform, (Object)platform);
        this.remove((Wrapper)wrapper);
        for (int i = 0; i < appCommonList.size(); ++i) {
            appCommonList.get(i).setUserId(userId);
            appCommonList.get(i).setSEQ(i);
        }
        this.saveBatch(appCommonList);
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    public List<SysAppCommonVo> getCommonAppList(String platform) {
        List currentUserAuthorityApp = this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty((Object)currentUserAuthorityApp)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<SysAppCommonVo> allAppCommon = this.sysAppCommonWorkMapper.getCommonAppList(platform, BaseSecurityUtil.getUser().getUserId());
        if (HussarUtils.isEmpty(allAppCommon)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList appCommonAuthority = Lists.newArrayListWithCapacity((int)allAppCommon.size());
        for (SysAppCommonVo c : allAppCommon) {
            if (!currentUserAuthorityApp.contains(c.getAppId())) continue;
            appCommonAuthority.add(c);
        }
        if (HussarUtils.isNotEmpty((Object)appCommonAuthority)) {
            TranslateUtil.translateByJson((List)appCommonAuthority, SysAppCommonVo::getAppNameKey);
            TranslateUtil.translateByJson((List)appCommonAuthority, SysAppCommonVo::getGroupNameKey);
        }
        return appCommonAuthority;
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysAppCommonWorkMapper.getAppDetail(appId);
        ClientVo appClientSecret = this.sysApplicationBoService.getAppClientSecret(appId);
        if (HussarUtils.isNotEmpty((Object)appClientSecret)) {
            sysApplicationVo.setClientId(appClientSecret.getClientId());
            sysApplicationVo.setClientSecret(appClientSecret.getClientSecret());
        }
        ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
        sysApplicationVoList.add(sysApplicationVo);
        this.setUserInfo(sysApplicationVoList);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    private void setUserInfo(List<SysApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            List userIdList = appList.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
            Map userMap = this.userBoService.getUserInfo(userIdList);
            for (SysApplicationVo item : appList) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setCreateUserName(sysUsers.getUserName());
            }
        }
    }
}

