/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.application.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workstation.application.dao.SysAppCommonWorkMapper;
import com.jxdinfo.hussar.workstation.application.model.SysAppCommon;
import com.jxdinfo.hussar.workstation.application.service.ISysAppCommonBoService;
import com.jxdinfo.hussar.workstation.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import com.jxdinfo.hussar.workstation.application.vo.SysAppCommonVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.service.impl.sysAppCommonBoServiceImpl")
public class SysAppCommonBoServiceImpl
implements ISysAppCommonBoService {
    @Resource
    private ISysAppVisitAuthorizeService sysAppAuthorizeService;
    @Resource
    private SysAppCommonWorkMapper sysAppCommonWorkMapper;
    @Resource
    private ISysAppCommonService sysAppCommonService;

    public List<SysAppCommonVo> getCommonAppList(String platform, Long userId) {
        List currentUserAuthorityApp = this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty((Object)currentUserAuthorityApp)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<SysAppCommonVo> allAppCommon = this.sysAppCommonWorkMapper.getCommonAppList(platform, userId);
        if (HussarUtils.isEmpty(allAppCommon)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList appCommonAuthority = Lists.newArrayListWithCapacity((int)allAppCommon.size());
        for (SysAppCommonVo c : allAppCommon) {
            if (!currentUserAuthorityApp.contains(c.getAppId())) continue;
            appCommonAuthority.add(c);
        }
        return appCommonAuthority;
    }

    public ApiResponse<Boolean> addCommonApp(List<SysAppCommon> appCommonList, String platform) {
        return this.sysAppCommonService.addCommonApp(appCommonList, platform);
    }
}

