/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workstation.application.dao.SysAppVisitAuthorizeMapper;
import com.jxdinfo.hussar.workstation.application.dao.SysWorkstationAppMapper;
import com.jxdinfo.hussar.workstation.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.workstation.application.model.SysAppVisitAuthorize;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.workstation.application.service.impl.sysAppVisitAuthorizeServiceImpl")
public class SysAppVisitAuthorizeServiceImpl
extends HussarServiceImpl<SysAppVisitAuthorizeMapper, SysAppVisitAuthorize>
implements ISysAppVisitAuthorizeService {
    @Resource
    private SysAppVisitAuthorizeMapper appAuthorizeMapper;
    @Autowired
    private ISysAppGroupService sysAppGroupService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Autowired
    private SysWorkstationAppMapper sysWorkstationAppMapper;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;

    @HussarTransactional
    public Boolean addAuthorize(SysAppVisitAuthorizeDto appAuthorizeDto) {
        List roleIds = appAuthorizeDto.getRoleIds();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysAppVisitAuthorize::getAppId, (Object)appAuthorizeDto.getAppId());
        this.remove((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)roleIds)) {
            return true;
        }
        ArrayList appAuthorizeList = Lists.newArrayListWithCapacity((int)10);
        for (Long roleId : roleIds) {
            SysAppVisitAuthorize appAuthorizeT = new SysAppVisitAuthorize();
            appAuthorizeT.setAppId(appAuthorizeDto.getAppId());
            appAuthorizeT.setRoleId(roleId);
            appAuthorizeList.add(appAuthorizeT);
        }
        this.sysAppOperationLogService.saveAppOperation(appAuthorizeDto.getAppId(), "2");
        return this.saveBatch(appAuthorizeList);
    }

    public ApiResponse<List<RoleVo>> getAppRoleList(Long appId) {
        List authorizes = this.appAuthorizeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitAuthorize::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)authorizes)) {
            return ApiResponse.success(new ArrayList(), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        List roleIds = authorizes.stream().map(SysAppVisitAuthorize::getRoleId).collect(Collectors.toList());
        List roleVos = this.sysRolesExternalService.getRoleInfoByIds(roleIds);
        return ApiResponse.success((Object)roleVos);
    }

    public List<Long> getCurrentUserAuthorityApp() {
        Object orgId;
        SecurityUser user = BaseSecurityUtil.getUser();
        Map extendUserMap = user.getExtendUserMap();
        List rolesList = user.getRolesList();
        ArrayList<Long> queryList = new ArrayList<Long>(rolesList);
        Long userId = user.getUserId();
        queryList.add(userId);
        Object postId = extendUserMap.get("postId");
        if (HussarUtils.isNotEmpty(postId)) {
            queryList.add(Long.valueOf(postId.toString()));
        }
        if (HussarUtils.isNotEmpty(orgId = extendUserMap.get("deptId"))) {
            queryList.add(Long.valueOf(orgId.toString()));
        }
        if (HussarUtils.isEmpty(queryList)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysAppVisitAuthorize::getRoleId, queryList);
        ((LambdaQueryWrapper)queryWrapper.or()).eq(SysAppVisitAuthorize::getAuthorizationType, (Object)"5");
        List authorizeList = this.list((Wrapper)queryWrapper);
        Set appIdSet = authorizeList.stream().map(SysAppVisitAuthorize::getAppId).collect(Collectors.toSet());
        return new ArrayList<Long>(appIdSet);
    }

    public List<SysAppGroupVo> getAppList(String appName, String platform, List<String> appType) {
        List<Object> workstationIds;
        List<Long> appIds = this.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        HashMap<String, Object> appMap = new HashMap<String, Object>();
        appMap.put("appIds", appIds);
        appMap.put("appTypes", appType);
        appMap.put("appName", SqlQueryUtil.transferSpecialChar((String)appName));
        List<SysApplication> appList = this.sysWorkstationAppMapper.getAppList(appMap);
        if (HussarUtils.isNotEmpty(appList)) {
            TranslateUtil.translateByJson(appList, SysApplication::getI18nKeys);
        }
        List groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appList) && HussarUtils.isNotEmpty((Object)platform) && !"3".equals(platform)) {
            List<Long> appIdLists = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
            workstationIds = this.sysWorkstationAppMapper.selectWorkstationAppIds(appIdLists, platform);
        } else {
            workstationIds = new ArrayList();
        }
        if (HussarUtils.isNotEmpty(appList)) {
            appList.removeIf(sysApplication -> workstationIds.contains(sysApplication.getId()));
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, groupIds)).orderByAsc(SysAppGroup::getSEQ));
        }
        if (HussarUtils.isNotEmpty(sysAppGroups)) {
            TranslateUtil.translateByJson(sysAppGroups, SysAppGroup::getI18nKeys);
        }
        ArrayList<SysApplicationVo> appListVo = new ArrayList<SysApplicationVo>();
        for (SysApplication app : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appListVo.add(vo);
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }
}

