/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.application.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workstation.application.sdk.enums.SdkUrlEnum;
import com.jxdinfo.hussar.workstation.application.sdk.properties.WorkstationSdkProperties;
import com.jxdinfo.hussar.workstation.application.sdk.service.SdkTokenService;
import com.jxdinfo.hussar.workstation.application.sdk.utils.HttpClientUtil;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(SdkHttpUtils.class);
    private static WorkstationSdkProperties properties;
    private static SdkTokenService tokenService;
    private static TypeFactory typeFactory;

    public static <T> T postHttp(SdkUrlEnum urlEnum, Object request, Class<T> responseClass) {
        JavaType javaType = typeFactory.constructParametricType(ApiResponse.class, new Class[]{responseClass});
        ApiResponse apiResponse = SdkHttpUtils.doPostRequest(request, urlEnum, javaType);
        return (T)apiResponse.getData();
    }

    public static <T> T postHttp(SdkUrlEnum urlEnum, Object request, TypeReference<T> typeReference) {
        JavaType javaType = typeFactory.constructParametricType(ApiResponse.class, new JavaType[]{typeFactory.constructType(typeReference.getType())});
        ApiResponse apiResponse = SdkHttpUtils.doPostRequest(request, urlEnum, javaType);
        return (T)apiResponse.getData();
    }

    private static ApiResponse doPostRequest(Object request, SdkUrlEnum urlEnum, JavaType javaType) {
        ApiResponse apiResponse;
        String result;
        String token = SdkHttpUtils.getToken();
        String httpUrl = SdkHttpUtils.properties().getWorkstationServer() + urlEnum.getUrl();
        if (SdkHttpUtils.properties().isOpenLog()) {
            logger.info("workstation sdk http\u8bf7\u6c42\u63a5\u53e3\u540d:{}, url:{}, \u5165\u53c2\u4e3a:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), JsonUtil.toJson((Object)request)});
        }
        try {
            Response response = HttpClientUtil.getClient().newCall(SdkHttpUtils.postRequest(request, httpUrl, token)).execute();
            if (!response.isSuccessful()) {
                logger.error("workstation sdk\u63a5\u53e3http\u8bf7\u6c42\u5931\u8d25, \u63a5\u53e3\u540d:{}, url:{}, message:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), response.message()});
                throw new HussarException("workstation sdk\u63a5\u53e3http\u8bf7\u6c42\u5931\u8d25");
            }
            result = response.body().string();
        }
        catch (Exception e) {
            logger.error("workstation sdk\u63a5\u53e3http\u8bf7\u6c42\u5f02\u5e38, \u63a5\u53e3\u540d:{}, url:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), e});
            throw new HussarException("workstation sdk\u63a5\u53e3http\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        if (SdkHttpUtils.properties().isOpenLog()) {
            logger.info("workstation sdk\u63a5\u53e3http\u8bf7\u6c42\u6210\u529f\uff0c\u63a5\u53e3\u540d:{}, url:{}, \u8fd4\u56de\u503c\u4e3a:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), result});
        }
        try {
            apiResponse = (ApiResponse)JsonUtil.getInstance().readValue(result, javaType);
        }
        catch (Exception e) {
            logger.error(JSON.toJSONString((Object)result));
            throw new HussarException("\u8fd4\u56de\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
        }
        if (!apiResponse.isSuccess()) {
            logger.error("workstation sdk\u8bf7\u6c42\u5185\u90e8\u5904\u7406\u5931\u8d25, \u63a5\u53e3\u540d:{}, url:{}, message:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), apiResponse.getMsg()});
            throw new HussarException("\u7edf\u4e00\u6743\u9650sdk\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        return apiResponse;
    }

    private static Request postRequest(Object request, String url, String token) {
        RequestBody body;
        if (request == null) {
            body = RequestBody.create(null, (String)"");
        } else if (request instanceof String) {
            body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)(HussarUtils.isEmpty((Object)request) ? "" : request.toString()));
        } else {
            String paramJson = JsonUtil.toJson((Object)request);
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)paramJson);
        }
        return new Request.Builder().url(url).addHeader("Authorization", token).addHeader("Client-Id", SdkHttpUtils.properties().getClientId()).post(body).build();
    }

    private static String getToken() {
        String token = (String)HussarCacheUtil.get((String)"workstation_app_token", (Object)SdkHttpUtils.properties().getClientId());
        if (HussarUtils.isEmpty((Object)token) && HussarUtils.isEmpty((Object)(token = SdkHttpUtils.tokenService().getToken()))) {
            throw new HussarException("\u83b7\u53d6token\u5931\u8d25");
        }
        return token;
    }

    public static WorkstationSdkProperties properties() {
        if (properties == null) {
            properties = (WorkstationSdkProperties)SpringContextUtil.getBean(WorkstationSdkProperties.class);
        }
        return properties;
    }

    public static SdkTokenService tokenService() {
        if (tokenService == null) {
            tokenService = (SdkTokenService)SpringContextUtil.getBean(SdkTokenService.class);
        }
        return tokenService;
    }

    static {
        typeFactory = TypeFactory.defaultInstance();
    }
}

