/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.application.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workstation.application.sdk.enums.SdkUrlEnum;
import com.jxdinfo.hussar.workstation.application.sdk.properties.WorkstationSdkProperties;
import com.jxdinfo.hussar.workstation.application.sdk.utils.HttpClientUtil;
import java.util.Map;
import javax.annotation.Resource;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.workstation.application.sdk.service.sdkTokenService")
public class SdkTokenService {
    @Resource
    private WorkstationSdkProperties properties;

    public String getToken() {
        try {
            String getTokenUrl = this.properties.getWorkstationServer() + SdkUrlEnum.GET_TOKEN.getUrl();
            Request request = new Request.Builder().url(getTokenUrl).addHeader("Client-Id", this.properties.getClientId()).addHeader("client-secret", this.properties.getClientSecret()).build();
            Response response = HttpClientUtil.getClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HussarException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u8bf7\u6c42\u5931\u8d25:" + response.message());
            }
            String resultStr = response.body().string();
            ApiResponse tokenResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<Map<String, Object>>>(){});
            if (tokenResponse == null || !tokenResponse.isSuccess()) {
                throw new HussarException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u5931\u8d25:" + resultStr);
            }
            Map tokenMap = (Map)tokenResponse.getData();
            String token = (String)tokenMap.get("client-token");
            Long expiresIn = Long.parseLong(tokenMap.get("expires-in").toString());
            long thisExpiresIn = expiresIn - this.properties.getRefreshTokenTime() * 60L;
            if (thisExpiresIn > 0L) {
                HussarCacheUtil.put((String)"workstation_app_token", (Object)this.properties.getClientId(), (Object)token, (long)(expiresIn - this.properties.getRefreshTokenTime() * 60L));
            }
            return token;
        }
        catch (Exception e) {
            throw new HussarException("\u8c03\u7528sdk\u63a5\u53e3\u65f6\uff0c\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
        }
    }
}

