/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.task.datasync.service.impl;

import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.task.datasync.config.SnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.task.datasync.dao.BusinessMapper;
import com.jxdinfo.hussar.workflow.task.datasync.dao.ProcessTaskMapper;
import com.jxdinfo.hussar.workflow.task.datasync.dto.TaskDataSyncDto;
import com.jxdinfo.hussar.workflow.task.datasync.service.ITaskDataSyncService;
import com.jxdinfo.hussar.workflow.task.datasync.vo.UserInfoVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskDataSyncServiceImpl
implements ITaskDataSyncService {
    @Resource
    private BusinessMapper businessMapper;
    @Resource
    private ProcessTaskMapper processTaskMapper;
    @Autowired
    private SnowflakeIDGenerator snowflakeIDGenerator;
    private DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getApplicationContext().getBean(DruidProperties.class);
    private String dbUrl = this.druidProperties.getUrl();
    private static Logger logger = LoggerFactory.getLogger(TaskDataSyncServiceImpl.class);
    private static Map<String, String> stateType = new HashMap<String, String>();

    @HussarDs(value="#nocodeBusinessDB")
    public Integer addTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            Long taskId = taskDataSyncDto.getTaskId();
            List userInfoList = taskDataSyncDto.getUserInfoList();
            Integer num = 0;
            if (HussarUtils.isNotEmpty((Object)userInfoList)) {
                ArrayList<TaskDataSyncDto> taskDataSyncDtoList = new ArrayList<TaskDataSyncDto>();
                for (UserInfoVo userInfoVo : userInfoList) {
                    String nextId = this.snowflakeIDGenerator.getNextId();
                    Long taskInfoId = Long.valueOf(nextId);
                    TaskDataSyncDto taskDataSyncDtoTemp = new TaskDataSyncDto();
                    taskDataSyncDtoTemp.setTaskInfoId(taskInfoId);
                    taskDataSyncDtoTemp.setBusinessId(taskDataSyncDto.getBusinessId());
                    taskDataSyncDtoTemp.setTaskId(taskId);
                    taskDataSyncDtoTemp.setUserId(userInfoVo.getUserId());
                    taskDataSyncDtoTemp.setTaskDefinitionKey(taskDataSyncDto.getTaskDefinitionKey());
                    taskDataSyncDtoTemp.setTaskDefinitionName(taskDataSyncDto.getTaskDefinitionName());
                    taskDataSyncDtoTemp.setFormKey(taskDataSyncDto.getFormKey());
                    taskDataSyncDtoTemp.setFormDetailKey(taskDataSyncDto.getFormDetailKey());
                    taskDataSyncDtoTemp.setCreateTime(taskDataSyncDto.getCreateTime());
                    taskDataSyncDtoList.add(taskDataSyncDtoTemp);
                }
                if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
                    num = this.dbUrl.startsWith("jdbc:postgresql") ? this.processTaskMapper.insertProcessTask_postgres(processTaskTableName, taskDataSyncDtoList) : (this.dbUrl.startsWith("jdbc:oracle") ? this.processTaskMapper.insertProcessTask_oracle(processTaskTableName, taskDataSyncDtoList) : this.processTaskMapper.insertProcessTask(processTaskTableName, taskDataSyncDtoList));
                }
            }
            return num;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean completeTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            logger.info("processTaskTableName:{}", (Object)processTaskTableName);
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List taskIdList = taskDataSyncDto.getTaskIdList();
            for (Long taskId : taskIdList) {
                logger.info("taskId:{}", (Object)taskId);
                taskDataSyncDto.setTaskId(taskId);
                logger.info("\u6267\u884c\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u4e2d\u7684\u91cd\u590d\u6570\u636e");
                this.processTaskMapper.deleteDuplicateProcessTask(taskDataSyncDto);
                logger.info("\u6267\u884c\u529e\u7406\u4efb\u52a1\u65f6\u4fee\u6539\u6d41\u7a0b\u4efb\u52a1\u6570\u636e");
                if (this.dbUrl.startsWith("jdbc:postgresql")) {
                    this.processTaskMapper.updateProcessTask_postgres(taskDataSyncDto);
                    continue;
                }
                this.processTaskMapper.updateProcessTask(taskDataSyncDto);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Integer deleteTask(List<TaskDataSyncDto> taskDataSyncDtoList, String nocodeBusinessDB) {
        try {
            for (TaskDataSyncDto taskDataSyncDto : taskDataSyncDtoList) {
                String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
                if (!HussarUtils.isEmpty((Object)processTaskTableName)) continue;
                return null;
            }
            Integer num = 0;
            num = this.dbUrl.startsWith("jdbc:postgresql") ? this.processTaskMapper.deleteProcessTaskList_postgres(taskDataSyncDtoList) : this.processTaskMapper.deleteProcessTaskList(taskDataSyncDtoList);
            return num;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean entrustTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List consignorList = taskDataSyncDto.getConsignorList();
            if (HussarUtils.isNotEmpty((Object)consignorList)) {
                this.processTaskMapper.deleteProcessTaskByTaskAndAssignee(taskDataSyncDto);
            }
            this.addTask(taskDataSyncDto, nocodeBusinessDB);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean transferUserTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List consignorList = taskDataSyncDto.getConsignorList();
            if (HussarUtils.isNotEmpty((Object)consignorList)) {
                List<Long> tasksByConsignorList = this.processTaskMapper.getTasksByConsignorList(taskDataSyncDto);
                Long taskInfoId = null;
                if (HussarUtils.isNotEmpty(tasksByConsignorList)) {
                    taskInfoId = tasksByConsignorList.get(0);
                }
                this.processTaskMapper.deleteProcessTaskByTask(taskDataSyncDto.getProcessTaskTableName(), taskInfoId);
            }
            this.addTask(taskDataSyncDto, nocodeBusinessDB);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean rejectTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        return this.completeTask(taskDataSyncDto, nocodeBusinessDB);
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean revokeTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        return this.completeTask(taskDataSyncDto, nocodeBusinessDB);
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean freeJumpTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        return this.completeTask(taskDataSyncDto, nocodeBusinessDB);
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Integer addUser(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        return this.addTask(taskDataSyncDto, nocodeBusinessDB);
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Integer deleteMultiTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            Integer num = this.processTaskMapper.deleteProcessTaskByMultiTask(taskDataSyncDto);
            return num;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean transferTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            this.processTaskMapper.transferProcessTask(taskDataSyncDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean reTransferTask(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            this.processTaskMapper.transferProcessTask(taskDataSyncDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean endProcess(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            if (this.dbUrl.startsWith("jdbc:postgresql")) {
                this.processTaskMapper.deleteDuplicateProcessTaskByBusinessId_postgres(taskDataSyncDto);
                this.processTaskMapper.updateProcessTask_postgres(taskDataSyncDto);
            } else {
                this.processTaskMapper.deleteDuplicateProcessTaskByBusinessId(taskDataSyncDto);
                this.processTaskMapper.updateProcessTask(taskDataSyncDto);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean changeProcessState(List<TaskDataSyncDto> taskDataSyncDtoList, String nocodeBusinessDB) {
        if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
            for (TaskDataSyncDto taskDataSyncDto : taskDataSyncDtoList) {
                String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
                if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                    return null;
                }
                String processState = taskDataSyncDto.getProcessState();
                String state = stateType.get(processState);
                taskDataSyncDto.setState(state);
            }
        }
        try {
            if (this.dbUrl.startsWith("jdbc:postgresql")) {
                this.businessMapper.updateBusiness_postgres(taskDataSyncDtoList);
            } else {
                this.businessMapper.updateBusiness(taskDataSyncDtoList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @HussarDs(value="#nocodeBusinessDB")
    public Boolean changeProcessNode(TaskDataSyncDto taskDataSyncDto, String nocodeBusinessDB) {
        try {
            String businessTableName = taskDataSyncDto.getBusinessTableName();
            if (HussarUtils.isEmpty((Object)businessTableName)) {
                return null;
            }
            if (this.dbUrl.startsWith("jdbc:postgresql")) {
                this.businessMapper.updateProcessNode_postgres(taskDataSyncDto);
            } else {
                this.businessMapper.updateProcessNode(taskDataSyncDto);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        stateType.put("startProcess", "0");
        stateType.put("reStartProcess", "0");
        stateType.put("activateProcess", "0");
        stateType.put("completeProcess", "1");
        stateType.put("endProcess", "2");
        stateType.put("revokeProcess", "3");
        stateType.put("suspendProcess", "4");
        stateType.put("deleteProcess", "5");
    }
}

