/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.task.datasync.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.task.datasync.config.SnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.task.datasync.dao.BusinessMapper;
import com.jxdinfo.hussar.workflow.task.datasync.dao.ProcessTaskMapper;
import com.jxdinfo.hussar.workflow.task.datasync.dto.TaskDataSyncDto;
import com.jxdinfo.hussar.workflow.task.datasync.service.ITaskDataSyncService;
import com.jxdinfo.hussar.workflow.task.datasync.vo.UserInfoVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskDataSyncServiceImpl
implements ITaskDataSyncService {
    @Resource
    private BusinessMapper businessMapper;
    @Resource
    private ProcessTaskMapper processTaskMapper;
    @Autowired
    private SnowflakeIDGenerator snowflakeIDGenerator;
    private static Map<String, String> stateType = new HashMap<String, String>();

    public Integer addTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            Long taskId = taskDataSyncDto.getTaskId();
            List userInfoList = taskDataSyncDto.getUserInfoList();
            Integer num = 0;
            if (HussarUtils.isNotEmpty((Object)userInfoList)) {
                ArrayList<TaskDataSyncDto> taskDataSyncDtoList = new ArrayList<TaskDataSyncDto>();
                for (UserInfoVo userInfoVo : userInfoList) {
                    String nextId = this.snowflakeIDGenerator.getNextId();
                    Long taskInfoId = Long.valueOf(nextId);
                    TaskDataSyncDto taskDataSyncDtoTemp = new TaskDataSyncDto();
                    taskDataSyncDtoTemp.setTaskInfoId(taskInfoId);
                    taskDataSyncDtoTemp.setBusinessId(taskDataSyncDto.getBusinessId());
                    taskDataSyncDtoTemp.setTaskId(taskId);
                    taskDataSyncDtoTemp.setUserId(userInfoVo.getUserId());
                    taskDataSyncDtoTemp.setTaskDefinitionKey(taskDataSyncDto.getTaskDefinitionKey());
                    taskDataSyncDtoTemp.setTaskDefinitionName(taskDataSyncDto.getTaskDefinitionName());
                    taskDataSyncDtoTemp.setFormKey(taskDataSyncDto.getFormKey());
                    taskDataSyncDtoTemp.setFormDetailKey(taskDataSyncDto.getFormDetailKey());
                    taskDataSyncDtoTemp.setCreateTime(taskDataSyncDto.getCreateTime());
                    taskDataSyncDtoList.add(taskDataSyncDtoTemp);
                }
                if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
                    num = this.processTaskMapper.insertProcessTask(processTaskTableName, taskDataSyncDtoList);
                }
            }
            return num;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean completeTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List taskIdList = taskDataSyncDto.getTaskIdList();
            for (Long taskId : taskIdList) {
                taskDataSyncDto.setTaskId(taskId);
                this.processTaskMapper.deleteDuplicateProcessTask(taskDataSyncDto);
                this.processTaskMapper.updateProcessTask(taskDataSyncDto);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Integer deleteTask(List<TaskDataSyncDto> taskDataSyncDtoList) {
        try {
            for (TaskDataSyncDto taskDataSyncDto : taskDataSyncDtoList) {
                String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
                if (!HussarUtils.isEmpty((Object)processTaskTableName)) continue;
                return null;
            }
            Integer num = this.processTaskMapper.deleteProcessTaskList(taskDataSyncDtoList);
            return num;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean entrustTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List consignorList = taskDataSyncDto.getConsignorList();
            if (HussarUtils.isNotEmpty((Object)consignorList)) {
                this.processTaskMapper.deleteProcessTaskByTaskAndAssignee(taskDataSyncDto);
            }
            this.addTask(taskDataSyncDto);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean transferUserTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            List consignorList = taskDataSyncDto.getConsignorList();
            if (HussarUtils.isNotEmpty((Object)consignorList)) {
                List<Long> tasksByConsignorList = this.processTaskMapper.getTasksByConsignorList(taskDataSyncDto);
                Long taskInfoId = null;
                if (HussarUtils.isNotEmpty(tasksByConsignorList)) {
                    taskInfoId = tasksByConsignorList.get(0);
                }
                this.processTaskMapper.deleteProcessTaskByTask(taskDataSyncDto.getProcessTaskTableName(), taskInfoId);
            }
            this.addTask(taskDataSyncDto);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean rejectTask(TaskDataSyncDto taskDataSyncDto) {
        return this.completeTask(taskDataSyncDto);
    }

    public Boolean revokeTask(TaskDataSyncDto taskDataSyncDto) {
        return this.completeTask(taskDataSyncDto);
    }

    public Boolean freeJumpTask(TaskDataSyncDto taskDataSyncDto) {
        return this.completeTask(taskDataSyncDto);
    }

    public Integer addUser(TaskDataSyncDto taskDataSyncDto) {
        return this.addTask(taskDataSyncDto);
    }

    public Integer deleteMultiTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            Integer num = this.processTaskMapper.deleteProcessTaskByMultiTask(taskDataSyncDto);
            return num;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean transferTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            this.processTaskMapper.transferProcessTask(taskDataSyncDto);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Boolean reTransferTask(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            this.processTaskMapper.transferProcessTask(taskDataSyncDto);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Boolean endProcess(TaskDataSyncDto taskDataSyncDto) {
        try {
            String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
            if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                return null;
            }
            this.processTaskMapper.deleteDuplicateProcessTaskByBusinessId(taskDataSyncDto);
            this.processTaskMapper.updateProcessTask(taskDataSyncDto);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Boolean changeProcessState(List<TaskDataSyncDto> taskDataSyncDtoList) {
        if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
            for (TaskDataSyncDto taskDataSyncDto : taskDataSyncDtoList) {
                String processTaskTableName = taskDataSyncDto.getProcessTaskTableName();
                if (HussarUtils.isEmpty((Object)processTaskTableName)) {
                    return null;
                }
                String processState = taskDataSyncDto.getProcessState();
                String state = stateType.get(processState);
                taskDataSyncDto.setState(state);
            }
        }
        try {
            this.businessMapper.updateBusiness(taskDataSyncDtoList);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Boolean changeProcessNode(TaskDataSyncDto taskDataSyncDto) {
        try {
            String businessTableName = taskDataSyncDto.getBusinessTableName();
            if (HussarUtils.isEmpty((Object)businessTableName)) {
                return null;
            }
            this.businessMapper.updateProcessNode(taskDataSyncDto);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        stateType.put("startProcess", "0");
        stateType.put("reStartProcess", "0");
        stateType.put("activateProcess", "0");
        stateType.put("completeProcess", "1");
        stateType.put("endProcess", "2");
        stateType.put("revokeProcess", "3");
        stateType.put("suspendProcess", "4");
        stateType.put("deleteProcess", "5");
    }
}

