/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowCompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCompleteManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5df2\u529e\u672a\u7ed3\u3001\u529e\u7406\u5b8c\u6bd5\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/completeManage"})
public class CompleteManageController {
    private final Logger logger = LoggerFactory.getLogger(CompleteManageController.class);

    @GetMapping(value={"/doneNonCompleteList"})
    @ApiOperation(value="\u5df2\u529e\u672a\u7ed3\u67e5\u8be2", notes="\u5df2\u529e\u672a\u7ed3\u67e5\u8be2")
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u5df2\u529e\u672a\u7ed3\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> doneNonCompleteList(Page<?> pages, TaskCompleteManageQueryDto taskCompleteManageQueryDto) {
        String securityLevel = taskCompleteManageQueryDto.getSecurityLevel();
        String processKey = taskCompleteManageQueryDto.getProcessKey();
        String userId = HussarUtils.isNotEmpty((Object)taskCompleteManageQueryDto.getUserId()) ? taskCompleteManageQueryDto.getUserId() : String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskCompleteManageQueryDto.getSendUserId();
        String message = taskCompleteManageQueryDto.getMessage();
        String type = taskCompleteManageQueryDto.getType();
        String startTime = taskCompleteManageQueryDto.getStartTime();
        String endTime = taskCompleteManageQueryDto.getEndTime();
        String processStartUserId = taskCompleteManageQueryDto.getProcessStartUserId();
        String processStartTime = taskCompleteManageQueryDto.getProcessStartTime();
        String processEndTime = taskCompleteManageQueryDto.getProcessEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Date processStart = null;
        Date processEnd = null;
        try {
            processStart = HussarUtils.isNotEmpty((Object)processStartTime) ? formatter.parse(processStartTime) : null;
            processEnd = HussarUtils.isNotEmpty((Object)processEndTime) ? formatter.parse(processEndTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") != null ? BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString() : null;
        FlowCompleteTaskDto flowTaskDto = new FlowCompleteTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setType(type);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setServerCode(serverCode);
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartTime(processStart);
        flowTaskDto.setProcessEndTime(processEnd);
        BpmResponseResult bpmResponseResult = TaskEngineService.doneNonCompleteList((FlowCompleteTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/masterDoneNonCompleteList"})
    @ApiOperation(value="\u4e3b\u5e93\u5df2\u529e\u672a\u7ed3\u67e5\u8be2", notes="\u4e3b\u5e93\u5df2\u529e\u672a\u7ed3\u67e5\u8be2")
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u5df2\u529e\u672a\u7ed3\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> masterDoneNonCompleteList(Page<?> pages, TaskCompleteManageQueryDto taskCompleteManageQueryDto) {
        String securityLevel = taskCompleteManageQueryDto.getSecurityLevel();
        String processKey = taskCompleteManageQueryDto.getProcessKey();
        String userId = HussarUtils.isNotEmpty((Object)taskCompleteManageQueryDto.getUserId()) ? taskCompleteManageQueryDto.getUserId() : String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskCompleteManageQueryDto.getSendUserId();
        String message = taskCompleteManageQueryDto.getMessage();
        String type = taskCompleteManageQueryDto.getType();
        String startTime = taskCompleteManageQueryDto.getStartTime();
        String endTime = taskCompleteManageQueryDto.getEndTime();
        String processStartUserId = taskCompleteManageQueryDto.getProcessStartUserId();
        String processStartTime = taskCompleteManageQueryDto.getProcessStartTime();
        String processEndTime = taskCompleteManageQueryDto.getProcessEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Date processStart = null;
        Date processEnd = null;
        try {
            processStart = HussarUtils.isNotEmpty((Object)processStartTime) ? formatter.parse(processStartTime) : null;
            processEnd = HussarUtils.isNotEmpty((Object)processEndTime) ? formatter.parse(processEndTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") != null ? BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString() : null;
        FlowCompleteTaskDto flowTaskDto = new FlowCompleteTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setType(type);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setServerCode(serverCode);
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartTime(processStart);
        flowTaskDto.setProcessEndTime(processEnd);
        BpmResponseResult bpmResponseResult = TaskEngineService.masterDoneNonCompleteList((FlowCompleteTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/completeList"})
    @ApiOperation(value="\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2", notes="\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2")
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> completeList(Page<?> pages, TaskCompleteManageQueryDto taskCompleteManageQueryDto) {
        String securityLevel = taskCompleteManageQueryDto.getSecurityLevel();
        String processKey = taskCompleteManageQueryDto.getProcessKey();
        String userId = HussarUtils.isNotEmpty((Object)taskCompleteManageQueryDto.getUserId()) ? taskCompleteManageQueryDto.getUserId() : String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskCompleteManageQueryDto.getSendUserId();
        String message = taskCompleteManageQueryDto.getMessage();
        String type = taskCompleteManageQueryDto.getType();
        String startTime = taskCompleteManageQueryDto.getStartTime();
        String endTime = taskCompleteManageQueryDto.getEndTime();
        String processStartUserId = taskCompleteManageQueryDto.getProcessStartUserId();
        String processStartTime = taskCompleteManageQueryDto.getProcessStartTime();
        String processEndTime = taskCompleteManageQueryDto.getProcessEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Date processStart = null;
        Date processEnd = null;
        try {
            processStart = HussarUtils.isNotEmpty((Object)processStartTime) ? formatter.parse(processStartTime) : null;
            processEnd = HussarUtils.isNotEmpty((Object)processEndTime) ? formatter.parse(processEndTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") != null ? BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString() : null;
        FlowCompleteTaskDto flowTaskDto = new FlowCompleteTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setType(type);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setServerCode(serverCode);
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartTime(processStart);
        flowTaskDto.setProcessEndTime(processEnd);
        BpmResponseResult bpmResponseResult = TaskEngineService.completeList((FlowCompleteTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/masterCompleteList"})
    @ApiOperation(value="\u4e3b\u5e93\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2", notes="\u4e3b\u5e93\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2")
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u4e3b\u5e93\u529e\u7406\u5b8c\u6bd5\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> masterCompleteList(Page<?> pages, TaskCompleteManageQueryDto taskCompleteManageQueryDto) {
        String securityLevel = taskCompleteManageQueryDto.getSecurityLevel();
        String processKey = taskCompleteManageQueryDto.getProcessKey();
        String userId = HussarUtils.isNotEmpty((Object)taskCompleteManageQueryDto.getUserId()) ? taskCompleteManageQueryDto.getUserId() : String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskCompleteManageQueryDto.getSendUserId();
        String message = taskCompleteManageQueryDto.getMessage();
        String type = taskCompleteManageQueryDto.getType();
        String startTime = taskCompleteManageQueryDto.getStartTime();
        String endTime = taskCompleteManageQueryDto.getEndTime();
        String processStartUserId = taskCompleteManageQueryDto.getProcessStartUserId();
        String processStartTime = taskCompleteManageQueryDto.getProcessStartTime();
        String processEndTime = taskCompleteManageQueryDto.getProcessEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Date processStart = null;
        Date processEnd = null;
        try {
            processStart = HussarUtils.isNotEmpty((Object)processStartTime) ? formatter.parse(processStartTime) : null;
            processEnd = HussarUtils.isNotEmpty((Object)processEndTime) ? formatter.parse(processEndTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") != null ? BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString() : null;
        FlowCompleteTaskDto flowTaskDto = new FlowCompleteTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setType(type);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setServerCode(serverCode);
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartTime(processStart);
        flowTaskDto.setProcessEndTime(processEnd);
        BpmResponseResult bpmResponseResult = TaskEngineService.masterCompleteList((FlowCompleteTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

