/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.auth.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.SysActCcTaskService;
import com.jxdinfo.hussar.workflow.upgrade.StandardFormAuthApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowAuth"})
public class BpmFlowAuthConfigController {
    @Autowired
    private StandardFormAuthApiService formAuthApiService;

    @PostMapping(value={"/getAllAuthConfigs"})
    public Map<String, Object> getAllAuthConfigs(@RequestBody Map<String, Object> map) {
        BpmResponseResult result;
        WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto = new WorkflowAuthConfigQueryDto();
        String formName = HussarUtils.isNotEmpty((Object)map.get("formName")) ? String.valueOf(map.get("formName")) : null;
        workflowAuthConfigQueryDto.setFormName(formName);
        String processKey = HussarUtils.isNotEmpty((Object)map.get("processKey")) ? String.valueOf(map.get("processKey")) : null;
        workflowAuthConfigQueryDto.setProcessKey(processKey);
        String formTypeStr = HussarUtils.isNotEmpty((Object)map.get("formType")) ? String.valueOf(map.get("formType")) : "2";
        workflowAuthConfigQueryDto.setFormType(formTypeStr);
        workflowAuthConfigQueryDto.setTaskDefinitionKey(HussarUtils.isNotEmpty((Object)map.get("taskDefinitionKey")) ? String.valueOf(map.get("taskDefinitionKey")) : null);
        workflowAuthConfigQueryDto.setFormState(HussarUtils.isNotEmpty((Object)map.get("formState")) ? String.valueOf(map.get("formState")) : null);
        workflowAuthConfigQueryDto.setVersion(HussarUtils.isNotEmpty((Object)map.get("version")) ? Integer.valueOf(map.get("version").toString()) : null);
        String taskId = HussarUtils.isNotEmpty((Object)map.get("taskId")) ? String.valueOf(map.get("taskId")) : null;
        workflowAuthConfigQueryDto.setTaskId(taskId);
        workflowAuthConfigQueryDto.setGetLastVersion(false);
        Long userId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getId();
        Long deptId = BaseSecurityUtil.getUser().getDeptId();
        workflowAuthConfigQueryDto.setUserId(String.valueOf(userId));
        workflowAuthConfigQueryDto.setOrganId(String.valueOf(deptId));
        List allConfigs = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)formName) && HussarUtils.isNotEmpty((Object)processKey)) {
            result = this.formAuthApiService.queryFormAuthConfigsByDto(workflowAuthConfigQueryDto);
            JSONArray data = result.getResult();
            allConfigs = JSONArray.parseArray((String)JSON.toJSONString((Object)data), SysActFormAuth.class);
        }
        result = new HashMap();
        result.put("data", allConfigs);
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            String id = taskId.split(":")[0];
            SysActCcTaskDto sysActCcTaskDto = new SysActCcTaskDto();
            sysActCcTaskDto.setTaskId(id);
            sysActCcTaskDto.setUserId(String.valueOf(userId));
            SysActCcTaskService.readByTaskId((SysActCcTaskDto)sysActCcTaskDto);
        }
        return result;
    }
}

