/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.engine.bpm.assist.dto.AssistTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextUserTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.AssigneeService;
import com.jxdinfo.hussar.workflow.manage.engine.AssistService;
import com.jxdinfo.hussar.workflow.manage.engine.FunctionMigrationService;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.SysActCcTaskService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowMigrationService;
import com.jxdinfo.hussar.workflow.manage.engine.service.Bpm2XMLApiService;
import com.jxdinfo.hussar.workflow.manage.engine.service.ProcessDiagramApiService;
import com.jxdinfo.hussar.workflow.upgrade.StandardTaskEngineApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic"})
public class BpmPublicProcessController {
    @Autowired
    private StandardTaskEngineApiService standardTaskEngineApiService;
    @Autowired
    private ProcessDiagramApiService processDiagramService;
    @Autowired
    private Bpm2XMLApiService bpm2XMLService;

    @GetMapping(value={"/publicProcess/queryNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto();
        nextUserTaskQueryDto.setProcessKey(processDefinitionKey);
        nextUserTaskQueryDto.setTaskId(taskId);
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        nextUserTaskQueryDto.setIsGetRevokeNode(Boolean.valueOf(false));
        nextUserTaskQueryDto.setIsGetWithGroup(false);
        BpmResponseResult bpmResponseResult = this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
        if (!bpmResponseResult.isSuccess()) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        return bpmResponseResult;
    }

    @GetMapping(value={"/publicProcess/queryNextUserTask"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextUserTask(@RequestParam(value="processDefinitionKey", required=false) String processDefinitionKey, @RequestParam(value="taskId") String taskId, @RequestParam(value="lineCondition", required=false) String lineCondition, @RequestParam(value="isGetRevokeNode", defaultValue="false") boolean isGetRevokeNode) {
        Map map = new HashMap();
        if (HussarUtils.isNotEmpty((Object)lineCondition)) {
            map = (Map)JSON.parseObject((String)lineCondition, HashMap.class);
        }
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto();
        nextUserTaskQueryDto.setProcessKey(processDefinitionKey);
        nextUserTaskQueryDto.setTaskId(taskId);
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        nextUserTaskQueryDto.setIsGetRevokeNode(Boolean.valueOf(isGetRevokeNode));
        nextUserTaskQueryDto.setIsGetWithGroup(true);
        nextUserTaskQueryDto.setLineCondition(map);
        return this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
    }

    @PostMapping(value={"/publicProcess/queryNextUserNode"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="lineCondition", value="\u6761\u4ef6\u53d8\u91cf", required=false, paramType="body")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextUserNode(@RequestParam(value="processDefinitionKey") String processDefinitionKey, @RequestParam(value="taskId") String taskId, @RequestBody Map<String, Object> lineCondition, @RequestParam(value="isGetRevokeNode") boolean isGetRevokeNode) {
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto();
        nextUserTaskQueryDto.setProcessKey(processDefinitionKey);
        nextUserTaskQueryDto.setTaskId(taskId);
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        nextUserTaskQueryDto.setIsGetRevokeNode(Boolean.valueOf(isGetRevokeNode));
        nextUserTaskQueryDto.setIsGetWithGroup(true);
        nextUserTaskQueryDto.setLineCondition(lineCondition);
        return this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
    }

    @PostMapping(value={"/publicProcess/queryNextUserTaskWithLineCondition"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nextUserTaskQueryDto", value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9Dto", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextUserTask(@RequestBody TaskQueryNextNodeDto taskQueryNextNodeDto) {
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto(taskQueryNextNodeDto);
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        return this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
    }

    @GetMapping(value={"/publicProcess/queryRejectNodeOrNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectNodeOrNextNode(String processDefinitionKey, String taskId) {
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto();
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        nextUserTaskQueryDto.setProcessKey(processDefinitionKey);
        nextUserTaskQueryDto.setTaskId(taskId);
        nextUserTaskQueryDto.setIsGetRevokeNode(Boolean.valueOf(true));
        nextUserTaskQueryDto.setIsGetWithGroup(false);
        return this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
    }

    @GetMapping(value={"/publicProcess/queryNextNodeByLineCondition"})
    @ApiOperation(value="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="lineCondition", value="\u7ebf\u6761\u4ef6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextNodeByLineCondition(String processDefinitionKey, String taskId, String lineCondition) {
        Map map = (Map)JSONObject.parseObject((String)lineCondition, HashMap.class);
        NextUserTaskQueryDto nextUserTaskQueryDto = new NextUserTaskQueryDto();
        nextUserTaskQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextUserTaskQueryDto.setOrganId(String.valueOf(organId));
        }
        nextUserTaskQueryDto.setProcessKey(processDefinitionKey);
        nextUserTaskQueryDto.setTaskId(taskId);
        nextUserTaskQueryDto.setIsGetRevokeNode(Boolean.valueOf(true));
        nextUserTaskQueryDto.setIsGetWithGroup(false);
        nextUserTaskQueryDto.setLineCondition(map);
        return this.standardTaskEngineApiService.queryNextUserTask(nextUserTaskQueryDto);
    }

    @GetMapping(value={"/publicProcess/queryNextAssigneeByTaskIdAndNodeId"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String assigneeVariable) {
        Map map = new HashMap();
        if (HussarUtils.isNotEmpty((Object)assigneeVariable)) {
            map = (Map)JSON.parseObject((String)assigneeVariable, HashMap.class);
        }
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(processDefinitionKey);
        nextAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextAssigneeQueryDto.setOrganId(String.valueOf(organId));
        }
        nextAssigneeQueryDto.setTaskId(taskId);
        nextAssigneeQueryDto.setNodeId(nodeId);
        nextAssigneeQueryDto.setMap(map);
        return this.standardTaskEngineApiService.queryNextAssignee(nextAssigneeQueryDto);
    }

    @PostMapping(value={"/publicProcess/queryNextNodeAssigneeByTaskIdAndNodeId"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005dto", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextNodeAssigneeByTaskIdAndNodeId(@RequestBody NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        Map map = new HashMap();
        String processDefinitionKey = nodeAssigneeQueryDto.getProcessDefinitionKey();
        String taskId = nodeAssigneeQueryDto.getTaskId();
        String nodeId = nodeAssigneeQueryDto.getNodeId();
        String assigneeVariable = nodeAssigneeQueryDto.getAssigneeVariable();
        if (HussarUtils.isNotEmpty((Object)assigneeVariable)) {
            map = (Map)JSON.parseObject((String)assigneeVariable, HashMap.class);
        }
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(processDefinitionKey);
        nextAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextAssigneeQueryDto.setOrganId(String.valueOf(organId));
        }
        nextAssigneeQueryDto.setTaskId(taskId);
        nextAssigneeQueryDto.setNodeId(nodeId);
        nextAssigneeQueryDto.setMap(map);
        return this.standardTaskEngineApiService.queryNextAssignee(nextAssigneeQueryDto);
    }

    @GetMapping(value={"/publicProcess/queryAllAssignee"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryAllAssignee(String processDefinitionKey) {
        return TaskEngineService.queryAllAssignee((String)processDefinitionKey);
    }

    @GetMapping(value={"/publicProcess/getAllProcessTraceByBusinessKey"})
    @ApiOperation(value="\u83b7\u53d6\u529e\u7406\u5386\u53f2", notes="\u83b7\u53d6\u529e\u7406\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u529e\u7406\u5386\u53f2", eventDesc="\u83b7\u53d6\u529e\u7406\u5386\u53f2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size) {
        return InstanceEngineService.getAllProcessTraceByBusinessKey((String)businessKey, (int)page, (int)size);
    }

    @PostMapping(value={"/publicProcess/addCustomNode"})
    @ApiOperation(value="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", notes="\u589e\u52a0\u4e34\u65f6\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", eventDesc="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<?> addCustomNode(@RequestBody Map<String, Object> map) {
        return TaskEngineService.addCustomNode((String)String.valueOf(map.get("taskId")), (List)((List)map.get("list")), (String)String.valueOf(map.get("parallel")));
    }

    @GetMapping(value={"/publicProcess/isAddParallel"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventDesc="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> isAddParallel(String taskId) {
        return TaskEngineService.isAddParallel((String)taskId);
    }

    @GetMapping(value={"/publicProcess/isAddCustomNode"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventDesc="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> isAddCustomNode(String taskId) {
        return TaskEngineService.isAddCustomNode((String)taskId);
    }

    @GetMapping(value={"/publicProcess/isTodoTask"})
    @ApiOperation(value="\u4e3a\u6d88\u606f\u63a8\u9001\u5224\u65ad\u7528\u6237\u5728\u8be5\u8282\u70b9\u4e0a\u7684\u8868\u5355\u6743\u9650", notes="\u4e3a\u6d88\u606f\u63a8\u9001\u5224\u65ad\u7528\u6237\u5728\u8be5\u8282\u70b9\u4e0a\u7684\u8868\u5355\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u4e3a\u6d88\u606f\u63a8\u9001\u5224\u65ad\u7528\u6237\u5728\u8be5\u8282\u70b9\u4e0a\u7684\u8868\u5355\u6743\u9650", eventDesc="\u4e3a\u6d88\u606f\u63a8\u9001\u5224\u65ad\u7528\u6237\u5728\u8be5\u8282\u70b9\u4e0a\u7684\u8868\u5355\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> isTodoTask(String taskId) {
        Long id = BaseSecurityUtil.getUser().getId();
        BpmResponseResult todoResult = TaskEngineService.isTodoTask((String)taskId, (String)String.valueOf(id));
        if (HussarUtils.isNotEmpty((Object)todoResult)) {
            String code = todoResult.getCode();
            String msg = todoResult.getMsg();
            JSONObject object = new JSONObject();
            object.put("code", (Object)code);
            object.put("msg", (Object)msg);
            return ApiResponse.success((Object)object);
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @GetMapping(value={"/publicProcess/queryRejectNode"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", notes="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", eventDesc="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectNode(String taskId, boolean getWithMainProcess) {
        return TaskEngineService.queryRejectNode((String)taskId, (boolean)getWithMainProcess);
    }

    @GetMapping(value={"/publicProcess/queryJumpNode"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", notes="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", eventDesc="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryJumpNode(String taskId, boolean getWithMainProcess) {
        return TaskEngineService.queryJumpNode((String)taskId, (boolean)getWithMainProcess);
    }

    @GetMapping(value={"/publicProcess/queryCompletecComments"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u610f\u89c1", notes="\u67e5\u8be2\u529e\u7406\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query"), @ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u529e\u7406\u610f\u89c1", eventDesc="\u67e5\u8be2\u529e\u7406\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryCompleteComments(String processInsId, String businessKey) {
        return InstanceEngineService.queryCompleteComment((String)businessKey, (String)processInsId);
    }

    @GetMapping(value={"/publicProcess/getModifyConfigurationOnline"})
    @ApiOperation(value="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", notes="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e")
    @AuditLog(moduleName="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", eventDesc="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getModifyConfigurationOnline() {
        return ApiResponse.success((String)"true");
    }

    @GetMapping(value={"/publicProcess/queryUserTree"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811")
    @ApiImplicitParam(name="organName", value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u540d\u6216\u90e8\u95e8\u540d", required=true, paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventDesc="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryUserTree(String organName) {
        return AssigneeService.queryUserTree((String)organName);
    }

    @GetMapping(value={"/publicProcess/queryUserListByPage"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventDesc="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<BpmTreeModel>> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        return AssigneeService.queryUserListByPage(pages, (BpmTreeModel)bpmTreeModel);
    }

    @GetMapping(value={"/publicProcess/dept"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", notes="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811")
    @ApiImplicitParam(name="id", value="\u7236\u8282\u70b9id", required=false, paramType="query")
    @AuditLog(moduleName="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", eventDesc="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> dept(String id) {
        return AssigneeService.deptTree((String)id);
    }

    @PostMapping(value={"/publicProcess/userTreeForUserChoose"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237", notes="\u61d2\u52a0\u8f7d\u7528\u6237")
    @ApiImplicitParam(name="id", value="\u8282\u70b9id", required=false, paramType="query")
    @AuditLog(moduleName="\u61d2\u52a0\u8f7d\u7528\u6237", eventDesc="\u61d2\u52a0\u8f7d\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTree>> userTreeForUserChoose(String id) {
        return AssigneeService.userTreeForUserChoose((String)id);
    }

    @PostMapping(value={"/publicProcess/queryUserTreeForUserChoose"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParam(name="organName", value="\u5173\u952e\u5b57", required=true, paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u7528\u6237", eventDesc="\u6a21\u7cca\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganUserTree>> queryUserTreeForUserChoose(Page<OrganUserTree> page, String organName) {
        return AssigneeService.queryUserTreeForUserChoose(page, (String)organName);
    }

    @GetMapping(value={"/publicProcess/queryDeptTreeByChildren"})
    @ApiOperation(value="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", notes="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811")
    @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")
    @AuditLog(moduleName="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventDesc="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return AssigneeService.queryDeptTreeByChildren((BpmTreeModel)bpmTreeModel);
    }

    @PostMapping(value={"/publicProcess/queryNodeAssigneeAndDept"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u8282\u70b9\u53c2\u4e0e\u8005\u67e5\u8be2dto", paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryNodeAssigneeAndDept(@RequestBody NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(nodeAssigneeQueryDto.getProcessKey());
        nextAssigneeQueryDto.setTaskId(nodeAssigneeQueryDto.getTaskId());
        nextAssigneeQueryDto.setNodeId(nodeAssigneeQueryDto.getNodeId());
        nextAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextAssigneeQueryDto.setOrganId(String.valueOf(organId));
        }
        nextAssigneeQueryDto.setOrganName(nodeAssigneeQueryDto.getOrganName());
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            Map assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
            nextAssigneeQueryDto.setMap(assigneeVariable);
        } else {
            nextAssigneeQueryDto.setMap(nodeAssigneeQueryDto.getAssigneeVariableMap());
        }
        BpmResponseResult bpmResponseResult = this.standardTaskEngineApiService.queryNextAssignee(nextAssigneeQueryDto);
        if (bpmResponseResult.isSuccess()) {
            List list = JSON.parseArray((String)bpmResponseResult.getResult().toJSONString(), BpmTreeModel.class);
            return ApiResponse.success((Object)list);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/publicProcess/queryNodeAssigneeListByPage"})
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u8282\u70b9\u53c2\u4e0e\u8005\u67e5\u8be2dto", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<BpmTreeModel>> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(nodeAssigneeQueryDto.getProcessKey());
        nextAssigneeQueryDto.setTaskId(nodeAssigneeQueryDto.getTaskId());
        nextAssigneeQueryDto.setNodeId(nodeAssigneeQueryDto.getNodeId());
        nextAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextAssigneeQueryDto.setOrganId(String.valueOf(organId));
        }
        nextAssigneeQueryDto.setOrganName(nodeAssigneeQueryDto.getOrganName());
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            Map assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
            nextAssigneeQueryDto.setMap(assigneeVariable);
        } else {
            nextAssigneeQueryDto.setMap(nodeAssigneeQueryDto.getAssigneeVariableMap());
        }
        nextAssigneeQueryDto.setPage(pages);
        if ("user".equals(nodeAssigneeQueryDto.getType())) {
            nextAssigneeQueryDto.setPageQueryId(nodeAssigneeQueryDto.getId());
        } else {
            nextAssigneeQueryDto.setPageQueryParentId(nodeAssigneeQueryDto.getId());
        }
        BpmResponseResult bpmResponseResult = this.standardTaskEngineApiService.queryNextAssignee(nextAssigneeQueryDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/publicProcess/queryNextNodeAssigneeListByPage"})
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u8282\u70b9\u53c2\u4e0e\u8005\u67e5\u8be2dto", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<BpmTreeModel>> queryNextNodeAssigneeListByPage(@RequestParam(value="current") long current, @RequestParam(value="size") long size, @RequestBody NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        Page pages = new Page();
        pages.setSize(size);
        pages.setCurrent(current);
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(nodeAssigneeQueryDto.getProcessKey());
        nextAssigneeQueryDto.setTaskId(nodeAssigneeQueryDto.getTaskId());
        nextAssigneeQueryDto.setNodeId(nodeAssigneeQueryDto.getNodeId());
        nextAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Long organId = BaseSecurityUtil.getUser().getDeptId();
        if (organId != null) {
            nextAssigneeQueryDto.setOrganId(String.valueOf(organId));
        }
        nextAssigneeQueryDto.setOrganName(nodeAssigneeQueryDto.getOrganName());
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            Map assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
            nextAssigneeQueryDto.setMap(assigneeVariable);
        } else {
            nextAssigneeQueryDto.setMap(nodeAssigneeQueryDto.getAssigneeVariableMap());
        }
        nextAssigneeQueryDto.setPage(pages);
        if ("user".equals(nodeAssigneeQueryDto.getType())) {
            nextAssigneeQueryDto.setPageQueryId(nodeAssigneeQueryDto.getId());
        } else {
            nextAssigneeQueryDto.setPageQueryParentId(nodeAssigneeQueryDto.getId());
        }
        BpmResponseResult bpmResponseResult = this.standardTaskEngineApiService.queryNextAssignee(nextAssigneeQueryDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success((Object)pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/publicProcess/queryRejectComment"})
    @ApiOperation(value="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", notes="\u67e5\u8be2\u9a73\u56de\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", eventDesc="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectComment(String taskId) {
        return TaskEngineService.queryRejectComment((String)taskId);
    }

    @GetMapping(value={"/publicProcess/selectInfoByProcessName"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u540d\u79f0", required=false, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u6d41\u7a0b\u4fe1\u606f", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult selectInfoByName(Page page, String processName) {
        return WorkflowMigrationService.selectByName((Page)page, (String)processName);
    }

    @GetMapping(value={"/publicProcess/selectFunctionInfoByName"})
    @ApiOperation(value="\u67e5\u8be2\u51fd\u6570\u4fe1\u606f", notes="\u67e5\u8be2\u51fd\u6570\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="functionName", value="\u51fd\u6570\u540d\u79f0", required=false, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u51fd\u6570\u4fe1\u606f", eventDesc="\u67e5\u8be2\u51fd\u6570\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult selectFunctionInfoByName(Page page, String functionName) {
        return FunctionMigrationService.selectByName((Page)page, (String)functionName);
    }

    @PostMapping(value={"/publicProcess/preemptTask"})
    @ApiOperation(value="\u62a2\u5355", notes="\u62a2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u62a2\u5355", eventDesc="\u62a2\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> preemptTask(@RequestBody String taskId) {
        PreemptCommonDto preemptCommonDto = new PreemptCommonDto();
        preemptCommonDto.setTaskId(taskId);
        preemptCommonDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        TaskEngineService.preemptTask((PreemptCommonDto)preemptCommonDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/publicProcess/unPreemptTask"})
    @ApiOperation(value="\u53d6\u6d88\u62a2\u5355", notes="\u53d6\u6d88\u62a2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u53d6\u6d88\u62a2\u5355", eventDesc="\u53d6\u6d88\u62a2\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> unPreemptTask(@RequestBody String taskId) {
        PreemptCommonDto preemptCommonDto = new PreemptCommonDto();
        preemptCommonDto.setTaskId(taskId);
        preemptCommonDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        TaskEngineService.unPreemptTask((PreemptCommonDto)preemptCommonDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/publicProcess/createAssistTask"})
    @ApiOperation(value="\u53d1\u8d77\u534f\u529e", notes="\u53d1\u8d77\u534f\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="assistTaskDto", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u53d1\u8d77\u534f\u529e", eventDesc="\u53d1\u8d77\u534f\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> createAssistTask(@RequestBody AssistTaskDto assistTaskDto) {
        BpmResponseResult bpmResponseResult = AssistService.createAssistTask((String)assistTaskDto.getTaskId(), (String)String.valueOf(BaseSecurityUtil.getUser().getId()), (String)assistTaskDto.getAssignee(), (String)assistTaskDto.getComment());
        if (!bpmResponseResult.isSuccess()) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/publicProcess/completeAssistTask"})
    @ApiOperation(value="\u529e\u7406\u534f\u529e", notes="\u529e\u7406\u534f\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="assistTaskDto", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u529e\u7406\u534f\u529e", eventDesc="\u529e\u7406\u534f\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> completeAssistTask(@RequestBody AssistTaskDto assistTaskDto) {
        BpmResponseResult result = AssistService.completeAssistTask((String)assistTaskDto.getTaskId(), (String)String.valueOf(BaseSecurityUtil.getUser().getId()), (String)assistTaskDto.getComment());
        if (!result.isSuccess()) {
            return ApiResponse.fail((String)result.getMsg());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/publicProcess/ccTask"})
    @ApiOperation(value="\u4f20\u9605", notes="\u4f20\u9605")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysActCcTaskDto", value="\u4f20\u9605\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u4f20\u9605\u539f\u56e0", required=false, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb\u6284\u9001", eventDesc="\u9605\u8bfb\u6284\u9001", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Object> ccTask(@RequestBody SysActCcTaskDto sysActCcTaskDto) {
        sysActCcTaskDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        return SysActCcTaskService.ccTask((SysActCcTaskDto)sysActCcTaskDto);
    }

    @GetMapping(value={"/publicProcess/readCcTask"})
    @ApiOperation(value="\u9605\u8bfb\u6284\u9001", notes="\u9605\u8bfb\u6284\u9001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ccTaskId", value="\u6284\u9001\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb\u6284\u9001", eventDesc="\u9605\u8bfb\u6284\u9001", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> readCcTask(Long ccTaskId) {
        return SysActCcTaskService.read((Long)ccTaskId);
    }

    @GetMapping(value={"/publicProcess/queryFlowHistoryInfo"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u529e\u7406\u5386\u53f2", notes="\u67e5\u8be2\u6d41\u7a0b\u529e\u7406\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=false, paramType="query"), @ApiImplicitParam(name="processInstId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=false, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u8868\u5355\u64cd\u4f5c", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u529e\u7406\u5386\u53f2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONObject> queryFlowHistoryInfo(String businessId, String processInstId) {
        BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
        if (HussarUtils.isEmpty((Object)result.getResult())) {
            return ApiResponse.success((Object)new JSONObject());
        }
        JSONObject jsonObject = result.getResult().getJSONObject(0);
        return ApiResponse.success((Object)jsonObject);
    }

    @GetMapping(value={"/publicProcess/getCountAllTotal"})
    @ApiOperation(value="\u7edf\u8ba1\u5f85\u529e\u3001\u5df2\u529e\u3001\u4f20\u9605\u3001\u50ac\u529e\uff0c\u53d1\u8d77\u4efb\u52a1\u6570", notes="\u7edf\u8ba1\u5f85\u529e\u3001\u5df2\u529e\u3001\u4f20\u9605\u3001\u50ac\u529e\uff0c\u53d1\u8d77\u4efb\u52a1\u6570")
    public ApiResponse<?> getCountAllTotal() {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        BpmResponseResult bpmResponseResult = TaskEngineService.getCountAllTotal((String)userId);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((Object)bpmResponseResult.getResult().get(0));
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/publicProcess/getAllCounts"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u63cf\u8ff0\u548c\u6d41\u7a0b\u6807\u8bc6\u7edf\u8ba1\u5f85\u529e\u3001\u5df2\u529e\u3001\u4f20\u9605\u3001\u50ac\u529e\uff0c\u53d1\u8d77\u4efb\u52a1\u6570", notes="\u6839\u636e\u4e1a\u52a1\u63cf\u8ff0\u548c\u6d41\u7a0b\u6807\u8bc6\u7edf\u8ba1\u5f85\u529e\u3001\u5df2\u529e\u3001\u4f20\u9605\u3001\u50ac\u529e\uff0c\u53d1\u8d77\u4efb\u52a1\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="todoConfiguration", value="\u4e1a\u52a1\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query")})
    public ApiResponse<?> getAllCounts(String todoConfiguration, String processKey) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        BpmResponseResult bpmResponseResult = TaskEngineService.getAllCounts((String)userId, (String)todoConfiguration, (String)processKey);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((Object)bpmResponseResult.getResult().get(0));
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/publicProcess/delCustomNode"})
    @ApiOperation(value="\u4e34\u65f6\u5220\u9664\u8282\u70b9", notes="\u4e34\u65f6\u5220\u9664\u8282\u70b9")
    @AuditLog(moduleName="\u4e34\u65f6\u5220\u9664\u8282\u70b9", eventDesc="\u4e34\u65f6\u5220\u9664\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult delCustomNode(@RequestParam(value="taskId") String taskId, @RequestParam(value="nodeId") String nodeId) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        return TaskEngineService.delCustomNode((String)taskId, (String)nodeId, (String)userId);
    }

    @GetMapping(value={"/publicProcess/queryDelNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u4e34\u65f6\u5220\u9664\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u4e34\u65f6\u5220\u9664\u7684\u8282\u70b9")
    @AuditLog(moduleName="\u67e5\u8be2\u53ef\u4ee5\u4e34\u65f6\u5220\u9664\u7684\u8282\u70b9", eventDesc="\u67e5\u8be2\u53ef\u4ee5\u4e34\u65f6\u5220\u9664\u7684\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryDelNode(@RequestParam(value="taskId") String taskId) {
        return TaskEngineService.queryDelNode((String)taskId);
    }

    @GetMapping(value={"/publicProcess/taskAvoidSuspicion"})
    @ApiOperation(value="\u6d41\u7a0b\u56de\u907f", notes="\u6d41\u7a0b\u56de\u907f")
    @AuditLog(moduleName="\u6d41\u7a0b\u56de\u907f", eventDesc="\u6d41\u7a0b\u56de\u907f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public BpmResponseResult taskAvoidSuspicion(@RequestParam(value="taskId") String taskId, @RequestParam(value="avoidComment", required=false) String avoidComment) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        return TaskEngineService.taskAvoidSuspicion((String)taskId, (String)userId, (String)avoidComment);
    }
}

