/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpm.migration;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.FunctionDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.FunctionDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.FunctionLoadVo;
import com.jxdinfo.hussar.workflow.manage.engine.FunctionMigrationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class FunctionMigrationPlugin
implements MigrationPlugin {
    public static final String TYPE = "function";
    public static final Long VERSION = null;
    public static final int DUMP_PRECEDENCE = 0;

    public MigrationPluginMetadata metadata() {
        return Metadata.INSTANCE;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        List functionDumpVos = new ArrayList();
        FunctionDumpDto functionDumpDto = new FunctionDumpDto();
        if (parameters.get(TYPE) == null) {
            return MigrationDumpItemVo.success((Long)0L, functionDumpVos);
        }
        functionDumpDto = (FunctionDumpDto)JsonUtil.convertValue((Object)parameters.get(TYPE), (TypeReference)new TypeReference<FunctionDumpDto>(){});
        functionDumpVos = FunctionMigrationService.dump((FunctionDumpDto)functionDumpDto);
        context.setAttribute("functionDumpFileMsg", functionDumpVos);
        ArrayList<FunctionLoadVo> functionLoadVoList = new ArrayList<FunctionLoadVo>();
        for (FunctionDumpVo functionDumpVo : functionDumpVos) {
            SysActFunction sysActFunction = functionDumpVo.getFunctionInfo();
            FunctionLoadVo functionLoadVo = new FunctionLoadVo(sysActFunction.getId(), sysActFunction.getFunctionName(), sysActFunction.getFunctionType(), sysActFunction.getRequestMethod(), sysActFunction.getFunctionBean());
            functionLoadVoList.add(functionLoadVo);
        }
        return MigrationDumpItemVo.success((Long)Long.valueOf(functionDumpDto.getFunctionId().size()), functionLoadVoList);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List functionDumpVos = new ArrayList();
        if (context.getAttribute("functionDumpFileMsg") != null) {
            functionDumpVos = (List)JsonUtil.convertValue((Object)context.getAttribute("functionDumpFileMsg"), (TypeReference)new TypeReference<List<FunctionDumpVo>>(){});
            return MigrationPreloadItemVo.success((Object)FunctionMigrationService.preload(functionDumpVos));
        }
        return MigrationPreloadItemVo.success((Object)new FunctionLoadVo());
    }

    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        if (HussarUtils.isEmpty((Object)context.getAttribute("functionDumpFileMsg"))) {
            return MigrationLoadItemVo.success((Long)0L, (Object)new FunctionDumpVo());
        }
        List functionDumpVos = (List)JsonUtil.convertValue((Object)context.getAttribute("functionDumpFileMsg"), (TypeReference)new TypeReference<List<FunctionDumpVo>>(){});
        HashMap<Long, FunctionDumpVo> functionDumpVoMap = new HashMap<Long, FunctionDumpVo>();
        for (FunctionDumpVo functionDumpVo : functionDumpVos) {
            functionDumpVoMap.put(functionDumpVo.getFunctionInfo().getId(), functionDumpVo);
        }
        List functionLoadVos = new ArrayList();
        ArrayList<FunctionLoadVo> newFunctionLoadVos = new ArrayList<FunctionLoadVo>();
        if (parameters != null && parameters.get(TYPE) != null) {
            functionLoadVos = JSON.parseArray((String)JSON.toJSONString((Object)parameters.get(TYPE)), FunctionLoadVo.class);
            for (FunctionLoadVo f : functionLoadVos) {
                if (!HussarUtils.isNotEmpty((Object)f.getId())) continue;
                newFunctionLoadVos.add(f);
            }
        }
        for (FunctionLoadVo functionLoadVo : newFunctionLoadVos) {
            functionLoadVo.setFunctionDumpVo((FunctionDumpVo)functionDumpVoMap.get(functionLoadVo.getId()));
        }
        FunctionMigrationService.load(newFunctionLoadVos);
        long successCount = 0L;
        for (FunctionLoadVo functionLoadVo : newFunctionLoadVos) {
            functionLoadVo.setFunctionDumpVo(null);
            if (!HussarUtils.isEmpty((Object)functionLoadVo.getImportType())) continue;
            ++successCount;
        }
        return MigrationLoadItemVo.success((Long)successCount, newFunctionLoadVos);
    }

    private static final class Metadata
    implements MigrationPluginMetadata {
        public static final Metadata INSTANCE = new Metadata();

        private Metadata() {
        }

        public String getServiceType() {
            return FunctionMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return VERSION;
        }

        public int getDumpPrecedence() {
            return 0;
        }
    }
}

