/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpm.migration;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowMigrationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationPlugin
implements MigrationPlugin {
    public static final String TYPE = "workflow";
    public static final Long VERSION = null;
    public static final int DUMP_PRECEDENCE = 0;

    public MigrationPluginMetadata metadata() {
        return Metadata.INSTANCE;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        ArrayList<WorkflowPreloadDto> dumpProcessDefIds = new ArrayList<WorkflowPreloadDto>();
        ArrayList<WorkflowMigrationDumpVo> workflowMigrationDumpVos = new ArrayList<WorkflowMigrationDumpVo>();
        List list = new ArrayList();
        if (parameters.get(TYPE) != null) {
            list = (List)IdempotentJsonUtils.convert((Object)parameters.get(TYPE), (TypeReference)new TypeReference<List<WorkflowDumpDto>>(){});
        }
        if (list.isEmpty()) {
            return MigrationDumpItemVo.success((Long)0L, workflowMigrationDumpVos);
        }
        for (WorkflowDumpDto workflowDumpDto : list) {
            WorkflowPreloadDto workflowPreloadDto = new WorkflowPreloadDto(workflowDumpDto);
            if (workflowPreloadDto.getOrganModels() != null) {
                workflowPreloadDto.getOrganModels().sort((m, n) -> m.getVersion() - n.getVersion());
            }
            dumpProcessDefIds.add(workflowPreloadDto);
            WorkflowMigrationDumpVo workflowMigrationDumpVo = new WorkflowMigrationDumpVo(workflowDumpDto);
            workflowMigrationDumpVos.add(workflowMigrationDumpVo);
        }
        List workflowDumpVos = WorkflowMigrationService.dump(list);
        for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
            String fileName = workflowDumpVo.getName() + "-" + workflowDumpVo.getProcessKey() + "/" + workflowDumpVo.getVersion() + "/" + workflowDumpVo.getFileSuffix();
            workflowDumpVo.setFileName(fileName);
            context.setPayloadOfString(fileName, workflowDumpVo.getContent());
            workflowDumpVo.setContent(null);
        }
        context.setAttribute("workflowDumpFileMsg", (Object)workflowDumpVos);
        context.setAttribute("workflowImportMsg", dumpProcessDefIds);
        return MigrationDumpItemVo.success((Long)Long.valueOf(list.size()), workflowMigrationDumpVos);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List importProcessDefIds;
        List list = new ArrayList();
        if (context.getAttribute("workflowImportMsg") != null && !(importProcessDefIds = (List)IdempotentJsonUtils.convert((Object)context.getAttribute("workflowImportMsg"), (TypeReference)new TypeReference<List<WorkflowPreloadDto>>(){})).isEmpty()) {
            list = WorkflowMigrationService.preload((List)importProcessDefIds);
        }
        return MigrationPreloadItemVo.success(list);
    }

    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        HashMap<String, WorkflowMigrationPreloadVo> importTypeMap = new HashMap<String, WorkflowMigrationPreloadVo>();
        HashMap importOrganTypeMap = new HashMap();
        List workflowMigrationPreloadVos = new ArrayList();
        if (parameters.get(TYPE) != null) {
            workflowMigrationPreloadVos = JSON.parseArray((String)JSON.toJSONString((Object)parameters.get(TYPE)), WorkflowMigrationPreloadVo.class);
        }
        if (workflowMigrationPreloadVos.isEmpty()) {
            return MigrationLoadItemVo.success((Long)0L, new ArrayList());
        }
        long count = 0L;
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowMigrationPreloadVos) {
            if (!"unable".equals(workflowMigrationPreloadVo.getImportType())) {
                ++count;
            }
            importTypeMap.put(workflowMigrationPreloadVo.getProcessKey(), workflowMigrationPreloadVo);
            if (workflowMigrationPreloadVo.getOrganModels() == null) continue;
            HashMap<String, WorkflowMigrationPreloadVo> map = new HashMap<String, WorkflowMigrationPreloadVo>();
            for (WorkflowMigrationPreloadVo organWorkflowMigrationPreloadVo : workflowMigrationPreloadVo.getOrganModels()) {
                map.put(organWorkflowMigrationPreloadVo.getOrganId(), organWorkflowMigrationPreloadVo);
            }
            importOrganTypeMap.put(workflowMigrationPreloadVo.getProcessKey(), map);
        }
        ArrayList<String> assigneeTable = new ArrayList<String>();
        ArrayList<String> formAuthTable = new ArrayList<String>();
        ArrayList<String> expandTable = new ArrayList<String>();
        ArrayList<String> handleAuthTable = new ArrayList<String>();
        HashMap<String, Map> fileMap = new HashMap<String, Map>();
        List workflowDumpVos = (List)IdempotentJsonUtils.convert((Object)context.getAttribute("workflowDumpFileMsg"), (TypeReference)new TypeReference<List<WorkflowDumpVo>>(){});
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        HashMap<String, String> modelTypeMap = new HashMap<String, String>();
        for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
            Map organTypeMap;
            serviceNameMap.put(workflowDumpVo.getProcessKey(), workflowDumpVo.getServiceName());
            modelTypeMap.put(workflowDumpVo.getProcessKey(), workflowDumpVo.getModelType());
            if (importTypeMap.get(workflowDumpVo.getProcessKey()) == null || (!HussarUtils.isEmpty((Object)workflowDumpVo.getOrganId()) ? (organTypeMap = (Map)importOrganTypeMap.get(workflowDumpVo.getProcessKey())) != null && "unable".equals(organTypeMap.get(workflowDumpVo.getOrganId())) : "unable".equals(((WorkflowMigrationPreloadVo)importTypeMap.get(workflowDumpVo.getProcessKey())).getImportType()))) continue;
            String fileName = workflowDumpVo.getFileName();
            if (fileName.endsWith("\u8868\u5355\u6743\u9650.json")) {
                String sysActFormAuth = context.getPayloadAsString(fileName);
                formAuthTable.add(sysActFormAuth);
            }
            if (fileName.endsWith("\u53c2\u4e0e\u8005.json")) {
                String sysActAssignees = context.getPayloadAsString(fileName);
                assigneeTable.add(sysActAssignees);
            }
            if (fileName.endsWith("\u62d3\u5c55.json")) {
                String expandProperties = context.getPayloadAsString(fileName);
                expandTable.add(expandProperties);
            }
            String key = workflowDumpVo.getProcessKey() + ":" + workflowDumpVo.getVersion() + ":";
            if (fileName.endsWith("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                String lcdpbpm = context.getPayloadAsString(fileName);
                fileMap.computeIfAbsent(key, e -> new HashMap()).put("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", lcdpbpm);
            }
            if (fileName.endsWith("bpmn20.xml")) {
                String xml = context.getPayloadAsString(fileName);
                fileMap.computeIfAbsent(key, e -> new HashMap()).put("bpmn20.xml", xml);
            }
            if (!fileName.endsWith("\u64cd\u4f5c\u6743\u9650.json")) continue;
            String handleAuth = context.getPayloadAsString(fileName);
            handleAuthTable.add(handleAuth);
        }
        WorkflowLoadDto workflowLoadDto = new WorkflowLoadDto();
        workflowLoadDto.setAssigneeMsgs(assigneeTable);
        workflowLoadDto.setExpandMsgs(expandTable);
        workflowLoadDto.setFormAuthMsgs(formAuthTable);
        workflowLoadDto.setHandleAuthMsgs(handleAuthTable);
        workflowLoadDto.setImportMsgMap(importTypeMap);
        workflowLoadDto.setWorkflowFiles(fileMap);
        workflowLoadDto.setImportMsgs(workflowMigrationPreloadVos);
        workflowLoadDto.setServiceNameMap(serviceNameMap);
        workflowLoadDto.setModelTypeMap(modelTypeMap);
        List list = WorkflowMigrationService.load((WorkflowLoadDto)workflowLoadDto);
        for (WorkflowLoadVo workflowLoadVo : list) {
            if ("fail".equals(workflowLoadVo.getImportResult())) {
                --count;
                continue;
            }
            if (workflowLoadVo.getOrganModels() == null) continue;
            boolean isSuccess = true;
            for (WorkflowLoadVo organModel : workflowLoadVo.getOrganModels()) {
                if (!"fail".equals(organModel.getImportResult())) continue;
                isSuccess = false;
                break;
            }
            if (isSuccess) continue;
            --count;
        }
        return MigrationLoadItemVo.success((Long)count, (Object)list);
    }

    private static final class Metadata
    implements MigrationPluginMetadata {
        public static final Metadata INSTANCE = new Metadata();

        private Metadata() {
        }

        public String getServiceType() {
            return WorkflowMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return VERSION;
        }

        public int getDumpPrecedence() {
            return 0;
        }
    }
}

