/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpm.migration;

import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.CustomFormDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.CustomFormDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.CustomFormLoadVo;
import com.jxdinfo.hussar.workflow.manage.engine.CustomFormMigrationService;
import java.util.Map;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CustomFormMigrationPlugin
implements MigrationPlugin {
    public static final String TYPE = "customForm";
    public static final Long VERSION = null;
    public static final int DUMP_PRECEDENCE = 0;
    private static final String JSON = ".json";
    public static final String FORM = "form";
    public static final String FORM_FILE_NAME = "form.json";

    public MigrationPluginMetadata metadata() {
        return Metadata.INSTANCE;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        Object parameter = parameters.get(TYPE);
        if (parameter == null) {
            return MigrationDumpItemVo.success((Long)0L);
        }
        CustomFormDumpDto workflowDumpDto = (CustomFormDumpDto)IdempotentJsonUtils.convert((Object)parameter, CustomFormDumpDto.class);
        CustomFormDumpVo customFormDumpVo = CustomFormMigrationService.dump((CustomFormDumpDto)workflowDumpDto);
        context.setPayloadOfJson(FORM_FILE_NAME, (Object)customFormDumpVo);
        context.setAttribute(FORM, (Object)FORM_FILE_NAME);
        long total = 0L + (long)customFormDumpVo.getCategoryList().size() + (long)customFormDumpVo.getFormList().size();
        return MigrationDumpItemVo.success((Long)total, (Object)CustomFormMigrationService.preload((CustomFormDumpVo)customFormDumpVo));
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        if (HussarUtils.isNotEmpty((Object)context.getAttribute(FORM))) {
            CustomFormDumpVo customFormDumpVo = (CustomFormDumpVo)context.getPayloadAsJson(FORM_FILE_NAME, CustomFormDumpVo.class);
            return MigrationPreloadItemVo.success((Object)CustomFormMigrationService.preload((CustomFormDumpVo)customFormDumpVo));
        }
        return MigrationPreloadItemVo.success((Object)new CustomFormLoadVo());
    }

    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        if (HussarUtils.isNotEmpty((Object)context.getAttribute(FORM))) {
            CustomFormDumpVo customFormDumpVo = (CustomFormDumpVo)context.getPayloadAsJson(FORM_FILE_NAME, CustomFormDumpVo.class);
            long total = 0L + (long)customFormDumpVo.getCategoryList().size() + (long)customFormDumpVo.getFormList().size();
            return MigrationLoadItemVo.success((Long)total, (Object)CustomFormMigrationService.load((CustomFormDumpVo)customFormDumpVo));
        }
        return MigrationLoadItemVo.success((Long)0L, (Object)new CustomFormLoadVo());
    }

    private static final class Metadata
    implements MigrationPluginMetadata {
        public static final Metadata INSTANCE = new Metadata();

        private Metadata() {
        }

        public String getServiceType() {
            return CustomFormMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return VERSION;
        }

        public int getDumpPrecedence() {
            return 0;
        }
    }
}

