/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpm.migration;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowMigrationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationPlugin
implements MigrationPlugin {
    public static final String TYPE = "workflow";
    public static final Long VERSION = null;
    public static final int DUMP_PRECEDENCE = 0;

    public MigrationPluginMetadata metadata() {
        return Metadata.INSTANCE;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        ArrayList<WorkflowPreloadDto> dumpProcessDefIds = new ArrayList<WorkflowPreloadDto>();
        ArrayList<WorkflowMigrationDumpVo> workflowMigrationDumpVos = new ArrayList<WorkflowMigrationDumpVo>();
        List list = new ArrayList();
        if (parameters.get(TYPE) != null) {
            list = (List)IdempotentJsonUtils.convert((Object)parameters.get(TYPE), (TypeReference)new TypeReference<List<WorkflowDumpDto>>(){});
        }
        if (list.isEmpty()) {
            return MigrationDumpItemVo.success((Long)0L, workflowMigrationDumpVos);
        }
        for (WorkflowDumpDto workflowDumpDto : list) {
            WorkflowPreloadDto workflowPreloadDto = new WorkflowPreloadDto(workflowDumpDto);
            dumpProcessDefIds.add(workflowPreloadDto);
            WorkflowMigrationDumpVo workflowMigrationDumpVo = new WorkflowMigrationDumpVo(workflowDumpDto);
            workflowMigrationDumpVos.add(workflowMigrationDumpVo);
        }
        List workflowDumpVos = WorkflowMigrationService.dump(list);
        for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
            String fileName = workflowDumpVo.getName() + "-" + workflowDumpVo.getProcessKey() + "/" + workflowDumpVo.getVersion() + "/" + workflowDumpVo.getFileSuffix();
            workflowDumpVo.setFileName(fileName);
            context.setPayloadOfString(fileName, workflowDumpVo.getContent());
            workflowDumpVo.setContent(null);
        }
        context.setAttribute("workflowDumpFileMsg", (Object)workflowDumpVos);
        context.setAttribute("workflowImportMsg", dumpProcessDefIds);
        return MigrationDumpItemVo.success((Long)Long.valueOf(list.size()), workflowMigrationDumpVos);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List importProcessDefIds;
        List list = new ArrayList();
        if (context.getAttribute("workflowImportMsg") != null && !(importProcessDefIds = (List)IdempotentJsonUtils.convert((Object)context.getAttribute("workflowImportMsg"), (TypeReference)new TypeReference<List<WorkflowPreloadDto>>(){})).isEmpty()) {
            list = WorkflowMigrationService.preload((List)importProcessDefIds);
        }
        return MigrationPreloadItemVo.success(list);
    }

    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        HashMap<String, WorkflowMigrationPreloadVo> importTypeMap = new HashMap<String, WorkflowMigrationPreloadVo>();
        List workflowMigrationPreloadVos = new ArrayList();
        if (parameters.get(TYPE) != null) {
            workflowMigrationPreloadVos = JSON.parseArray((String)JSON.toJSONString((Object)parameters.get(TYPE)), WorkflowMigrationPreloadVo.class);
        }
        if (workflowMigrationPreloadVos.isEmpty()) {
            return MigrationLoadItemVo.success((Long)0L, new ArrayList());
        }
        long count = 0L;
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowMigrationPreloadVos) {
            if (!"unable".equals(workflowMigrationPreloadVo.getImportType())) {
                ++count;
            }
            importTypeMap.put(workflowMigrationPreloadVo.getProcessKey(), workflowMigrationPreloadVo);
        }
        ArrayList<String> assigneeTable = new ArrayList<String>();
        ArrayList<String> formAuthTable = new ArrayList<String>();
        ArrayList<String> expandTable = new ArrayList<String>();
        ArrayList<String> handleAuthTable = new ArrayList<String>();
        ArrayList<String> postActionTable = new ArrayList<String>();
        ArrayList<String> ccTaskConfigTable = new ArrayList<String>();
        ArrayList<String> alternativeTaskTable = new ArrayList<String>();
        ArrayList<String> formDataTable = new ArrayList<String>();
        ArrayList<String> returnToRectificationTable = new ArrayList<String>();
        ArrayList<String> rectificationActionTable = new ArrayList<String>();
        ArrayList<String> businessModuleTable = new ArrayList<String>();
        ArrayList<String> procGroupTable = new ArrayList<String>();
        ArrayList<String> processDeptTable = new ArrayList<String>();
        ArrayList<String> processDefinitionTable = new ArrayList<String>();
        HashMap fileMap = new HashMap();
        List workflowDumpVos = (List)IdempotentJsonUtils.convert((Object)context.getAttribute("workflowDumpFileMsg"), (TypeReference)new TypeReference<List<WorkflowDumpVo>>(){});
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
            String businessModule;
            Map<String, String> map;
            serviceNameMap.put(workflowDumpVo.getProcessKey(), workflowDumpVo.getServiceName());
            if (importTypeMap.get(workflowDumpVo.getProcessKey()) == null || "unable".equals(((WorkflowMigrationPreloadVo)importTypeMap.get(workflowDumpVo.getProcessKey())).getImportType())) continue;
            String fileName = workflowDumpVo.getFileName();
            if (fileName.endsWith("\u8868\u5355\u6743\u9650.json")) {
                String sysActFormAuth = context.getPayloadAsString(fileName);
                formAuthTable.add(sysActFormAuth);
            }
            if (fileName.endsWith("\u53c2\u4e0e\u8005.json")) {
                String sysActAssignees = context.getPayloadAsString(fileName);
                assigneeTable.add(sysActAssignees);
            }
            if (fileName.endsWith("\u62d3\u5c55.json")) {
                String expandProperties = context.getPayloadAsString(fileName);
                expandTable.add(expandProperties);
            }
            if (fileName.endsWith("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                map = (HashMap<String, String>)fileMap.get(workflowDumpVo.getProcessKey());
                if (map == null) {
                    map = new HashMap<String, String>();
                    fileMap.put(workflowDumpVo.getProcessKey(), map);
                }
                String lcdpbpm = context.getPayloadAsString(fileName);
                map.put("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", lcdpbpm);
            }
            if (fileName.endsWith("bpmn20.xml")) {
                map = (Map)fileMap.get(workflowDumpVo.getProcessKey());
                if (map == null) {
                    map = new HashMap();
                    fileMap.put(workflowDumpVo.getProcessKey(), map);
                }
                String xml = context.getPayloadAsString(fileName);
                map.put("bpmn20.xml", xml);
            }
            if (fileName.endsWith("\u64cd\u4f5c\u6743\u9650.json")) {
                String handleAuth = context.getPayloadAsString(fileName);
                handleAuthTable.add(handleAuth);
            }
            if (fileName.endsWith("\u540e\u7f6e\u52a8\u4f5c\u6587\u4ef6.json")) {
                String postAction = context.getPayloadAsString(fileName);
                postActionTable.add(postAction);
            }
            if (fileName.endsWith("\u6284\u9001\u914d\u7f6e\u6587\u4ef6.json")) {
                String ccTaskConfig = context.getPayloadAsString(fileName);
                ccTaskConfigTable.add(ccTaskConfig);
            }
            if (fileName.endsWith("\u5907\u9009\u8282\u70b9\u6587\u4ef6.json")) {
                String alternativeTask = context.getPayloadAsString(fileName);
                alternativeTaskTable.add(alternativeTask);
            }
            if (fileName.endsWith("\u8fd4\u56de\u6574\u6539\u8868\u5355\u6587\u4ef6.json")) {
                String formData = context.getPayloadAsString(fileName);
                formDataTable.add(formData);
            }
            if (fileName.endsWith("\u8fd4\u56de\u6574\u6539\u914d\u7f6e\u6587\u4ef6.json")) {
                String returnToRectification = context.getPayloadAsString(fileName);
                returnToRectificationTable.add(returnToRectification);
            }
            if (fileName.endsWith("\u8fd4\u56de\u6574\u6539\u52a8\u4f5c\u6587\u4ef6.json")) {
                String rectificationAction = context.getPayloadAsString(fileName);
                rectificationActionTable.add(rectificationAction);
            }
            if (fileName.endsWith("\u4e1a\u52a1\u6a21\u5757\u6587\u4ef6.json")) {
                businessModule = context.getPayloadAsString(fileName);
                businessModuleTable.add(businessModule);
            }
            if (fileName.endsWith("\u4e1a\u52a1\u6a21\u5757\u6587\u4ef6.json")) {
                businessModule = context.getPayloadAsString(fileName);
                businessModuleTable.add(businessModule);
            }
            if (fileName.endsWith("\u6d41\u7a0b\u5206\u7ec4\u6587\u4ef6.json")) {
                String processGroup = context.getPayloadAsString(fileName);
                procGroupTable.add(processGroup);
            }
            if (fileName.endsWith("\u6d41\u7a0b\u90e8\u95e8\u6587\u4ef6.json")) {
                String processDept = context.getPayloadAsString(fileName);
                processDeptTable.add(processDept);
            }
            if (!fileName.endsWith("\u6d41\u7a0b\u5b9a\u4e49\u6587\u4ef6.json")) continue;
            String processDefinition = context.getPayloadAsString(fileName);
            processDefinitionTable.add(processDefinition);
        }
        WorkflowLoadDto workflowLoadDto = new WorkflowLoadDto();
        workflowLoadDto.setAssigneeMsgs(assigneeTable);
        workflowLoadDto.setExpandMsgs(expandTable);
        workflowLoadDto.setFormAuthMsgs(formAuthTable);
        workflowLoadDto.setHandleAuthMsgs(handleAuthTable);
        workflowLoadDto.setImportMsgMap(importTypeMap);
        workflowLoadDto.setWorkflowFiles(fileMap);
        workflowLoadDto.setImportMsgs(workflowMigrationPreloadVos);
        workflowLoadDto.setServiceNameMap(serviceNameMap);
        workflowLoadDto.setPostActionMsgs(postActionTable);
        workflowLoadDto.setCcTaskConfigMsgs(ccTaskConfigTable);
        workflowLoadDto.setAlternativeTaskMsgs(alternativeTaskTable);
        workflowLoadDto.setFormDataMsgs(formDataTable);
        workflowLoadDto.setReturnToRectificationMsgs(returnToRectificationTable);
        workflowLoadDto.setRectificationActionMsgs(rectificationActionTable);
        workflowLoadDto.setBusinessModuleMsgs(businessModuleTable);
        workflowLoadDto.setProcessGroupMsgs(procGroupTable);
        workflowLoadDto.setProcessDeptMsgs(processDeptTable);
        workflowLoadDto.setProcessDefinitionMsgs(processDefinitionTable);
        List list = WorkflowMigrationService.load((WorkflowLoadDto)workflowLoadDto);
        return MigrationLoadItemVo.success((Long)count, (Object)list);
    }

    private static final class Metadata
    implements MigrationPluginMetadata {
        public static final Metadata INSTANCE = new Metadata();

        private Metadata() {
        }

        public String getServiceType() {
            return WorkflowMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return VERSION;
        }

        public int getDumpPrecedence() {
            return 0;
        }
    }
}

