/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequestType;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.GetTokenUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Integer MAX_REPEAT = 5;
    private static Integer REPEAT_COUNT = 0;

    public static HashMap<String, String> buildHeaderMap(String clientToken, String tcode) {
        String clientId;
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("Authorization", clientToken);
        if (tcode != null) {
            headerMap.put("tcode", tcode);
        }
        if ((clientId = GetTokenUtil.getClientId()) != null) {
            headerMap.put("client-id", clientId);
        }
        return headerMap;
    }

    public static String httpPost(String url, Map<String, String> headers) {
        return HttpClientUtil.request(url, RmiApiRequestType.POST, null, null, headers);
    }

    public static String httpPost(String url, String params, Map<String, String> headers) {
        return HttpClientUtil.request(url, RmiApiRequestType.POST, params, null, headers);
    }

    public static BpmResponseResult httpGetBpmHandler(String url, Map<String, Object> params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return InstallResult.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpGet(GetTokenUtil.getServer() + url, params, HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpGetBpmHandler(url, params);
        }
        REPEAT_COUNT = 0;
        return HttpClientUtil.convertResponse(result);
    }

    public static BpmResponseResult httpPostBpmHandler(String url, Object params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return InstallResult.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpPost(GetTokenUtil.getServer() + url, params == null ? null : (params instanceof String ? (String)params : JSONObject.toJSONString((Object)params)), HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpPostBpmHandler(url, params);
        }
        REPEAT_COUNT = 0;
        return HttpClientUtil.convertResponse(result);
    }

    public static <T> ApiResponse<T> httpGetApiHandler(String url, Map<String, Object> params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return ApiResponse.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpGet(GetTokenUtil.getServer() + url, params, HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return ApiResponse.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if (result.startsWith("[")) {
            ApiResponse apiResponse = ApiResponse.success((Object)JSONArray.parseArray((String)result));
            return apiResponse;
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpGetApiHandler(url, params);
        }
        REPEAT_COUNT = 0;
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        return (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
    }

    public static ApiResponse<?> httpPostApiHandler(String url, Object params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return ApiResponse.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpPost(GetTokenUtil.getServer() + url, params == null ? null : (params instanceof String ? (String)params : JSONObject.toJSONString((Object)params)), HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return ApiResponse.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpPostApiHandler(url, params);
        }
        REPEAT_COUNT = 0;
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        return (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
    }

    private static BpmResponseResult convertResponse(String result) {
        if (result == null) {
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        if (JSONObject.parseObject((String)result).containsKey((Object)"result")) {
            return (BpmResponseResult)JSONObject.parseObject((String)result, BpmResponseResult.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        }
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        if (apiResponse.isSuccess()) {
            JSONArray jsonArray = new JSONArray();
            Object data = apiResponse.getData();
            if (data instanceof Page) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)((Page)data).getRecords());
                jsonObject.put("count", (Object)((Page)data).getTotal());
                jsonArray.add((Object)jsonObject);
            } else {
                jsonArray.add(data);
            }
            return InstallResult.success((JSONArray)jsonArray);
        }
        return InstallResult.fail((String)apiResponse.getMsg());
    }

    public static String httpGet(String url, Map params, Map<String, String> headers) {
        return HttpClientUtil.request(url, RmiApiRequestType.GET, null, params, headers);
    }

    private static String request(String url, RmiApiRequestType type, String body, Map params, Map<String, String> headers) {
        RmiApiRequest request = RmiApi.request(String.class).url(url).type(type);
        request.setConnectTimeout(GetTokenUtil.getConnectionTimeOut()).setReadTimeout(GetTokenUtil.getReadTimeOut());
        if (RmiApiRequestType.POST.equals((Object)type)) {
            if (body != null) {
                request.addBody(body);
            }
        } else if (params != null) {
            request.addQuery(params, true, "utf-8");
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HashSet<String> keySet = new HashSet<String>(headers.keySet());
        for (String key : keySet) {
            if (headers.get(key) != null) continue;
            headers.remove(key);
        }
        headers.put("Content-Type", "application/json");
        request.addHeader(headers);
        return (String)request.execute(String.class);
    }
}

