/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.base.service;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.http.service.WorkflowHttpPluginService;
import com.jxdinfo.hussar.workflow.manage.properties.BpmPluginProperties;
import com.jxdinfo.hussar.workflow.manage.util.BpmPluginUtil;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class WorkflowHttpPluginServiceImpl
implements WorkflowHttpPluginService {
    @Autowired
    private BpmPluginProperties bpmPluginProperties;
    @Autowired(required=false)
    @Lazy
    private PluginUser pluginUser;

    public <T> T getPluginBean(Long appId, String beanId, String appCode) {
        if (!this.bpmPluginProperties.isEnable()) {
            return null;
        }
        if (this.pluginUser == null) {
            this.pluginUser = (PluginUser)BpmSpringContextHolder.getBean(PluginUser.class);
        }
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        if (HussarUtils.isNotEmpty((Object)appCode)) {
            tcode = BpmPluginUtil.asIdentifier((String)tcode);
            appCode = BpmPluginUtil.asIdentifier((String)appCode);
            String pluginId = tcode + "-" + appCode;
            Object t = this.pluginUser.getPluginBeans(pluginId, beanId);
            if (t != null) {
                return (T)t;
            }
        }
        return (T)this.pluginUser.getBean(beanId);
    }
}

