/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowCompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.HtszTaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.manage.engine.service.HtszTaskEngineApiService;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class BpmQueryCompleteEngineOpenApiService
implements HtszTaskEngineApiService {
    public BpmResponseResult doneNonCompleteList(FlowCompleteTaskDto flowCompleteTaskDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/queryComplete/doneNonCompleteList", this.getFlowTaskMap(flowCompleteTaskDto));
    }

    public BpmResponseResult masterDoneNonCompleteList(FlowCompleteTaskDto flowTaskDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/queryComplete/masterDoneNonCompleteList", this.getFlowTaskMap(flowTaskDto));
    }

    public BpmResponseResult completeList(FlowCompleteTaskDto flowCompleteTaskDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/queryComplete/completeList", this.getFlowTaskMap(flowCompleteTaskDto));
    }

    public BpmResponseResult masterCompleteList(FlowCompleteTaskDto flowTaskDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/queryComplete/masterCompleteList", this.getFlowTaskMap(flowTaskDto));
    }

    public BpmResponseResult queryNextNodeAllAssigneeByLineCondition(String processDefinitionKey, String taskId, Map<String, Object> lineCondition) {
        TaskQueryNextNodeDto taskQueryNextNodeDto = new TaskQueryNextNodeDto();
        taskQueryNextNodeDto.setTaskId(taskId);
        taskQueryNextNodeDto.setProcessKey(processDefinitionKey);
        taskQueryNextNodeDto.setIsGetRevokeNode(false);
        taskQueryNextNodeDto.setIsGetWithGroup(false);
        taskQueryNextNodeDto.setLineCondition(JSONObject.toJSONString(lineCondition));
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/htszTask/queryNextNodeAllAssigneeByLineCondition", (Object)taskQueryNextNodeDto);
    }

    public BpmResponseResult queryNextAssigneeAndDeptByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        HtszTaskQueryNextNodeDto htszTaskQueryNextNodeDto = new HtszTaskQueryNextNodeDto();
        htszTaskQueryNextNodeDto.setTaskId(taskId);
        htszTaskQueryNextNodeDto.setProcessKey(processDefinitionKey);
        htszTaskQueryNextNodeDto.setUserId(userId);
        htszTaskQueryNextNodeDto.setNodeId(nodeId);
        htszTaskQueryNextNodeDto.setMap(JSONObject.toJSONString(map));
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/htszTask/queryNextNodeAllAssigneeByLineCondition", (Object)htszTaskQueryNextNodeDto);
    }

    private Map<String, Object> getFlowTaskMap(FlowCompleteTaskDto flowTaskDto) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", flowTaskDto.getUserId());
        map.put("processKey", flowTaskDto.getProcessKey());
        map.put("definitionKey", flowTaskDto.getDefinitionKey());
        map.put("processKeys", flowTaskDto.getProcessKeys());
        map.put("businessIds", flowTaskDto.getBusinessIds());
        map.put("todoConfiguration", flowTaskDto.getTodoConfiguration());
        map.put("sendUserId", flowTaskDto.getSendUserId());
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getStartTime())) {
            map.put("startTime", dataFormat.format(flowTaskDto.getStartTime()));
        }
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getEndTime())) {
            map.put("endTime", dataFormat.format(flowTaskDto.getEndTime()));
        }
        map.put("page", flowTaskDto.getPage());
        map.put("size", flowTaskDto.getSize());
        map.put("tenantId", flowTaskDto.getTenantId());
        map.put("mandator", flowTaskDto.getMandator());
        map.put("taskState", flowTaskDto.getTaskState());
        map.put("taskType", flowTaskDto.getTaskType());
        map.put("assistInitiator", flowTaskDto.getAssistInitiator());
        map.put("type", flowTaskDto.getType());
        map.put("serverCode", flowTaskDto.getServerCode());
        return map;
    }

    public static final class Api {
        public static final String doneNonCompleteList = "/bpm/queryComplete/doneNonCompleteList";
        public static final String masterDoneNonCompleteList = "/bpm/queryComplete/masterDoneNonCompleteList";
        public static final String completeList = "/bpm/queryComplete/completeList";
        public static final String masterCompleteList = "/bpm/queryComplete/masterCompleteList";
        public static final String queryNextNodeAllAssigneeByLineCondition = "/bpm/htszTask/queryNextNodeAllAssigneeByLineCondition";
    }
}

