/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.http.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.VariableApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListByPageDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.ProcessInstModel;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartSubProcessDto;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RestVariableWorkflowTestApiService
implements VariableApiService {
    public ApiResponse<?> getAllVariablesConfiguredInMainProcess(String processKey, String processVersion, String organId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("processVersion", processVersion);
        map.put("organId", organId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/variable/getAllVariablesConfiguredInMainProcess", map);
    }

    public ApiResponse<?> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/variable/getAllVariablesConfiguredInSubProcessAndBindingInfo", (Object)configuredInstanceVariableQuery);
    }

    public ApiResponse<?> getProcessBetaList(Page<ProcessInstModel> page, ProcessListDto processListDto) {
        ProcessListByPageDto processListByPage = new ProcessListByPageDto(processListDto, page);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessBetaList", (Object)processListByPage);
    }

    public ApiResponse<?> list(FlowChartCommonDto flowChartCommonDto) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/list", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessInfoForProcessTesting", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessCompleteInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getSubProcessRunningInfoForProcessTesting", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getSubProcessRunningInfo(String processInsId, String businessId) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getSubProcessRunningInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        FlowChartSubProcessDto flowChartSubProcessDto = new FlowChartSubProcessDto();
        flowChartSubProcessDto.setSupProcessInsId(supProcessInsId);
        flowChartSubProcessDto.setBusinessId(businessId);
        flowChartSubProcessDto.setTaskDefinitionKey(taskDefinitionKey);
        flowChartSubProcessDto.setPage(page);
        flowChartSubProcessDto.setSize(size);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/subProcessList", (Object)flowChartSubProcessDto);
    }

    public ApiResponse<?> deleteFinishedProcessInstance(String processInstCode) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/deleteFinishedProcessInstance", (Object)processInstCode);
    }

    public ApiResponse<?> deleteProcessInstance(List<String> processInsIdList) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/deleteProcessById", processInsIdList);
    }

    public ApiResponse<?> findVariableById(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/variable/findVariableById", map);
    }

    private static final class Api {
        public static final String GET_ALL_VARIABLES_CONFIGURED_IN_MAIN_PROCESS = "/bpm/variable/getAllVariablesConfiguredInMainProcess";
        public static final String GET_ALL_VARIABLES_CONFIGURED_IN_SUB_PROCESS_AND_BINDING_INFO = "/bpm/variable/getAllVariablesConfiguredInSubProcessAndBindingInfo";
        public static final String GET_PROCESS_BETA_LIST = "/bpm/records/getProcessBetaList";
        public static final String LIST = "/bpm/records/list";
        public static final String GET_PROCESS_INFO_FOR_PROCESS_TESTING = "/bpm/records/getProcessInfoForProcessTesting";
        public static final String GET_PROCESS_INFO = "/bpm/records/getProcessInfo";
        public static final String GET_PROCESS_COMPLETE_INFO = "/bpm/records/getProcessCompleteInfo";
        public static final String GET_SUB_PROCESS_RUNNING_INFO_FOR_PROCESS_TESTING = "/bpm/records/getSubProcessRunningInfoForProcessTesting";
        public static final String GET_SUBPROCESS_RUNNING_INFO = "/bpm/records/getSubProcessRunningInfo";
        public static final String SUB_PROCESS_LIST = "/bpm/records/subProcessList";
        public static final String DELETE_FINISHED_PROCESS_INSTANCE = "/bpm/records/deleteFinishedProcessInstance";
        public static final String DELETE_PROCESS_INSTANCE = "/bpm/records/deleteProcessById";
        public static final String FIND_VARIABLE_BY_ID = "/bpm/variable/findVariableById";

        private Api() {
        }
    }
}

