/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.http.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.VariableApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListByPageDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.ProcessInstModel;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartSubProcessDto;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RestVariableWorkflowTestApiService
implements VariableApiService {
    public ApiResponse<?> getAllVariablesConfiguredInMainProcess(String processKey, String processVersion, String organId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("processVersion", processVersion);
        map.put("organId", organId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/variable/getAllVariablesConfiguredInMainProcess", map);
    }

    public ApiResponse<?> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/variable/getAllVariablesConfiguredInSubProcessAndBindingInfo", (Object)configuredInstanceVariableQuery);
    }

    public ApiResponse<?> getProcessBetaList(Page<ProcessInstModel> page, ProcessListDto processListDto) {
        ProcessListByPageDto processListByPage = new ProcessListByPageDto(processListDto, page);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessBetaList", (Object)processListByPage);
    }

    public ApiResponse<?> list(FlowChartCommonDto flowChartCommonDto) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/list", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessInfoForProcessTesting", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        flowChartCommonDto.setSubProcessKey(subProcessKey);
        flowChartCommonDto.setCycleCount(cycleCount);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getProcessCompleteInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getSubProcessRunningInfoForProcessTesting", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> getSubProcessRunningInfo(String processInsId, String businessId) {
        FlowChartCommonDto flowChartCommonDto = new FlowChartCommonDto();
        flowChartCommonDto.setProcessInsId(processInsId);
        flowChartCommonDto.setBusinessId(businessId);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/getSubProcessRunningInfo", (Object)flowChartCommonDto);
    }

    public ApiResponse<?> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        FlowChartSubProcessDto flowChartSubProcessDto = new FlowChartSubProcessDto();
        flowChartSubProcessDto.setSupProcessInsId(supProcessInsId);
        flowChartSubProcessDto.setBusinessId(businessId);
        flowChartSubProcessDto.setTaskDefinitionKey(taskDefinitionKey);
        flowChartSubProcessDto.setPage(page);
        flowChartSubProcessDto.setSize(size);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/subProcessList", (Object)flowChartSubProcessDto);
    }

    public ApiResponse<?> deleteFinishedProcessInstance(String processInstCode) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/deleteFinishedProcessInstance", (Object)processInstCode);
    }

    public ApiResponse<?> deleteProcessInstance(List<String> processInsIdList) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/records/deleteProcessById", processInsIdList);
    }

    public ApiResponse<?> findVariableById(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/variable/findVariableById", map);
    }

    private static final class Api {
        public static final String getAllVariablesConfiguredInMainProcess = "/bpm/variable/getAllVariablesConfiguredInMainProcess";
        public static final String getAllVariablesConfiguredInSubProcessAndBindingInfo = "/bpm/variable/getAllVariablesConfiguredInSubProcessAndBindingInfo";
        public static final String getProcessBetaList = "/bpm/records/getProcessBetaList";
        public static final String list = "/bpm/records/list";
        public static final String getProcessInfoForProcessTesting = "/bpm/records/getProcessInfoForProcessTesting";
        public static final String getProcessInfo = "/bpm/records/getProcessInfo";
        public static final String getProcessCompleteInfo = "/bpm/records/getProcessCompleteInfo";
        public static final String getSubProcessRunningInfoForProcessTesting = "/bpm/records/getSubProcessRunningInfoForProcessTesting";
        public static final String getSubProcessRunningInfo = "/bpm/records/getSubProcessRunningInfo";
        public static final String subProcessList = "/bpm/records/subProcessList";
        public static final String deleteFinishedProcessInstance = "/bpm/records/deleteFinishedProcessInstance";
        public static final String deleteProcessInstance = "/bpm/records/deleteProcessById";
        public static final String findVariableById = "/bpm/variable/findVariableById";

        private Api() {
        }
    }
}

