/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.service.impl;

import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.SqlListOutService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.vo.DataSetTierTable;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.godaxe.customsql.GodAxeCustomSqlService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GodAxeCustomSqlServiceImpl
implements GodAxeCustomSqlService {
    private static final Logger logger = LogManager.getLogger(GodAxeCustomSqlServiceImpl.class);
    private static final Pattern UPDATE_SQL_REGEX = Pattern.compile("[^'\"]\\b(CREATE|INSERT|DELETE|UPDATE|DROP|ALTER|TRUNCATE|RENAME|GRANT|REVOKE|COMMIT|ROLLBACK|BEGIN TRANSACTION|SAVEPOINT)\\b[^'\"]");
    @Autowired(required=false)
    private SysDataSourceService sysDataSourceService;
    @Autowired(required=false)
    private SqlListOutService sqlListOutService;

    public ApiResponse<List<DataSetTierTable>> sqlList(Long id, String type) throws Exception {
        if (this.sqlListOutService == null) {
            logger.error("SqlListOutService\u672a\u6ce8\u5165\uff0c\u67e5\u8be2\u8868\u4fe1\u606f\u5931\u8d25");
            return ApiResponse.success(new ArrayList());
        }
        return ApiResponse.success((Object)this.sqlListOutService.sqlList(id, type));
    }

    public ApiResponse<String> checkSql(String sql) {
        String tableSection;
        Pattern fromPattern;
        Matcher fromMatcher;
        Pattern pattern;
        Matcher matcher;
        boolean isSqlError;
        String upperSql = sql.toUpperCase();
        Matcher updateMatcher = UPDATE_SQL_REGEX.matcher(" " + upperSql + " ");
        boolean bl = isSqlError = updateMatcher.find() || sql.contains(";");
        if (isSqlError) {
            return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u4f7f\u7528\u975e\u67e5\u8be2\u7c7b\u8bed\u53e5\u6216\u5206\u53f7");
        }
        if (HussarUtils.isNotEmpty((Object)sql)) {
            if (!(upperSql.contains("SELECT") && upperSql.contains("FROM") && upperSql.contains("WHERE"))) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7f3a\u5c11\u5fc5\u8981\u7684\u5173\u952e\u5b57");
            }
            if (upperSql.contains("@") || upperSql.contains(" AS ")) {
                return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
            }
        }
        if ((matcher = (pattern = Pattern.compile("SELECT(.*?)FROM")).matcher(upperSql)).find()) {
            String columnsSection = matcher.group(1).trim();
            if (columnsSection.contains("*")) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u4f7f\u7528 *");
            }
            if (columnsSection.contains(",") || columnsSection.contains("\uff0c")) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u6267\u884c\u67e5\u8be2\u591a\u5217\u7684SQL\u8bed\u53e5");
            }
            if (columnsSection.contains("$")) {
                return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
            }
        }
        if ((fromMatcher = (fromPattern = Pattern.compile("FROM(.*?)WHERE")).matcher(upperSql)).find() && (tableSection = fromMatcher.group(1).trim()).contains("$")) {
            return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysDataSource>> getAllDataSource() {
        if (this.sysDataSourceService == null) {
            logger.error("SysDataSourceService\u672a\u6ce8\u5165\uff0c\u67e5\u8be2\u6570\u636e\u6e90\u5931\u8d25");
            ApiResponse.success(new ArrayList());
        }
        return ApiResponse.success((Object)this.sysDataSourceService.getAllDataSource());
    }
}

