/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.upgrade;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CustomNodeAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.EntrustTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextUserTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRestartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.QueryProcessTaskCountDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.RejectNodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SecurityUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.StarterUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAddAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCommentEditDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskDelAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEditCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryRejectNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReStartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskUpdateLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskUpdateStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.AssigneeConditionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteAddCustomNodeService;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteTaskEngineService;
import com.jxdinfo.hussar.workflow.manage.util.TypeConvertUtils;
import com.jxdinfo.hussar.workflow.upgrade.StandardTaskEngineApiService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardRemoteTaskEngineApiService
implements StandardTaskEngineApiService {
    @Autowired
    private RemoteTaskEngineService remoteTaskEngineService;
    @Autowired
    private RemoteAddCustomNodeService remoteAddCustomNodeService;

    public BpmResponseResult queryProcessTask(String taskId) {
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        taskQueryDto.setTaskId(taskId);
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteTaskEngineService.queryTask(taskQueryDto));
    }

    public BpmResponseResult queryUserProcessTaskCount(String userId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteTaskEngineService.queryUserTaskCount(userId));
    }

    public BpmResponseResult queryUserProcessTaskCountByNode(String userId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteTaskEngineService.queryUserTaskCountByNode(userId));
    }

    public BpmResponseResult queryToDoList(FlowTaskDto flowTaskDto) {
        return this.remoteTaskEngineService.queryToDoList(flowTaskDto);
    }

    public BpmResponseResult queryDoneList(FlowTaskDto flowTaskDto) {
        return this.remoteTaskEngineService.queryDoneList(flowTaskDto);
    }

    public BpmResponseResult completeTask(CompleteTaskDto completeTaskDto) {
        return this.remoteTaskEngineService.completeTask(completeTaskDto);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        return this.remoteTaskEngineService.queryRejectComment(taskId);
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
            taskRejectDto.setAuditAuthority(true);
        }
        return this.remoteTaskEngineService.rejectToLastTask(taskRejectDto);
    }

    public BpmResponseResult getRejectNode(RejectNodeQueryDto nodeQueryDto) {
        TaskRejectDto taskRejectDto = new TaskRejectDto();
        taskRejectDto.setTaskId(nodeQueryDto.getTaskId());
        taskRejectDto.setIsSubmit(nodeQueryDto.getIsSubmit());
        taskRejectDto.setMap(JSON.toJSONString((Object)nodeQueryDto.getMap()));
        return this.remoteTaskEngineService.getRejectNode(taskRejectDto);
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
        }
        return this.remoteTaskEngineService.rejectToFirstTask(taskRejectDto);
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
        }
        return this.remoteTaskEngineService.rejectToAnyTask(taskRejectDto);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean isGetMainProcess) {
        TaskQueryRejectNodeDto taskQueryRejectNodeDto = new TaskQueryRejectNodeDto(taskId, isGetMainProcess);
        return this.remoteTaskEngineService.queryRejectNode(taskQueryRejectNodeDto);
    }

    public BpmResponseResult queryJumpNode(String taskId, boolean isGetMainProcess) {
        TaskQueryRejectNodeDto taskQueryRejectNodeDto = new TaskQueryRejectNodeDto(taskId, isGetMainProcess);
        return this.remoteTaskEngineService.queryJumpNode(taskQueryRejectNodeDto);
    }

    public BpmResponseResult entrustTask(EntrustTaskDto entrustTaskDto) {
        TaskEntrustDto taskEntrustDto = new TaskEntrustDto();
        HussarUtils.copy((Object)entrustTaskDto, (Object)taskEntrustDto);
        return this.remoteTaskEngineService.entrustTask(taskEntrustDto);
    }

    public BpmResponseResult freeJump(TaskFreeJumpDto taskFreeJumpDto) {
        return this.remoteTaskEngineService.freeJump2(taskFreeJumpDto);
    }

    public BpmResponseResult multiInstanceAddAssignee(TaskAssigneeDto taskAssigneeDto) {
        TaskAddAssigneeDto taskAddAssigneeDto = new TaskAddAssigneeDto();
        taskAddAssigneeDto.setTaskId(taskAssigneeDto.getTaskId());
        taskAddAssigneeDto.setAssigneeList(StringUtil.join((Collection)taskAssigneeDto.getAssignees(), (String)","));
        taskAddAssigneeDto.setUserId(taskAssigneeDto.getUserId());
        taskAddAssigneeDto.setComment(taskAssigneeDto.getComment());
        taskAddAssigneeDto.setParamMap(taskAssigneeDto.getParamMap());
        return this.remoteTaskEngineService.multiInstanceAddAssignee(taskAddAssigneeDto);
    }

    public BpmResponseResult multiInstanceDelAssignee(TaskAssigneeDto taskAssigneeDto) {
        TaskDelAssigneeDto taskDelAssigneeDto = new TaskDelAssigneeDto();
        taskDelAssigneeDto.setTaskId(taskAssigneeDto.getTaskId());
        taskDelAssigneeDto.setAssignees(StringUtil.join((Collection)taskAssigneeDto.getAssignees(), (String)","));
        taskDelAssigneeDto.setUserId(taskAssigneeDto.getUserId());
        taskDelAssigneeDto.setComment(taskAssigneeDto.getComment());
        taskDelAssigneeDto.setParamMap(taskAssigneeDto.getParamMap());
        return this.remoteTaskEngineService.multiInstanceDelAssignee(taskDelAssigneeDto);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return this.remoteTaskEngineService.queryAssigneeByTaskId(taskId);
    }

    public BpmResponseResult taskAddAssignee(TaskAddAssigneeDto taskAssigneeDto) {
        return this.remoteTaskEngineService.taskAddAssignee(taskAssigneeDto);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return this.remoteTaskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public BpmResponseResult queryNextAssignee(NextAssigneeQueryDto nextAssigneeQueryDto) {
        if (nextAssigneeQueryDto.getPage() != null) {
            nextAssigneeQueryDto.setRemotePage(true);
        }
        return this.remoteTaskEngineService.queryNextAssignee(nextAssigneeQueryDto);
    }

    public BpmResponseResult queryAssignee(AssigneeConditionDto assigneeQueryDto) {
        return this.remoteTaskEngineService.queryAllAssignee(assigneeQueryDto);
    }

    public BpmResponseResult queryHistoryNodeInfo(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteTaskEngineService.queryHistoryActByTaskId(taskId));
    }

    public BpmResponseResult queryProcessDefIdAndTaskDefKey(TaskDefQueryDto taskDefQueryDto) {
        return this.remoteTaskEngineService.queryProcessDefIdAndTaskDefKey(taskDefQueryDto);
    }

    public BpmResponseResult queryCurrentNodeInfo(NodeQueryDto nodeQueryDto) {
        return this.remoteTaskEngineService.queryTaskByBusinessIdAndProcessInsId(nodeQueryDto.getBusinessId(), nodeQueryDto.getProcessInstId());
    }

    public BpmResponseResult queryNextUserTask(NextUserTaskQueryDto nextUserTaskQueryDto) {
        TaskQueryNextNodeDto taskQueryNextNodeDto = new TaskQueryNextNodeDto();
        HussarUtils.copy((Object)nextUserTaskQueryDto, (Object)taskQueryNextNodeDto);
        taskQueryNextNodeDto.setLineCondition(JSON.toJSONString((Object)nextUserTaskQueryDto.getLineCondition()));
        return this.remoteTaskEngineService.queryNextNode(taskQueryNextNodeDto);
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        return this.remoteTaskEngineService.withdrawState(historicTaskId);
    }

    public BpmResponseResult revokeTask(TaskRevokeDto taskRevokeDto) {
        return this.remoteTaskEngineService.revokeTask(taskRevokeDto);
    }

    public BpmResponseResult editTaskComment(TaskCommentEditDto taskCommentEditDto) {
        TaskEditCommentDto taskEditCommentDto = new TaskEditCommentDto();
        HussarUtils.copy((Object)taskCommentEditDto, (Object)taskEditCommentDto);
        return this.remoteTaskEngineService.editTaskComment(taskEditCommentDto);
    }

    public BpmResponseResult reStartProcess(ProcessRestartDto processRestartDto) {
        TaskReStartProcessDto taskReStartProcessDto = new TaskReStartProcessDto();
        HussarUtils.copy((Object)processRestartDto, (Object)taskReStartProcessDto);
        taskReStartProcessDto.setMap(JSON.toJSONString((Object)processRestartDto.getMap()));
        return this.remoteTaskEngineService.reStartProcess(taskReStartProcessDto);
    }

    public BpmResponseResult addCustomNode(CustomNodeAddDto customNodeAddDto) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteAddCustomNodeService.addCustomNode(customNodeAddDto.getTaskId(), JSON.toJSONString((Object)customNodeAddDto.getList()), customNodeAddDto.getParallel()));
    }

    public BpmResponseResult canParallelAddNode(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteAddCustomNodeService.isAddParallel(taskId));
    }

    public BpmResponseResult canAddCustomNode(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.remoteAddCustomNodeService.isAddCustomNode(taskId));
    }

    public BpmResponseResult updateUserSecurityLevel(SecurityUpdateDto securityUpdateDto) {
        TaskUpdateLevelDto taskUpdateLevelDto = new TaskUpdateLevelDto();
        HussarUtils.copy((Object)securityUpdateDto, (Object)taskUpdateLevelDto);
        return this.remoteTaskEngineService.updateUserSecurityLevel(taskUpdateLevelDto);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        return this.remoteTaskEngineService.activeTaskCandidates(taskId);
    }

    public BpmResponseResult updateStarter(StarterUpdateDto starterUpdateDto) {
        TaskUpdateStarterDto taskUpdateStarterDto = new TaskUpdateStarterDto();
        HussarUtils.copy((Object)starterUpdateDto, (Object)taskUpdateStarterDto);
        return this.remoteTaskEngineService.updateStarter(taskUpdateStarterDto);
    }

    public BpmResponseResult queryReceiveExecution(String businessId) {
        return this.remoteTaskEngineService.getExecutionByBusinessId(businessId);
    }

    public BpmResponseResult receiveTaskSignal(TaskReceiveDto taskReceiveDto) {
        return this.remoteTaskEngineService.receiveTaskSignal(taskReceiveDto);
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        return this.remoteTaskEngineService.preemptTask(preemptCommonDto);
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        return this.remoteTaskEngineService.unPreemptTask(preemptCommonDto);
    }

    public BpmResponseResult checkNextNodeAssignee(CheckNextNodeAssigneeDto checkNextNodeAssigneeDto) {
        return this.remoteTaskEngineService.checkNextNodeAssignee(checkNextNodeAssigneeDto);
    }

    public BpmResponseResult setTimeout(String taskId, String timeout) {
        return this.remoteTaskEngineService.setTimeoutPeriod(taskId, timeout);
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        return this.remoteTaskEngineService.transferTask(transferDto);
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        return this.remoteTaskEngineService.getTransferProgressInfo(transferId);
    }

    public BpmResponseResult queryProcessTaskCount(QueryProcessTaskCountDto queryProcessTaskCountDto) {
        return this.remoteTaskEngineService.queryProcessTaskCount(queryProcessTaskCountDto);
    }

    public BpmResponseResult querySubmitToRejectNode(String taskId) {
        return this.remoteTaskEngineService.querySubmitToRejectNode(taskId);
    }

    public BpmResponseResult queryAddAssignee(String processInstanceId, String taskDefinitionKey, String taskId, String userId) {
        return this.remoteTaskEngineService.queryAddAssignee(processInstanceId, taskDefinitionKey, taskId, userId);
    }
}

