/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.EditPrcessTileDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceDeleteByBusinessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceByBusinessKeyDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryActivityTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryFinishedDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceStartByIdDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceStartByKeyDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessInstAllQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.BusinessInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteInstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteInstanceEngineApiServiceImpl
implements InstanceEngineApiService {
    @Autowired
    private RemoteInstanceEngineService remoteInstanceEngineService;

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        InstanceStartByIdDto instanceStartByIdDto = new InstanceStartByIdDto();
        instanceStartByIdDto.setProcessDefinitionId(processDefinitionId);
        instanceStartByIdDto.setUserId(userId);
        instanceStartByIdDto.setBusinessId(businessId);
        instanceStartByIdDto.setVariables(JSON.toJSONString(variables));
        return this.remoteInstanceEngineService.startProcessInstanceById(instanceStartByIdDto);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        InstanceStartByKeyDto instanceStartByKeyDto = new InstanceStartByKeyDto();
        instanceStartByKeyDto.setProcessKey(processKey);
        instanceStartByKeyDto.setUserId(userId);
        instanceStartByKeyDto.setBusinessId(businessId);
        instanceStartByKeyDto.setVariables(JSON.toJSONString(variables));
        return this.remoteInstanceEngineService.startProcessInstanceByKey(instanceStartByKeyDto);
    }

    public BpmResponseResult startProcessInstanceByKey(StartProcessDto startProcessDto) {
        InstanceStartByKeyDto instanceStartByKeyDto = new InstanceStartByKeyDto();
        instanceStartByKeyDto.setProcessKey(startProcessDto.getProcessKey());
        instanceStartByKeyDto.setUserId(startProcessDto.getUserId());
        instanceStartByKeyDto.setBusinessId(startProcessDto.getBusinessId());
        instanceStartByKeyDto.setVariables(JSON.toJSONString((Object)startProcessDto.getVariables()));
        instanceStartByKeyDto.setProcessTitle(startProcessDto.getProcessTitle());
        instanceStartByKeyDto.setDataDetail(startProcessDto.getDataDetail());
        return this.remoteInstanceEngineService.startProcessInstanceByKey(instanceStartByKeyDto);
    }

    public BpmResponseResult startAndComplete(StartAndCompleteDto startAndCompleteDto) {
        return this.remoteInstanceEngineService.startAndComplete(startAndCompleteDto);
    }

    public BpmResponseResult updateBusinessInfo(BusinessInfoDto businessInfoDto) {
        return this.remoteInstanceEngineService.updateBusinessInfo(businessInfoDto);
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        return this.remoteInstanceEngineService.checkProcessInstByBusinessId(businessId);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        return this.remoteInstanceEngineService.validateEditAuthority(businessId);
    }

    public BpmResponseResult validateDeleteByBusinessKey(String businessId) {
        return this.remoteInstanceEngineService.validateDeleteByBusinessId(businessId);
    }

    public BpmResponseResult queryAllComment(String businessId) {
        return this.remoteInstanceEngineService.queryAllCommentByBusinessId(businessId);
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        return this.remoteInstanceEngineService.suspendProcessInstanceById(processInsId);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        return this.remoteInstanceEngineService.suspendProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        return this.remoteInstanceEngineService.activateProcessInstanceById(processInsId);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        return this.remoteInstanceEngineService.activateProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        InstanceDeleteDto instanceDeleteDto = new InstanceDeleteDto();
        instanceDeleteDto.setProcessInsId(processInsId);
        instanceDeleteDto.setReason(reason);
        return this.remoteInstanceEngineService.deleteProcessInstance(instanceDeleteDto);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        return this.remoteInstanceEngineService.deleteFinishedProcessInstance(processInsId);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        return this.remoteInstanceEngineService.deleteFinishProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessId) {
        return this.remoteInstanceEngineService.deleteProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessId, boolean isValidate) {
        InstanceDeleteByBusinessListDto instanceDeleteByBusinessListDto = new InstanceDeleteByBusinessListDto();
        instanceDeleteByBusinessListDto.setBusinessId(businessId);
        instanceDeleteByBusinessListDto.setIsValidate(isValidate);
        return this.remoteInstanceEngineService.deleteProcessInstanceByBusinessIdList(instanceDeleteByBusinessListDto);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        InstanceQueryFinishedDto instanceQueryFinishedDto = new InstanceQueryFinishedDto();
        instanceQueryFinishedDto.setProcessKey(processKey);
        instanceQueryFinishedDto.setBusinessId(businessId);
        instanceQueryFinishedDto.setPage(page);
        instanceQueryFinishedDto.setRows(rows);
        return this.remoteInstanceEngineService.queryFinishedProcessInstance(instanceQueryFinishedDto);
    }

    public BpmResponseResult queryAllProcessInstance(ProcessInstAllQueryDto processInstAllQueryDto) {
        return this.remoteInstanceEngineService.queryAllProcessInstance(processInstAllQueryDto);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        return this.remoteInstanceEngineService.queryProcessInstanceCompleteState(processInsId);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessId) {
        return this.remoteInstanceEngineService.queryProcessInstanceCompleteStateByBusinessId(businessId);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        InstanceGetTraceDto instanceGetTraceDto = new InstanceGetTraceDto();
        instanceGetTraceDto.setProcessInsId(processInsId);
        return this.remoteInstanceEngineService.getProcessTrace(instanceGetTraceDto);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        InstanceGetTraceDto instanceGetTraceDto = new InstanceGetTraceDto();
        instanceGetTraceDto.setProcessInsId(processInsId);
        instanceGetTraceDto.setSubProcessKey(subProcessKey);
        instanceGetTraceDto.setCycleCount(cycleCount);
        return this.remoteInstanceEngineService.getAllProcessTrace(instanceGetTraceDto);
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId) {
        InstanceQueryActivityTaskDto instanceQueryActivityTaskDto = new InstanceQueryActivityTaskDto();
        instanceQueryActivityTaskDto.setBusinessId(businessId);
        instanceQueryActivityTaskDto.setProcessInsId(processInsId);
        return this.remoteInstanceEngineService.queryCallActivityTask(instanceQueryActivityTaskDto);
    }

    public BpmResponseResult queryMainActivityTask(String businessId, String processInsId) {
        InstanceQueryActivityTaskDto instanceQueryActivityTaskDto = new InstanceQueryActivityTaskDto();
        instanceQueryActivityTaskDto.setBusinessId(businessId);
        instanceQueryActivityTaskDto.setProcessInsId(processInsId);
        return this.remoteInstanceEngineService.queryMainActivityTask(instanceQueryActivityTaskDto);
    }

    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessId, int page, int size) {
        InstanceGetTraceByBusinessKeyDto instanceGetTraceByBusinessKeyDto = new InstanceGetTraceByBusinessKeyDto();
        instanceGetTraceByBusinessKeyDto.setBusinessId(businessId);
        instanceGetTraceByBusinessKeyDto.setPage(page);
        instanceGetTraceByBusinessKeyDto.setSize(size);
        return this.remoteInstanceEngineService.getAllProcessTraceByBusinessId(instanceGetTraceByBusinessKeyDto);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        InstanceQueryCommentDto instanceQueryCommentDto = new InstanceQueryCommentDto();
        instanceQueryCommentDto.setBusinessId(businessId);
        instanceQueryCommentDto.setProcessInsId(processInsId);
        return this.remoteInstanceEngineService.queryCompletecomment(instanceQueryCommentDto);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        return this.remoteInstanceEngineService.queryProcessDefinitionByInstanceId(processInsId);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        InstanceEndDto instanceEndDto = new InstanceEndDto();
        instanceEndDto.setTaskId(taskId);
        instanceEndDto.setUserId(userId);
        instanceEndDto.setReason(reason);
        return this.remoteInstanceEngineService.endProcess(instanceEndDto);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        InstanceEndDto instanceEndDto = new InstanceEndDto();
        instanceEndDto.setBusinessId(businessId);
        instanceEndDto.setProcessInstanceId(processInsId);
        instanceEndDto.setUserId(userId);
        instanceEndDto.setReason(comment);
        return this.remoteInstanceEngineService.endProcessByBusinessIdOrProcessInsId(instanceEndDto);
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        return this.remoteInstanceEngineService.queryProcessByStarter(processQueryByStarterDto.setCurrent(page.getCurrent()).setSize(page.getSize()));
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return this.remoteInstanceEngineService.revokeProcess(processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return this.remoteInstanceEngineService.queryProcessInstance(processDto);
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        CountersignNodesDto countersignNodesDto = new CountersignNodesDto();
        countersignNodesDto.setTaskId(taskId);
        countersignNodesDto.setProcessInsId(processInsId);
        countersignNodesDto.setBusinessId(businessId);
        countersignNodesDto.setProcessKey(processKey);
        countersignNodesDto.setVersion(version);
        return this.remoteInstanceEngineService.queryAllCountersignNodes(countersignNodesDto);
    }

    public BpmResponseResult queryCurrentNodes(String processInstanceId, String businessId) {
        InstanceQueryCommentDto instanceQueryCommentDto = new InstanceQueryCommentDto();
        instanceQueryCommentDto.setBusinessId(businessId);
        instanceQueryCommentDto.setProcessInsId(processInstanceId);
        return this.remoteInstanceEngineService.queryCurrentNodes(instanceQueryCommentDto);
    }

    public BpmResponseResult queryFlowHistoryInfo(String businessId, String processInstId) {
        InstanceQueryCommentDto instanceQueryCommentDto = new InstanceQueryCommentDto();
        instanceQueryCommentDto.setBusinessId(businessId);
        instanceQueryCommentDto.setProcessInsId(processInstId);
        return this.remoteInstanceEngineService.queryFlowHistoryInfo(instanceQueryCommentDto);
    }

    public BpmResponseResult editProcessTitle(EditPrcessTileDto editPrcessTileDto) {
        return this.remoteInstanceEngineService.editProcessTitle(editPrcessTileDto);
    }
}

