/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.AutoIntegrationConfiguration;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.manage.engine.service.BpmPluginUserApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmPluginUtil;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class RemoteBpmPluginUserApiService
implements BpmPluginUserApiService {
    @Resource
    @Lazy
    private AutoIntegrationConfiguration autoIntegrationConfiguration;
    private static PluginUser pluginUser;

    public <T> T getPluginBean(Long appId, String beanId, String appCode) {
        if (!this.autoIntegrationConfiguration.enable()) {
            return null;
        }
        if (pluginUser == null) {
            pluginUser = (PluginUser)BpmSpringContextHolder.getBean(PluginUser.class);
        }
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        if (HussarUtils.isNotEmpty((Object)appCode)) {
            tcode = BpmPluginUtil.asIdentifier((String)tcode);
            appCode = BpmPluginUtil.asIdentifier((String)appCode);
            String serviceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
            serviceName = BpmPluginUtil.asIdentifier((String)serviceName);
            String pluginId = tcode + "-" + serviceName + "-" + appCode;
            Object t = pluginUser.getPluginBeans(pluginId, beanId);
            if (t != null) {
                return (T)t;
            }
        }
        return (T)pluginUser.getBean(beanId);
    }
}

