/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.QueryProcessTaskCountDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAddAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskClaimDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskDelAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEditCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryAllToDoByBusinessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryAllToDoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryFinishedByPageDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryFinishedDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryRejectNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryToDoByBusinessIdDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryToDoByPageDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryToDoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReStartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskUpdateLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskUpdateStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.AssigneeConditionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteAddCustomNodeService;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteTaskEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.service.TaskEngineApiService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteTaskEngineApiServiceImpl
implements TaskEngineApiService {
    @Autowired
    private RemoteTaskEngineService remoteTaskEngineService;
    @Autowired
    private RemoteAddCustomNodeService remoteAddCustomNodeService;

    public ApiResponse<Map<String, Object>> queryTask(String taskId) {
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        taskQueryDto.setTaskId(taskId);
        return this.remoteTaskEngineService.queryTask(taskQueryDto);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, Integer page, Integer size) {
        TaskQueryAllToDoDto taskQueryAllToDoDto = new TaskQueryAllToDoDto();
        taskQueryAllToDoDto.setProcessName(processName);
        taskQueryAllToDoDto.setProcessKey(processKey);
        taskQueryAllToDoDto.setStartTime(startTime);
        taskQueryAllToDoDto.setEndTime(endTime);
        taskQueryAllToDoDto.setTimeoutState(timeoutState);
        taskQueryAllToDoDto.setSuspensionState(suspensionState);
        taskQueryAllToDoDto.setTodoConfiguration(todoConfiguration);
        taskQueryAllToDoDto.setPage(page);
        taskQueryAllToDoDto.setSize(size);
        return this.remoteTaskEngineService.queryAllToDoTaskList(taskQueryAllToDoDto);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, Integer page, Integer size) {
        TaskQueryAllToDoByBusinessDto taskQueryAllToDoDto = new TaskQueryAllToDoByBusinessDto();
        taskQueryAllToDoDto.setProcessName(processName);
        taskQueryAllToDoDto.setProcessKey(processKey);
        taskQueryAllToDoDto.setStartTime(startTime);
        taskQueryAllToDoDto.setEndTime(endTime);
        taskQueryAllToDoDto.setTimeoutState(timeoutState);
        taskQueryAllToDoDto.setSuspensionState(suspensionState);
        taskQueryAllToDoDto.setTodoConfiguration(todoConfiguration);
        taskQueryAllToDoDto.setBusiness(JSON.toJSONString(businessList));
        taskQueryAllToDoDto.setPage(page);
        taskQueryAllToDoDto.setSize(size);
        return this.remoteTaskEngineService.queryAllToDoTaskListByBusiness(taskQueryAllToDoDto);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey) {
        TaskQueryToDoDto taskQueryToDoDto = new TaskQueryToDoDto();
        taskQueryToDoDto.setUserId(userId);
        taskQueryToDoDto.setProcessKey(processKey);
        taskQueryToDoDto.setDefinitionKey(definitionKey);
        return this.remoteTaskEngineService.queryToDoTaskList(taskQueryToDoDto);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        return this.remoteTaskEngineService.queryToDoTaskList(new TaskQueryToDoByPageDto(userId, processKey, definitionKey, page, rows));
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, List<String> businessIds) {
        TaskQueryToDoByBusinessIdDto taskQueryToDoByBusinessIdDto = new TaskQueryToDoByBusinessIdDto();
        taskQueryToDoByBusinessIdDto.setUserId(userId).setBusinessIds(String.join((CharSequence)",", businessIds));
        return this.remoteTaskEngineService.queryToDoTaskList(taskQueryToDoByBusinessIdDto);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return this.remoteTaskEngineService.queryToDoTaskList(flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey) {
        return this.remoteTaskEngineService.queryFinishedTaskList(new TaskQueryFinishedDto().setUserId(userId).setProcessKey(processKey).setDefinitionKey(definitionKey));
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        return this.remoteTaskEngineService.queryFinishedTaskList(new TaskQueryFinishedByPageDto().setUserId(userId).setProcessKey(processKey).setDefinitionKey(definitionKey).setPage(page).setRows(rows));
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return this.remoteTaskEngineService.queryFinishTaskList(flowTaskQueryModel);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCount(String userId) {
        return this.remoteTaskEngineService.queryUserTaskCount(userId);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCountByNode(String userId) {
        return this.remoteTaskEngineService.queryUserTaskCountByNode(userId);
    }

    public BpmResponseResult queryToDoList(FlowTaskDto flowTaskDto) {
        return this.remoteTaskEngineService.queryToDoList(flowTaskDto);
    }

    public BpmResponseResult queryDoneList(FlowTaskDto flowTaskDto) {
        return this.remoteTaskEngineService.queryDoneList(flowTaskDto);
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        return this.remoteTaskEngineService.claimTask(new TaskClaimDto().setTaskId(taskId).setUserId(userId));
    }

    public BpmResponseResult unClaimTask(String taskId) {
        return this.remoteTaskEngineService.unClaimTask(taskId);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask1(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask2(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask3(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask4(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask5(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setComment(comment).setCallActivities(subProcesses).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask6(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setUsers(JSON.toJSONString(users)).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeTask7(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setUsers(JSON.toJSONString(users)).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeTask(TaskCompleteDto taskCompleteDto) {
        return this.remoteTaskEngineService.completeTask8(taskCompleteDto);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.completeLeapTask(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        return this.remoteTaskEngineService.completeLeapTask(new TaskCompleteDto().setTaskId(taskId).setUserId(userId).setAssigneeMap(JSON.toJSONString(assigneeMap)).setUsers(JSON.toJSONString(users)).setComment(comment).setMap(JSON.toJSONString(map)).setIsSubmit(isSubmit));
    }

    public BpmResponseResult completeLeapTask(TaskCompleteDto taskCompleteDto) {
        return this.remoteTaskEngineService.completeLeapTask2(taskCompleteDto);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        return this.remoteTaskEngineService.queryRejectComment(taskId);
    }

    public BpmResponseResult setTimeoutPeriod(String taskId, Date timeout) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = simpleDateFormat.format(timeout);
        return this.remoteTaskEngineService.setTimeoutPeriod(taskId, timeStr);
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean canRejectToMainProcess, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.rejectToLastTask(new TaskRejectDto().setTaskId(taskId).setUserId(userId).setComment(comment).setAssignees(assignees).setCanRejectToMainProcess(canRejectToMainProcess).setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
        }
        return this.remoteTaskEngineService.rejectToLastTask(taskRejectDto);
    }

    public BpmResponseResult getRejectNode(String taskId, boolean isSbumit, Map<String, Object> map) {
        return this.remoteTaskEngineService.getRejectNode(new TaskRejectDto().setTaskId(taskId).setIsSubmit(isSbumit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.rejectToFirstTask(new TaskRejectDto().setTaskId(taskId).setUserId(userId).setComment(comment).setAssignees(assignees).setIsSubProcessFirst(isSubProcessFirst).setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
        }
        return this.remoteTaskEngineService.rejectToFirstTask(taskRejectDto);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.rejectToFirstTask(new TaskRejectDto().setTaskId(taskId).setUserId(userId).setComment(comment).setAssignees("").setIsSubProcessFirst(isSubProcessFirst).setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.rejectToAnyTask(new TaskRejectDto().setTaskId(taskId).setUserId(userId).setBackActivityId(backActivityId).setComment(comment).setAssignees(assignees).setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.rejectToAnyTask(new TaskRejectDto().setTaskId(taskId).setUserId(userId).setBackActivityId(backActivityId).setComment(comment).setAssignees("").setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        if (HussarUtils.isNotEmpty((Object)taskRejectDto.getVariable())) {
            String map = JSON.toJSONString((Object)taskRejectDto.getVariable());
            taskRejectDto.setVariable(null);
            taskRejectDto.setMap(map);
        }
        return this.remoteTaskEngineService.rejectToAnyTask(taskRejectDto);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean isGetMainProcess) {
        TaskQueryRejectNodeDto taskQueryRejectNodeDto = new TaskQueryRejectNodeDto(taskId, isGetMainProcess);
        return this.remoteTaskEngineService.queryRejectNode(taskQueryRejectNodeDto);
    }

    public BpmResponseResult queryJumpNode(String taskId, boolean isGetMainProcess) {
        TaskQueryRejectNodeDto taskQueryRejectNodeDto = new TaskQueryRejectNodeDto(taskId, isGetMainProcess);
        return this.remoteTaskEngineService.queryJumpNode(taskQueryRejectNodeDto);
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        return this.remoteTaskEngineService.delegateTask(new TaskEntrustDto().setTaskId(taskId).setUserId(userId));
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        return this.remoteTaskEngineService.entrustTask(new TaskEntrustDto().setTaskId(taskId).setUserId(userId).setMandatary(mandatary));
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary) {
        return this.remoteTaskEngineService.entrustTaskByTaskId(new TaskEntrustDto().setTaskId(taskId).setMandatary(mandatary));
    }

    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        return this.remoteTaskEngineService.entrustTask(taskEntrustDto);
    }

    public BpmResponseResult freeJump(String taskId, String targetTaskDefinitionKey, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        return this.remoteTaskEngineService.freeJump(new TaskRejectDto().setTaskId(taskId).setActivityId(targetTaskDefinitionKey).setUserId(userId).setAssignees(assignees).setIsSubmit(isSubmit).setComment(comment).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult freeJump(TaskFreeJumpDto taskFreeJumpDto) {
        return this.remoteTaskEngineService.freeJump2(taskFreeJumpDto);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList, boolean isSeqMultiAddLastAssignee) {
        return this.remoteTaskEngineService.multiInstanceAddAssignee(new TaskAddAssigneeDto().setTaskId(taskId).setAssigneeList(JSON.toJSONString(assigneeList)).setSeqMultiAddLastAssignee(isSeqMultiAddLastAssignee));
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return this.remoteTaskEngineService.queryAssigneeByTaskId(taskId);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        return this.remoteTaskEngineService.addAssignees(new TaskAddAssigneeDto().setTaskId(taskId).setBusinessId(businessId).setUserIds(users));
    }

    public BpmResponseResult taskAddAssignee(String taskId, String userIds, boolean isSeqMultiAddLastAssignee) {
        return this.remoteTaskEngineService.taskAddAssignee(new TaskAddAssigneeDto().setTaskId(taskId).setMandatary(userIds).setSeqMultiAddLastAssignee(isSeqMultiAddLastAssignee));
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return this.remoteTaskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        return this.remoteTaskEngineService.queryNextAssigneeByTaskIdAndNodeId(new TaskQueryNextAssigneeDto().setTaskId(taskId).setNodeId(nodeId).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        NextAssigneeQueryDto nextAssigneeQueryDto = new NextAssigneeQueryDto();
        nextAssigneeQueryDto.setProcessKey(processKey);
        nextAssigneeQueryDto.setTaskId(taskId);
        nextAssigneeQueryDto.setNodeId(nodeId);
        nextAssigneeQueryDto.setMap(map);
        nextAssigneeQueryDto.setRemotePage(false);
        return this.remoteTaskEngineService.queryNextAssignee(nextAssigneeQueryDto);
    }

    public BpmResponseResult queryAllAssignee(String processKey) {
        AssigneeConditionDto assigneeConditionDto = new AssigneeConditionDto();
        assigneeConditionDto.setProcessKey(processKey);
        return this.remoteTaskEngineService.queryAllAssignee(assigneeConditionDto);
    }

    public BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(String processKey, String taskDefinitionKey) {
        AssigneeConditionDto assigneeConditionDto = new AssigneeConditionDto();
        assigneeConditionDto.setProcessKey(processKey);
        assigneeConditionDto.setTaskDefinitionKey(taskDefinitionKey);
        return this.remoteTaskEngineService.queryAllAssignee(assigneeConditionDto);
    }

    public BpmResponseResult queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        return this.remoteTaskEngineService.queryNodeAssigneeAndDept(nodeAssigneeQueryDto);
    }

    public BpmResponseResult queryNodeAssigneeListByPage(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        return this.remoteTaskEngineService.queryNodeAssigneeListByPage(nodeAssigneeQueryDto);
    }

    public ApiResponse<Map<String, Object>> queryHistoryActByTaskId(String taskId) {
        return this.remoteTaskEngineService.queryHistoryActByTaskId(taskId);
    }

    public ApiResponse<JSONObject> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        return this.remoteTaskEngineService.getProcessDefinitionIdAndNodeId(new TaskCommonDto().setTaskId(taskId).setProcessKey(processKey));
    }

    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        return this.remoteTaskEngineService.queryTaskIdByBusinessId(businessId);
    }

    public BpmResponseResult queryTaskByBusinessIdAndProcessInsId(String businessId, String processInsId) {
        return this.remoteTaskEngineService.queryTaskByBusinessIdAndProcessInsId(businessId, processInsId);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        return this.remoteTaskEngineService.queryNextNode(new TaskQueryNextNodeDto().setProcessKey(processKey).setTaskId(taskId).setIsGetRevokeNode(isGetRevokeNode).setIsGetWithGroup(isGetWithGroup).setLineCondition(JSON.toJSONString(lineCondition)));
    }

    public BpmResponseResult predictNextNode(String processKey, String taskId, String userId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        return this.remoteTaskEngineService.predictNextNode(new TaskQueryNextNodeDto().setProcessKey(processKey).setTaskId(taskId).setUserId(userId).setIsGetRevokeNode(isGetRevokeNode).setIsGetWithGroup(isGetWithGroup).setLineCondition(JSON.toJSONString(lineCondition)));
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        return this.remoteTaskEngineService.withdrawState(historicTaskId);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.revokeTask(new TaskRevokeDto().setHistoricTaskId(historicTaskId).setUserId(userId).setComment(comment).setIsSubmit(isSubmit).setMap(map));
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        return this.remoteTaskEngineService.editTaskComment(new TaskEditCommentDto().setTaskId(taskId).setComment(comment));
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        return this.remoteTaskEngineService.reStartProcess(new TaskReStartProcessDto().setProcessInsId(processInsId).setBusinessId(businessId).setTaskDefinitionKey(taskDefinitionKey).setUserId(userId).setAssignee(assignee).setIsSubmit(isSubmit).setMap(JSON.toJSONString(map)));
    }

    public ApiResponse<?> addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        return this.remoteAddCustomNodeService.addCustomNode(taskId, JSON.toJSONString(list), parallel);
    }

    public ApiResponse<?> isAddParallel(String taskId) {
        return this.remoteAddCustomNodeService.isAddParallel(taskId);
    }

    public ApiResponse<?> isAddCustomNode(String taskId) {
        return this.remoteAddCustomNodeService.isAddCustomNode(taskId);
    }

    public BpmResponseResult isTodoTask(String taskId, String userId) {
        return this.remoteTaskEngineService.isTodoTask(taskId, userId);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId) {
        return this.remoteTaskEngineService.multiInstanceDelAssignee(taskId);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        return this.remoteTaskEngineService.multiInstanceDelAssignee(new TaskDelAssigneeDto().setTaskId(taskId).setAssignees(assignees));
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        return this.remoteTaskEngineService.updateUserSecurityLevel(new TaskUpdateLevelDto().setUserId(userId).setLevel(level));
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        return this.remoteTaskEngineService.activeTaskCandidates(taskId);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        return this.remoteTaskEngineService.updateStarter(new TaskUpdateStarterDto().setProcessInsId(processInsId).setBusinessId(businessId).setUserId(userId));
    }

    public BpmResponseResult getExecutionByBusinessKey(String businessId) {
        return this.remoteTaskEngineService.getExecutionByBusinessId(businessId);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> map) {
        return this.remoteTaskEngineService.receiveTaskSignal(new TaskReceiveDto().setExecutionId(executionId).setMap(JSON.toJSONString(map)));
    }

    public BpmResponseResult receiveTaskSignalByProcessInfo(TaskReceiveDto taskReceiveDto) {
        return this.remoteTaskEngineService.receiveTaskSignalByProcessInfo(taskReceiveDto);
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        return this.remoteTaskEngineService.preemptTask(preemptCommonDto);
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        return this.remoteTaskEngineService.unPreemptTask(preemptCommonDto);
    }

    public BpmResponseResult checkNextNodeAssignee(CheckNextNodeAssigneeDto checkNextNodeAssigneeDto) {
        return this.remoteTaskEngineService.checkNextNodeAssignee(checkNextNodeAssigneeDto);
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        return this.remoteTaskEngineService.transferTask(transferDto);
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        return this.remoteTaskEngineService.getTransferProgressInfo(transferId);
    }

    public BpmResponseResult queryProcessTaskCount(QueryProcessTaskCountDto queryProcessTaskCountDto) {
        return this.remoteTaskEngineService.queryProcessTaskCount(queryProcessTaskCountDto);
    }

    public BpmResponseResult getCountAllTotal(String userId) {
        return this.remoteTaskEngineService.getCountAllTotal(userId);
    }

    public BpmResponseResult getAllCounts(String userId, String todoConfiguration, String processKey) {
        return this.remoteTaskEngineService.getAllCounts(userId, todoConfiguration, processKey);
    }

    public BpmResponseResult delCustomNode(String taskId, String nodeId, String userId) {
        return this.remoteAddCustomNodeService.delCustomNode(taskId, nodeId, userId);
    }

    public BpmResponseResult queryDelNode(String taskId) {
        return this.remoteAddCustomNodeService.queryDelNode(taskId);
    }

    public BpmResponseResult taskAvoidSuspicion(String taskId, String userId, String avoidComment) {
        return this.remoteTaskEngineService.taskAvoidSuspicion(taskId, userId, avoidComment);
    }
}

